/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryImageInfoDownloaderThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySequenceDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySignDownloaderThread;
import org.openstreetmap.josm.tools.I18n;

public class MapillarySquareDownloadManagerThread
implements Runnable {
    private final String urlImages;
    private final String urlSequences;
    private final String urlSigns;

    public MapillarySquareDownloadManagerThread(String urlImages, String urlSequences, String urlSigns) {
        this.urlImages = urlImages;
        this.urlSequences = urlSequences;
        this.urlSigns = urlSigns;
    }

    @Override
    public void run() {
        Main.map.statusLine.setHelpText("Downloading images from Mapillary");
        try {
            this.downloadSequences();
            Main.map.statusLine.setHelpText("Downloading image's information");
            this.completeImages();
            Main.map.statusLine.setHelpText("Downloading signs");
            this.downloadSigns();
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
        if (MapillaryData.getInstance().getImages().size() > 0) {
            Main.map.statusLine.setHelpText(I18n.tr((String)"Total images: ", (Object[])new Object[0]) + MapillaryData.getInstance().getImages().size());
        } else {
            Main.map.statusLine.setHelpText(I18n.tr((String)"No images found", (Object[])new Object[0]));
        }
        MapillaryData.getInstance().dataUpdated();
    }

    private void downloadSequences() throws InterruptedException {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillarySequenceDownloadThread(ex, this.urlSequences + "&page=" + page + "&limit=1"));
            while (ex.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        ex.awaitTermination(15L, TimeUnit.SECONDS);
        MapillaryData.getInstance().dataUpdated();
    }

    private void completeImages() throws InterruptedException {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillaryImageInfoDownloaderThread(ex, this.urlImages + "&page=" + page + "&limit=20"));
            while (ex.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        ex.awaitTermination(15L, TimeUnit.SECONDS);
    }

    private void downloadSigns() throws InterruptedException {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillarySignDownloaderThread(ex, this.urlSigns + "&page=" + page + "&limit=20"));
            while (ex.getQueue().remainingCapacity() == 0) {
                Thread.sleep(100L);
            }
            ++page;
        }
        ex.awaitTermination(15L, TimeUnit.SECONDS);
    }
}

