/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public class MapillaryImage
extends MapillaryAbstractImage {
    private final String key;
    private MapillarySequence sequence;
    private long capturedAt;
    private String user;
    private List<String> signs;
    private String location;

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public MapillaryImage(String key, double lat, double lon, double ca) {
        super(lat, lon, ca);
        this.key = key;
        this.signs = new ArrayList<String>();
    }

    public String getKey() {
        return this.key;
    }

    public void addSign(String sign) {
        this.signs.add(sign);
    }

    public List<String> getSigns() {
        return this.signs;
    }

    public void setCapturedAt(long capturedAt) {
        this.capturedAt = capturedAt;
    }

    public long getCapturedAt() {
        return this.capturedAt;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public void setSequence(MapillarySequence sequence) {
        this.sequence = sequence;
    }

    public MapillarySequence getSequence() {
        return this.sequence;
    }

    public String toString() {
        return "Image[key=" + this.key + ";lat=" + this.latLon.lat() + ";lon=" + this.latLon.lon() + ";ca=" + this.ca + "]";
    }

    public MapillaryImage next() {
        if (this.getSequence() == null) {
            return null;
        }
        return this.getSequence().next(this);
    }

    public MapillaryImage previous() {
        if (this.getSequence() == null) {
            return null;
        }
        return this.getSequence().previous(this);
    }

    public String getDate() {
        Date date = new Date(this.getCapturedAt());
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy - hh:mm:ss");
        return formatter.format(date);
    }

    public boolean equals(Object object) {
        if (object instanceof MapillaryImage) {
            return this.key.equals(((MapillaryImage)object).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }
}

