/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openstreetmap.josm.plugins.mapillary.gui.HyperlinkLabel;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryImageDisplay
extends JComponent {
    private static final int DRAG_BUTTON = 3;
    private static final int OPTION_BUTTON = 2;
    private static final int ZOOM_BUTTON = 1;
    private transient BufferedImage image = null;
    private Rectangle visibleRect = null;
    private Rectangle selectedRect = null;
    public HyperlinkLabel hyperlink;

    public MapillaryImageDisplay() {
        ImgDisplayMouseListener mouseListener = new ImgDisplayMouseListener();
        this.addMouseListener(mouseListener);
        this.addMouseWheelListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.setLayout(new BorderLayout());
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BorderLayout());
        this.hyperlink = new HyperlinkLabel();
        southPanel.add((Component)this.hyperlink, "East");
        southPanel.setOpaque(false);
        this.add((Component)southPanel, "South");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(BufferedImage image) {
        MapillaryImageDisplay mapillaryImageDisplay = this;
        synchronized (mapillaryImageDisplay) {
            this.image = image;
            this.selectedRect = null;
            if (image != null) {
                this.visibleRect = new Rectangle(0, 0, image.getWidth(null), image.getHeight(null));
            }
        }
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Rectangle visibleRect;
        BufferedImage image;
        MapillaryImageDisplay mapillaryImageDisplay = this;
        synchronized (mapillaryImageDisplay) {
            image = this.image;
            visibleRect = this.visibleRect;
        }
        if (image == null) {
            g.setColor(Color.black);
            String noImageStr = I18n.tr((String)"No image", (Object[])new Object[0]);
            Rectangle2D noImageSize = g.getFontMetrics(g.getFont()).getStringBounds(noImageStr, g);
            Dimension size = this.getSize();
            g.drawString(noImageStr, (int)(((double)size.width - noImageSize.getWidth()) / 2.0), (int)(((double)size.height - noImageSize.getHeight()) / 2.0));
        } else {
            Rectangle target = this.calculateDrawImageRectangle(visibleRect);
            g.drawImage(image, target.x, target.y, target.x + target.width, target.y + target.height, visibleRect.x, visibleRect.y, visibleRect.x + visibleRect.width, visibleRect.y + visibleRect.height, null);
            if (this.selectedRect != null) {
                Point topLeft = this.img2compCoord(visibleRect, this.selectedRect.x, this.selectedRect.y);
                Point bottomRight = this.img2compCoord(visibleRect, this.selectedRect.x + this.selectedRect.width, this.selectedRect.y + this.selectedRect.height);
                g.setColor(new Color(128, 128, 128, 180));
                g.fillRect(target.x, target.y, target.width, topLeft.y - target.y);
                g.fillRect(target.x, target.y, topLeft.x - target.x, target.height);
                g.fillRect(bottomRight.x, target.y, target.x + target.width - bottomRight.x, target.height);
                g.fillRect(target.x, bottomRight.y, target.width, target.y + target.height - bottomRight.y);
                g.setColor(Color.black);
                g.drawRect(topLeft.x, topLeft.y, bottomRight.x - topLeft.x, bottomRight.y - topLeft.y);
            }
        }
    }

    private final Point img2compCoord(Rectangle visibleRect, int xImg, int yImg) {
        Rectangle drawRect = this.calculateDrawImageRectangle(visibleRect);
        return new Point(drawRect.x + (xImg - visibleRect.x) * drawRect.width / visibleRect.width, drawRect.y + (yImg - visibleRect.y) * drawRect.height / visibleRect.height);
    }

    private final Point comp2imgCoord(Rectangle visibleRect, int xComp, int yComp) {
        Rectangle drawRect = this.calculateDrawImageRectangle(visibleRect);
        return new Point(visibleRect.x + (xComp - drawRect.x) * visibleRect.width / drawRect.width, visibleRect.y + (yComp - drawRect.y) * visibleRect.height / drawRect.height);
    }

    private final Point getCenterImgCoord(Rectangle visibleRect) {
        return new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
    }

    private Rectangle calculateDrawImageRectangle(Rectangle visibleRect) {
        return MapillaryImageDisplay.calculateDrawImageRectangle(visibleRect, new Rectangle(0, 0, this.getSize().width, this.getSize().height));
    }

    static Rectangle calculateDrawImageRectangle(Rectangle imgRect, Rectangle compRect) {
        int x = 0;
        int y = 0;
        int w = compRect.width;
        int wFact = w * imgRect.height;
        int h = compRect.height;
        int hFact = h * imgRect.width;
        if (wFact != hFact) {
            if (wFact > hFact) {
                w = hFact / imgRect.height;
                x = (compRect.width - w) / 2;
            } else {
                h = wFact / imgRect.width;
                y = (compRect.height - h) / 2;
            }
        }
        return new Rectangle(x + compRect.x, y + compRect.y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoomBestFitOrOne() {
        Rectangle visibleRect;
        BufferedImage image;
        MapillaryImageDisplay mapillaryImageDisplay = this;
        synchronized (mapillaryImageDisplay) {
            image = this.image;
            visibleRect = this.visibleRect;
        }
        if (image == null) {
            return;
        }
        if (visibleRect.width != ((Image)image).getWidth(null) || visibleRect.height != ((Image)image).getHeight(null)) {
            visibleRect = new Rectangle(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null));
        } else {
            Point center = this.getCenterImgCoord(visibleRect);
            visibleRect = new Rectangle(center.x - this.getWidth() / 2, center.y - this.getHeight() / 2, this.getWidth(), this.getHeight());
            this.checkVisibleRectPos(image, visibleRect);
        }
        mapillaryImageDisplay = this;
        synchronized (mapillaryImageDisplay) {
            this.visibleRect = visibleRect;
        }
        this.repaint();
    }

    private final void checkVisibleRectPos(Image image, Rectangle visibleRect) {
        if (visibleRect.x < 0) {
            visibleRect.x = 0;
        }
        if (visibleRect.y < 0) {
            visibleRect.y = 0;
        }
        if (visibleRect.x + visibleRect.width > image.getWidth(null)) {
            visibleRect.x = image.getWidth(null) - visibleRect.width;
        }
        if (visibleRect.y + visibleRect.height > image.getHeight(null)) {
            visibleRect.y = image.getHeight(null) - visibleRect.height;
        }
    }

    private void checkVisibleRectSize(Image image, Rectangle visibleRect) {
        if (visibleRect.width > image.getWidth(null)) {
            visibleRect.width = image.getWidth(null);
        }
        if (visibleRect.height > image.getHeight(null)) {
            visibleRect.height = image.getHeight(null);
        }
    }

    private class ImgDisplayMouseListener
    implements MouseListener,
    MouseWheelListener,
    MouseMotionListener {
        private boolean mouseIsDragging = false;
        private long lastTimeForMousePoint = 0L;
        private Point mousePointInImg = null;

        private ImgDisplayMouseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int wFact;
            int hFact;
            Rectangle visibleRect;
            BufferedImage image;
            MapillaryImageDisplay mapillaryImageDisplay = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay) {
                image = MapillaryImageDisplay.this.image;
                visibleRect = MapillaryImageDisplay.this.visibleRect;
            }
            this.mouseIsDragging = false;
            MapillaryImageDisplay.this.selectedRect = null;
            if (image == null) {
                return;
            }
            if (e.getWhen() - this.lastTimeForMousePoint > 1500L || this.mousePointInImg == null) {
                this.lastTimeForMousePoint = e.getWhen();
                this.mousePointInImg = MapillaryImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
            }
            if (e.getWheelRotation() > 0) {
                visibleRect.width = visibleRect.width * 3 / 2;
                visibleRect.height = visibleRect.height * 3 / 2;
            } else {
                visibleRect.width = visibleRect.width * 2 / 3;
                visibleRect.height = visibleRect.height * 2 / 3;
            }
            if (visibleRect.width < MapillaryImageDisplay.this.getSize().width / 2) {
                visibleRect.width = MapillaryImageDisplay.this.getSize().width / 2;
            }
            if (visibleRect.height < MapillaryImageDisplay.this.getSize().height / 2) {
                visibleRect.height = MapillaryImageDisplay.this.getSize().height / 2;
            }
            if ((hFact = visibleRect.height * MapillaryImageDisplay.this.getSize().width) > (wFact = visibleRect.width * MapillaryImageDisplay.this.getSize().height)) {
                visibleRect.width = hFact / MapillaryImageDisplay.this.getSize().height;
            } else {
                visibleRect.height = wFact / MapillaryImageDisplay.this.getSize().width;
            }
            MapillaryImageDisplay.this.checkVisibleRectSize(image, visibleRect);
            Rectangle drawRect = MapillaryImageDisplay.this.calculateDrawImageRectangle(visibleRect);
            visibleRect.x = this.mousePointInImg.x + (drawRect.x - e.getX()) * visibleRect.width / drawRect.width;
            visibleRect.y = this.mousePointInImg.y + (drawRect.y - e.getY()) * visibleRect.height / drawRect.height;
            MapillaryImageDisplay.this.checkVisibleRectPos(image, visibleRect);
            MapillaryImageDisplay mapillaryImageDisplay2 = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay2) {
                MapillaryImageDisplay.this.visibleRect = visibleRect;
            }
            MapillaryImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseClicked(MouseEvent e) {
            Rectangle visibleRect;
            BufferedImage image;
            MapillaryImageDisplay mapillaryImageDisplay = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay) {
                image = MapillaryImageDisplay.this.image;
                visibleRect = MapillaryImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (e.getButton() == 2) {
                if (!MapillaryImageDisplay.this.visibleRect.equals(new Rectangle(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null)))) {
                    MapillaryImageDisplay.this.visibleRect = new Rectangle(0, 0, ((Image)image).getWidth(null), ((Image)image).getHeight(null));
                } else {
                    MapillaryImageDisplay.this.visibleRect = new Rectangle(0, (((Image)image).getHeight(null) - ((Image)image).getWidth(null) * MapillaryImageDisplay.this.getHeight() / MapillaryImageDisplay.this.getWidth()) / 2, ((Image)image).getWidth(null), ((Image)image).getWidth(null) * MapillaryImageDisplay.this.getHeight() / MapillaryImageDisplay.this.getWidth());
                }
                MapillaryImageDisplay.this.repaint();
                return;
            }
            if (e.getButton() != 3) {
                return;
            }
            Point click = MapillaryImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
            Point center = MapillaryImageDisplay.this.getCenterImgCoord(visibleRect);
            visibleRect.x += click.x - center.x;
            visibleRect.y += click.y - center.y;
            MapillaryImageDisplay.this.checkVisibleRectPos(image, visibleRect);
            MapillaryImageDisplay mapillaryImageDisplay2 = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay2) {
                MapillaryImageDisplay.this.visibleRect = visibleRect;
            }
            MapillaryImageDisplay.this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent e) {
            Rectangle visibleRect;
            BufferedImage image;
            if (MapillaryImageDisplay.this.image == null) {
                this.mouseIsDragging = false;
                MapillaryImageDisplay.this.selectedRect = null;
                return;
            }
            MapillaryImageDisplay mapillaryImageDisplay = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay) {
                image = MapillaryImageDisplay.this.image;
                visibleRect = MapillaryImageDisplay.this.visibleRect;
            }
            if (image == null) {
                return;
            }
            if (e.getButton() == 3) {
                this.mousePointInImg = MapillaryImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                this.mouseIsDragging = true;
                MapillaryImageDisplay.this.selectedRect = null;
            } else if (e.getButton() == 1) {
                this.mousePointInImg = MapillaryImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                this.checkPointInVisibleRect(this.mousePointInImg, visibleRect);
                this.mouseIsDragging = false;
                MapillaryImageDisplay.this.selectedRect = new Rectangle(this.mousePointInImg.x, this.mousePointInImg.y, 0, 0);
                MapillaryImageDisplay.this.repaint();
            } else {
                this.mouseIsDragging = false;
                MapillaryImageDisplay.this.selectedRect = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseDragged(MouseEvent e) {
            Point p;
            Rectangle visibleRect;
            BufferedImage image;
            if (!this.mouseIsDragging && MapillaryImageDisplay.this.selectedRect == null) {
                return;
            }
            MapillaryImageDisplay mapillaryImageDisplay = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay) {
                image = MapillaryImageDisplay.this.image;
                visibleRect = MapillaryImageDisplay.this.visibleRect;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                MapillaryImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                p = MapillaryImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                visibleRect.x += this.mousePointInImg.x - p.x;
                visibleRect.y += this.mousePointInImg.y - p.y;
                MapillaryImageDisplay.this.checkVisibleRectPos(image, visibleRect);
                MapillaryImageDisplay mapillaryImageDisplay2 = MapillaryImageDisplay.this;
                synchronized (mapillaryImageDisplay2) {
                    MapillaryImageDisplay.this.visibleRect = visibleRect;
                }
                MapillaryImageDisplay.this.repaint();
            } else if (MapillaryImageDisplay.this.selectedRect != null) {
                p = MapillaryImageDisplay.this.comp2imgCoord(visibleRect, e.getX(), e.getY());
                this.checkPointInVisibleRect(p, visibleRect);
                Rectangle rect = new Rectangle(p.x < this.mousePointInImg.x ? p.x : this.mousePointInImg.x, p.y < this.mousePointInImg.y ? p.y : this.mousePointInImg.y, p.x < this.mousePointInImg.x ? this.mousePointInImg.x - p.x : p.x - this.mousePointInImg.x, p.y < this.mousePointInImg.y ? this.mousePointInImg.y - p.y : p.y - this.mousePointInImg.y);
                MapillaryImageDisplay.this.checkVisibleRectSize(image, rect);
                MapillaryImageDisplay.this.checkVisibleRectPos(image, rect);
                MapillaryImageDisplay.this.selectedRect = rect;
                MapillaryImageDisplay.this.repaint();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseReleased(MouseEvent e) {
            BufferedImage image;
            if (!this.mouseIsDragging && MapillaryImageDisplay.this.selectedRect == null) {
                return;
            }
            MapillaryImageDisplay mapillaryImageDisplay = MapillaryImageDisplay.this;
            synchronized (mapillaryImageDisplay) {
                image = MapillaryImageDisplay.this.image;
            }
            if (image == null) {
                this.mouseIsDragging = false;
                MapillaryImageDisplay.this.selectedRect = null;
                return;
            }
            if (this.mouseIsDragging) {
                this.mouseIsDragging = false;
            } else if (MapillaryImageDisplay.this.selectedRect != null) {
                int wFact;
                int hFact;
                int oldWidth = ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width;
                int oldHeight = ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height;
                if (((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width < MapillaryImageDisplay.this.getSize().width / 2) {
                    ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width = MapillaryImageDisplay.this.getSize().width / 2;
                }
                if (((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height < MapillaryImageDisplay.this.getSize().height / 2) {
                    ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height = MapillaryImageDisplay.this.getSize().height / 2;
                }
                if ((hFact = ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height * MapillaryImageDisplay.this.getSize().width) > (wFact = ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width * MapillaryImageDisplay.this.getSize().height)) {
                    ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width = hFact / MapillaryImageDisplay.this.getSize().height;
                } else {
                    ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height = wFact / MapillaryImageDisplay.this.getSize().width;
                }
                if (((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width != oldWidth) {
                    ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.x -= (((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.width - oldWidth) / 2;
                }
                if (((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height != oldHeight) {
                    ((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.y -= (((MapillaryImageDisplay)MapillaryImageDisplay.this).selectedRect.height - oldHeight) / 2;
                }
                MapillaryImageDisplay.this.checkVisibleRectSize(image, MapillaryImageDisplay.this.selectedRect);
                MapillaryImageDisplay.this.checkVisibleRectPos(image, MapillaryImageDisplay.this.selectedRect);
                MapillaryImageDisplay mapillaryImageDisplay2 = MapillaryImageDisplay.this;
                synchronized (mapillaryImageDisplay2) {
                    MapillaryImageDisplay.this.visibleRect = MapillaryImageDisplay.this.selectedRect;
                }
                MapillaryImageDisplay.this.selectedRect = null;
                MapillaryImageDisplay.this.repaint();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void checkPointInVisibleRect(Point p, Rectangle visibleRect) {
            if (p.x < visibleRect.x) {
                p.x = visibleRect.x;
            }
            if (p.x > visibleRect.x + visibleRect.width) {
                p.x = visibleRect.x + visibleRect.width;
            }
            if (p.y < visibleRect.y) {
                p.y = visibleRect.y;
            }
            if (p.y > visibleRect.y + visibleRect.height) {
                p.y = visibleRect.y + visibleRect.height;
            }
        }
    }
}

