/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryExportDownloadThread;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryExportWriterThread;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class MapillaryExportManager
extends PleaseWaitRunnable {
    ArrayBlockingQueue<BufferedImage> queue = new ArrayBlockingQueue(10);
    ArrayBlockingQueue<MapillaryAbstractImage> queueImages = new ArrayBlockingQueue(10);
    List<MapillaryAbstractImage> images;
    String path;

    public MapillaryExportManager(List<MapillaryAbstractImage> images, String path) {
        super(I18n.tr((String)"Downloading", (Object[])new Object[0]) + "...", (ProgressMonitor)new PleaseWaitProgressMonitor("Exporting Mapillary Images"), true);
        this.images = images;
        this.path = path;
    }

    public MapillaryExportManager(List<MapillaryImportedImage> images) throws IOException {
        super(I18n.tr((String)"Downloading", (Object[])new Object[0]) + "...", (ProgressMonitor)new PleaseWaitProgressMonitor("Exporting Mapillary Images"), true);
        for (MapillaryImportedImage image : images) {
            this.queue.add(image.getImage());
            this.queueImages.add(image);
        }
    }

    protected void cancel() {
    }

    protected void realRun() throws SAXException, IOException, OsmTransferException {
        Thread writer = new Thread(new MapillaryExportWriterThread(this.path, this.queue, this.queueImages, this.queue.size(), this.getProgressMonitor()));
        writer.start();
        if (this.path == null) {
            try {
                writer.join();
            }
            catch (InterruptedException e) {
                Main.error((Throwable)e);
            }
            return;
        }
        ThreadPoolExecutor ex = new ThreadPoolExecutor(20, 35, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
        for (MapillaryAbstractImage image : this.images) {
            if (image instanceof MapillaryImage) {
                try {
                    ex.execute(new MapillaryExportDownloadThread((MapillaryImage)image, this.queue, this.queueImages));
                }
                catch (Exception e) {
                    Main.error((Throwable)e);
                }
            } else if (image instanceof MapillaryImportedImage) {
                try {
                    this.queue.put(((MapillaryImportedImage)image).getImage());
                    this.queueImages.put((MapillaryImportedImage)image);
                }
                catch (InterruptedException e) {
                    Main.error((Throwable)e);
                }
            }
            try {
                while (ex.getQueue().remainingCapacity() == 0) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                Main.error((Throwable)e);
            }
        }
        try {
            writer.join();
        }
        catch (InterruptedException e) {
            Main.error((Throwable)e);
        }
    }

    protected void finish() {
    }
}

