/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.commands;

import java.util.ArrayList;
import org.openstreetmap.josm.plugins.mapillary.commands.MapillaryCommand;
import org.openstreetmap.josm.plugins.mapillary.commands.MapillaryRecordListener;

public class MapillaryRecord {
    public static MapillaryRecord INSTANCE;
    private ArrayList<MapillaryRecordListener> listeners;
    public ArrayList<MapillaryCommand> commandList = new ArrayList();
    public int position = -1;

    public MapillaryRecord() {
        this.listeners = new ArrayList();
    }

    public static synchronized MapillaryRecord getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryRecord();
        }
        return INSTANCE;
    }

    public void addListener(MapillaryRecordListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(MapillaryRecordListener lis) {
        this.listeners.remove(lis);
    }

    public void addCommand(MapillaryCommand command) {
        if (this.position != -1 && this.commandList.get((int)this.position).images.equals(command.images) && this.commandList.get(this.position).getClass() == command.getClass()) {
            this.commandList.get(this.position).sum(command);
            this.fireRecordChanged();
            return;
        }
        this.commandList.add(this.position + 1, command);
        ++this.position;
        while (this.commandList.size() > this.position + 1) {
            this.commandList.remove(this.position + 1);
        }
        this.fireRecordChanged();
    }

    public void undo() {
        if (this.position == -1) {
            return;
        }
        this.commandList.get(this.position).undo();
        --this.position;
        this.fireRecordChanged();
    }

    public void redo() {
        if (this.position + 1 >= this.commandList.size()) {
            return;
        }
        ++this.position;
        this.commandList.get(this.position).redo();
        this.fireRecordChanged();
    }

    private void fireRecordChanged() {
        for (MapillaryRecordListener lis : this.listeners) {
            if (lis == null) continue;
            lis.recordChanged();
        }
    }
}

