/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.common.RationalNumber;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.constants.GpsTagConstants;
import org.apache.commons.imaging.formats.tiff.taginfos.TagInfo;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class MapillaryImportAction
extends JosmAction {
    public JFileChooser chooser;
    private int noTagsPics = 0;

    public MapillaryImportAction() {
        super(I18n.tr((String)"Import pictures", (Object[])new Object[0]), new ImageProvider("icon24.png"), I18n.tr((String)"Import local pictures", (Object[])new Object[0]), Shortcut.registerShortcut((String)"Import Mapillary", (String)I18n.tr((String)"Import pictures into Mapillary layer", (Object[])new Object[0]), (int)77, (int)5000), false, "mapillaryImport", false);
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent e) {
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.chooser.setDialogTitle(I18n.tr((String)"Select pictures", (Object[])new Object[0]));
        this.chooser.setFileSelectionMode(2);
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.addChoosableFileFilter(new FileNameExtensionFilter("images", "jpg", "jpeg", "png"));
        this.chooser.setMultiSelectionEnabled(true);
        if (this.chooser.showOpenDialog(Main.parent) == 0) {
            for (int i = 0; i < this.chooser.getSelectedFiles().length; ++i) {
                File file = this.chooser.getSelectedFiles()[i];
                if (file.isDirectory()) continue;
                if (file.getPath().substring(file.getPath().length() - 4).equals(".jpg") || file.getPath().substring(file.getPath().length() - 5).equals(".jpeg")) {
                    try {
                        this.readJPG(file);
                    }
                    catch (ImageReadException ex) {
                        Main.error((Throwable)ex);
                    }
                    catch (IOException ex) {
                        Main.error((Throwable)ex);
                    }
                    continue;
                }
                if (!file.getPath().substring(file.getPath().length() - 4).equals(".png")) continue;
                this.readPNG(file);
            }
        }
        MapillaryLayer.getInstance();
    }

    public void readJPG(File file) throws ImageReadException, IOException {
        ImageMetadata metadata = Imaging.getMetadata((File)file);
        if (metadata instanceof JpegImageMetadata) {
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffField lat_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE_REF);
            TiffField lat = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LATITUDE);
            TiffField lon_ref = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE_REF);
            TiffField lon = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_LONGITUDE);
            TiffField ca = jpegMetadata.findEXIFValueWithExactMatch((TagInfo)GpsTagConstants.GPS_TAG_GPS_IMG_DIRECTION);
            double latValue = 0.0;
            double lonValue = 0.0;
            double caValue = 0.0;
            if (lat != null && lat.getValue() instanceof RationalNumber[]) {
                latValue = this.DegMinSecToDouble((RationalNumber[])lat.getValue(), lat_ref.getValue().toString());
            }
            if (lon != null && lon.getValue() instanceof RationalNumber[]) {
                lonValue = this.DegMinSecToDouble((RationalNumber[])lon.getValue(), lon_ref.getValue().toString());
            }
            if (ca != null && ca.getValue() instanceof RationalNumber) {
                caValue = ((RationalNumber)ca.getValue()).doubleValue();
            }
            if (lat_ref.getValue().toString().equals("S")) {
                latValue = -latValue;
            }
            if (lon_ref.getValue().toString().equals("W")) {
                lonValue = -lonValue;
            }
            if (latValue != 0.0 && lonValue != 0.0) {
                MapillaryData.getInstance().add(new MapillaryImportedImage(latValue, lonValue, caValue, file));
            } else {
                this.readNoTags(file);
            }
        }
    }

    private void readNoTags(File file) {
        double HORIZONTAL_DISTANCE = 1.0E-4;
        double horDev = this.noTagsPics % 2 == 0 ? HORIZONTAL_DISTANCE * (double)this.noTagsPics / 2.0 : -HORIZONTAL_DISTANCE * (double)(this.noTagsPics + 1) / 2.0;
        LatLon pos = Main.map.mapView.getProjection().eastNorth2latlon(Main.map.mapView.getCenter());
        MapillaryData.getInstance().add(new MapillaryImportedImage(pos.lat(), pos.lon() + horDev, 0.0, file));
        ++this.noTagsPics;
    }

    private void readPNG(File file) {
        this.readNoTags(file);
    }

    private double DegMinSecToDouble(RationalNumber[] degMinSec, String ref) {
        RationalNumber deg = degMinSec[0];
        RationalNumber min = degMinSec[1];
        RationalNumber sec = degMinSec[2];
        return deg.doubleValue() + min.doubleValue() / 60.0 + sec.doubleValue() / 3600.0;
    }
}

