/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImportedImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.commands.CommandMoveImage;
import org.openstreetmap.josm.plugins.mapillary.commands.CommandTurnImage;
import org.openstreetmap.josm.plugins.mapillary.commands.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.gui.MapillaryToggleDialog;

public class MapillaryMouseAdapter
extends MouseAdapter {
    private Point start;
    private int lastButton;
    private MapillaryAbstractImage closest;
    private MapillaryAbstractImage lastClicked;
    private MapillaryData mapillaryData = MapillaryData.getInstance();
    private MapillaryRecord record = MapillaryRecord.getInstance();
    private boolean nothingHighlighted;

    @Override
    public void mousePressed(MouseEvent e) {
        this.lastButton = e.getButton();
        if (e.getButton() != 1) {
            return;
        }
        MapillaryAbstractImage closestTemp = this.getClosest(e.getPoint());
        if (Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && closestTemp != null) {
            this.lastClicked = this.closest;
            MapillaryData.getInstance().setSelectedImage(closestTemp);
            return;
        }
        if (Main.map.mapView.getActiveLayer() != MapillaryLayer.getInstance()) {
            return;
        }
        if (closestTemp instanceof MapillaryImage || closestTemp == null) {
            MapillaryImage closest = (MapillaryImage)closestTemp;
            if (e.getClickCount() == 2 && this.mapillaryData.getSelectedImage() != null && closest != null) {
                for (MapillaryAbstractImage mapillaryAbstractImage : closest.getSequence().getImages()) {
                    this.mapillaryData.addMultiSelectedImage(mapillaryAbstractImage);
                }
            }
            this.start = e.getPoint();
            this.lastClicked = this.closest;
            this.closest = closest;
            if (this.mapillaryData.getMultiSelectedImages().contains(closest)) {
                return;
            }
            if (e.getModifiers() == 18 && closest != null) {
                this.mapillaryData.addMultiSelectedImage(closest);
            } else if (e.getModifiers() == 17 && this.closest instanceof MapillaryImage && this.lastClicked instanceof MapillaryImage) {
                if (this.closest != null && this.lastClicked != null && ((MapillaryImage)this.closest).getSequence() == ((MapillaryImage)this.lastClicked).getSequence()) {
                    int n;
                    int i = ((MapillaryImage)this.closest).getSequence().getImages().indexOf(this.closest);
                    if (i < (n = ((MapillaryImage)this.lastClicked).getSequence().getImages().indexOf(this.lastClicked))) {
                        this.mapillaryData.addMultiSelectedImage(new ArrayList<MapillaryAbstractImage>(((MapillaryImage)this.closest).getSequence().getImages().subList(i, n + 1)));
                    } else {
                        this.mapillaryData.addMultiSelectedImage(new ArrayList<MapillaryAbstractImage>(((MapillaryImage)this.closest).getSequence().getImages().subList(n, i + 1)));
                    }
                }
            } else {
                this.mapillaryData.setSelectedImage(closest);
            }
        } else if (closestTemp instanceof MapillaryImportedImage) {
            MapillaryImportedImage closest = (MapillaryImportedImage)closestTemp;
            this.start = e.getPoint();
            this.lastClicked = this.closest;
            this.closest = closest;
            if (this.mapillaryData.getMultiSelectedImages().contains(closest)) {
                return;
            }
            if (e.getModifiers() == 18 && closest != null) {
                this.mapillaryData.addMultiSelectedImage(closest);
            } else {
                this.mapillaryData.setSelectedImage(closest);
            }
        }
    }

    private MapillaryAbstractImage getClosest(Point clickPoint) {
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        MapillaryAbstractImage closest = null;
        for (MapillaryAbstractImage image : this.mapillaryData.getImages()) {
            Point imagePoint = Main.map.mapView.getPoint(image.getLatLon());
            imagePoint.setLocation(imagePoint.getX(), imagePoint.getY());
            double dist = clickPoint.distanceSq(imagePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(imagePoint) < snapDistance)) continue;
            minDistance = dist;
            closest = image;
        }
        return closest;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (Main.map.mapView.getActiveLayer() != MapillaryLayer.getInstance()) {
            return;
        }
        if (MapillaryData.getInstance().getSelectedImage() != null) {
            if (this.lastButton == 1 && !e.isShiftDown()) {
                LatLon to = Main.map.mapView.getLatLon(e.getX(), e.getY());
                LatLon from = Main.map.mapView.getLatLon(this.start.getX(), this.start.getY());
                for (MapillaryAbstractImage img : MapillaryData.getInstance().getMultiSelectedImages()) {
                    img.move(to.getX() - from.getX(), to.getY() - from.getY());
                }
                Main.map.repaint();
            } else if (this.lastButton == 1 && e.isShiftDown()) {
                this.closest.turn(Math.toDegrees(Math.atan2(e.getX() - this.start.x, -(e.getY() - this.start.y))) - this.closest.getTempCa());
                for (MapillaryAbstractImage img : MapillaryData.getInstance().getMultiSelectedImages()) {
                    img.turn(Math.toDegrees(Math.atan2(e.getX() - this.start.x, -(e.getY() - this.start.y))) - this.closest.getTempCa());
                }
                Main.map.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.mapillaryData.getSelectedImage() == null) {
            return;
        }
        if (this.mapillaryData.getSelectedImage().getTempCa() != this.mapillaryData.getSelectedImage().getCa()) {
            double from = this.mapillaryData.getSelectedImage().getTempCa();
            double to = this.mapillaryData.getSelectedImage().getCa();
            this.record.addCommand(new CommandTurnImage(this.mapillaryData.getMultiSelectedImages(), to - from));
        } else if (this.mapillaryData.getSelectedImage().getTempLatLon() != this.mapillaryData.getSelectedImage().getLatLon()) {
            LatLon from = this.mapillaryData.getSelectedImage().getTempLatLon();
            LatLon to = this.mapillaryData.getSelectedImage().getLatLon();
            this.record.addCommand(new CommandMoveImage(this.mapillaryData.getMultiSelectedImages(), to.getX() - from.getX(), to.getY() - from.getY()));
        }
        for (MapillaryAbstractImage img : this.mapillaryData.getMultiSelectedImages()) {
            if (img == null) continue;
            img.stopMoving();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        MapillaryAbstractImage closestTemp = this.getClosest(e.getPoint());
        if (closestTemp != null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && Main.map.mapModeSelect.getValue("active") == Boolean.TRUE) {
            Main.map.mapModeSelect.exitMode();
        } else if (closestTemp == null && Main.map.mapView.getActiveLayer() instanceof OsmDataLayer && Main.map.mapModeSelect.getValue("active") == Boolean.FALSE) {
            Main.map.mapModeSelect.enterMode();
            this.nothingHighlighted = false;
        } else if (Main.map.mapModeSelect.getValue("active") == Boolean.FALSE && !this.nothingHighlighted) {
            for (OsmPrimitive primivitive : Main.map.mapView.getEditLayer().data.allPrimitives()) {
                primivitive.setHighlighted(false);
            }
            this.nothingHighlighted = true;
        }
        if (MapillaryData.getInstance().getHoveredImage() != closestTemp && closestTemp != null) {
            MapillaryData.getInstance().setHoveredImage(closestTemp);
            MapillaryToggleDialog.getInstance().setImage(closestTemp);
            MapillaryToggleDialog.getInstance().updateImage();
        } else if (MapillaryData.getInstance().getHoveredImage() != closestTemp && closestTemp == null) {
            MapillaryData.getInstance().setHoveredImage(null);
            MapillaryToggleDialog.getInstance().setImage(MapillaryData.getInstance().getSelectedImage());
            MapillaryToggleDialog.getInstance().updateImage();
        }
        MapillaryData.getInstance().dataUpdated();
    }
}

