/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryAbstractImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDataListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;

public class MapillaryData
implements ICachedLoaderListener {
    public static volatile MapillaryData INSTANCE;
    private final List<MapillaryAbstractImage> images;
    private MapillaryAbstractImage selectedImage = null;
    private MapillaryAbstractImage hoveredImage;
    private final List<MapillaryAbstractImage> multiSelectedImages;
    private List<MapillaryDataListener> listeners = new ArrayList<MapillaryDataListener>();

    public MapillaryData() {
        this.images = new CopyOnWriteArrayList<MapillaryAbstractImage>();
        this.multiSelectedImages = new ArrayList<MapillaryAbstractImage>();
    }

    public static MapillaryData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryData();
        }
        return INSTANCE;
    }

    public synchronized void add(List<MapillaryAbstractImage> images) {
        for (MapillaryAbstractImage image : images) {
            this.add(image);
        }
    }

    public synchronized void add(MapillaryAbstractImage image) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
        this.dataUpdated();
    }

    public void addListener(MapillaryDataListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(MapillaryDataListener lis) {
        this.listeners.remove(lis);
    }

    public synchronized void addWithoutUpdate(List<MapillaryAbstractImage> images) {
        for (MapillaryAbstractImage image : images) {
            this.addWithoutUpdate(image);
        }
    }

    public void setHoveredImage(MapillaryAbstractImage image) {
        this.hoveredImage = image;
    }

    public MapillaryAbstractImage getHoveredImage() {
        return this.hoveredImage;
    }

    public synchronized void addWithoutUpdate(MapillaryAbstractImage image) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
    }

    public synchronized void dataUpdated() {
        Main.map.mapView.repaint();
    }

    public List<MapillaryAbstractImage> getImages() {
        return this.images;
    }

    public MapillaryAbstractImage getSelectedImage() {
        return this.selectedImage;
    }

    public void selectNext() {
        if (this.getSelectedImage() instanceof MapillaryImage) {
            if (this.getSelectedImage() == null) {
                return;
            }
            if (((MapillaryImage)this.getSelectedImage()).getSequence() == null) {
                return;
            }
            this.setSelectedImage(((MapillaryImage)this.getSelectedImage()).next(), true);
        }
    }

    public void selectPrevious() {
        if (this.getSelectedImage() instanceof MapillaryImage) {
            if (this.getSelectedImage() == null) {
                return;
            }
            if (((MapillaryImage)this.getSelectedImage()).getSequence() == null) {
                throw new IllegalStateException();
            }
            this.setSelectedImage(((MapillaryImage)this.getSelectedImage()).previous(), true);
        }
    }

    public void setSelectedImage(MapillaryAbstractImage image) {
        this.setSelectedImage(image, false);
    }

    public void setSelectedImage(MapillaryAbstractImage image, boolean zoom) {
        MapillaryAbstractImage oldImage = this.selectedImage;
        this.selectedImage = image;
        this.multiSelectedImages.clear();
        this.multiSelectedImages.add(image);
        if (image != null && image instanceof MapillaryImage) {
            MapillaryImage mapillaryImage = (MapillaryImage)image;
            if (mapillaryImage.next() != null) {
                new MapillaryCache(mapillaryImage.next().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                if (mapillaryImage.next().next() != null) {
                    new MapillaryCache(mapillaryImage.next().next().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                }
            }
            if (mapillaryImage.previous() != null) {
                new MapillaryCache(mapillaryImage.previous().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                if (mapillaryImage.previous().previous() != null) {
                    new MapillaryCache(mapillaryImage.previous().previous().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                }
            }
        }
        if (zoom) {
            Main.map.mapView.zoomTo(MapillaryData.getInstance().getSelectedImage().getLatLon());
        }
        if (Main.map != null) {
            Main.map.mapView.repaint();
        }
        this.fireSelectedImageChanged(oldImage, this.selectedImage);
    }

    private void fireSelectedImageChanged(MapillaryAbstractImage oldImage, MapillaryAbstractImage newImage) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (MapillaryDataListener lis : this.listeners) {
            lis.selectedImageChanged(oldImage, newImage);
        }
    }

    public void addMultiSelectedImage(MapillaryAbstractImage image) {
        if (!this.multiSelectedImages.contains(image)) {
            if (this.getSelectedImage() != null) {
                this.multiSelectedImages.add(image);
            } else {
                this.setSelectedImage(image);
            }
        }
        Main.map.mapView.repaint();
    }

    public void addMultiSelectedImage(List<MapillaryAbstractImage> images) {
        for (MapillaryAbstractImage image : images) {
            if (this.multiSelectedImages.contains(image)) continue;
            if (this.getSelectedImage() != null) {
                this.multiSelectedImages.add(image);
                continue;
            }
            this.setSelectedImage(image);
        }
        Main.map.mapView.repaint();
    }

    public List<MapillaryAbstractImage> getMultiSelectedImages() {
        return this.multiSelectedImages;
    }

    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
    }
}

