/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import org.openstreetmap.josm.data.coor.LatLon;

public abstract class MapillaryAbstractImage {
    public final LatLon latLon;
    public final double ca;
    public boolean isModified = false;
    public LatLon tempLatLon;
    public LatLon movingLatLon;
    public double tempCa;
    protected double movingCa;

    public MapillaryAbstractImage(double lat, double lon, double ca) {
        this.tempLatLon = this.latLon = new LatLon(lat, lon);
        this.movingLatLon = this.latLon;
        this.ca = ca;
        this.tempCa = ca;
        this.movingCa = ca;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public LatLon getLatLon() {
        return this.movingLatLon;
    }

    public LatLon getTempLatLon() {
        return this.tempLatLon;
    }

    public void move(double x, double y) {
        this.movingLatLon = new LatLon(this.tempLatLon.getY() + y, this.tempLatLon.getX() + x);
        this.isModified = true;
    }

    public void turn(double ca) {
        this.movingCa = this.tempCa + ca;
        this.isModified = true;
    }

    public void stopMoving() {
        this.tempLatLon = this.movingLatLon;
        this.tempCa = this.movingCa;
    }

    public double getCa() {
        return this.movingCa;
    }

    public double getTempCa() {
        return this.tempCa;
    }
}

