/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.FontSets;
import com.jgoodies.looks.Fonts;
import com.jgoodies.looks.LookUtils;
import java.awt.Font;
import java.lang.reflect.Method;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;

public final class FontPolicies {
    private FontPolicies() {
    }

    public static FontPolicy createFixedPolicy(FontSet fontSet) {
        return new FixedPolicy(fontSet);
    }

    public static FontPolicy customSettingsPolicy(FontPolicy defaultPolicy) {
        return new CustomSettingsPolicy(defaultPolicy);
    }

    public static FontPolicy getDefaultPlasticOnWindowsPolicy() {
        return new DefaultPlasticOnWindowsPolicy();
    }

    public static FontPolicy getDefaultPlasticPolicy() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return FontPolicies.getDefaultPlasticOnWindowsPolicy();
        }
        return FontPolicies.getLogicalFontsPolicy();
    }

    public static FontPolicy getDefaultWindowsPolicy() {
        return new DefaultWindowsPolicy();
    }

    public static FontPolicy getLogicalFontsPolicy() {
        return FontPolicies.createFixedPolicy(FontSets.getLogicalFontSet());
    }

    private static FontSet getCustomFontSet(String lafName) {
        String controlFontKey = lafName + ".controlFont";
        String menuFontKey = lafName + ".menuFont";
        String decodedControlFont = LookUtils.getSystemProperty(controlFontKey);
        if (decodedControlFont == null) {
            return null;
        }
        Font controlFont = Font.decode(decodedControlFont);
        String decodedMenuFont = LookUtils.getSystemProperty(menuFontKey);
        Font menuFont = decodedMenuFont != null ? Font.decode(decodedMenuFont) : null;
        Font titleFont = "Plastic".equals(lafName) ? controlFont.deriveFont(1) : controlFont;
        return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont);
    }

    private static FontPolicy getCustomPolicy(String lafName) {
        return null;
    }

    private static final class FixedPolicy
    implements FontPolicy {
        private final FontSet fontSet;

        FixedPolicy(FontSet fontSet) {
            this.fontSet = fontSet;
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            return this.fontSet;
        }
    }

    private static class DefaultWindowsPolicy
    implements FontPolicy {
        private static final String FONT_UTILITIES_CLASS_NAME = "sun.font.FontUtilities";

        private DefaultWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            Font windowsControlFont = Fonts.getWindowsControlFont();
            Font controlFont = DefaultWindowsPolicy.lookUpControlFont(windowsControlFont, table);
            Font menuFont = table == null ? controlFont : table.getFont("Menu.font");
            Font titleFont = controlFont;
            Font messageFont = table == null ? controlFont : table.getFont("OptionPane.font");
            Font smallFont = table == null ? controlFont.deriveFont(controlFont.getSize2D() - 2.0f) : table.getFont("ToolTip.font");
            Font windowTitleFont = table == null ? controlFont : table.getFont("InternalFrame.titleFont");
            return FontSets.createDefaultFontSet(controlFont, menuFont, titleFont, messageFont, smallFont, windowTitleFont);
        }

        private static Font lookUpControlFont(Font windowsControlFont, UIDefaults table) {
            Preconditions.checkNotNull((Object)windowsControlFont, (String)"The %s must not be null.", (Object[])new Object[]{"Windows control font"});
            if (table == null) {
                return windowsControlFont;
            }
            Font buttonFont = table.getFont("Button.font");
            if (buttonFont != null && buttonFont.getName().equals(windowsControlFont.getName())) {
                if (buttonFont.getSize() == windowsControlFont.getSize() || buttonFont.getStyle() == windowsControlFont.getStyle()) {
                    return buttonFont;
                }
                return buttonFont.deriveFont(windowsControlFont.getStyle(), windowsControlFont.getSize2D());
            }
            if (DefaultWindowsPolicy.fontSupportsDefaultEncoding(windowsControlFont)) {
                return windowsControlFont;
            }
            FontUIResource fuir = DefaultWindowsPolicy.getCompositeFontUIResource(windowsControlFont);
            return fuir != null ? fuir : windowsControlFont;
        }

        private static boolean fontSupportsDefaultEncoding(Font font) {
            try {
                Method m = Class.forName(FONT_UTILITIES_CLASS_NAME).getMethod("fontSupportsDefaultEncoding", Font.class);
                if (m != null) {
                    return (Boolean)m.invoke(null, font);
                }
                return true;
            }
            catch (Exception exception) {
                return true;
            }
        }

        private static FontUIResource getCompositeFontUIResource(Font font) {
            try {
                Method m = Class.forName(FONT_UTILITIES_CLASS_NAME).getMethod("getCompositeFontUIResource", Font.class);
                if (m != null) {
                    return (FontUIResource)m.invoke(null, font);
                }
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static final class DefaultPlasticOnWindowsPolicy
    extends DefaultWindowsPolicy {
        private DefaultPlasticOnWindowsPolicy() {
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            FontSet fontSet = super.getFontSet(lafName, table);
            Font titleFont = fontSet.getTitleFont().deriveFont(1);
            return new FontSets.DefaultFontSet(fontSet.getControlFont(), fontSet.getMenuFont(), titleFont, fontSet.getMessageFont(), fontSet.getSmallFont(), fontSet.getWindowTitleFont());
        }
    }

    private static final class CustomSettingsPolicy
    implements FontPolicy {
        private final FontPolicy wrappedPolicy;

        CustomSettingsPolicy(FontPolicy wrappedPolicy) {
            this.wrappedPolicy = wrappedPolicy;
        }

        @Override
        public FontSet getFontSet(String lafName, UIDefaults table) {
            FontPolicy customPolicy = FontPolicies.getCustomPolicy(lafName);
            if (customPolicy != null) {
                return customPolicy.getFontSet(null, table);
            }
            FontSet customFontSet = FontPolicies.getCustomFontSet(lafName);
            if (customFontSet != null) {
                return customFontSet;
            }
            return this.wrappedPolicy.getFontSet(lafName, table);
        }
    }
}

