/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;

public class MapillarySquareDownloadThread
implements Runnable {
    private final String url;
    private final ExecutorService ex;

    public MapillarySquareDownloadThread(ExecutorService ex, MapillaryData data, String url) {
        this.ex = ex;
        this.url = url;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(this.url).openStream()));
            JsonObject jsonobj = Json.createReader((Reader)br).readObject();
            if (!jsonobj.getBoolean("more")) {
                this.ex.shutdownNow();
            }
            JsonArray jsonarr = jsonobj.getJsonArray("ims");
            ArrayList<MapillaryImage> images = new ArrayList<MapillaryImage>();
            for (int i = 0; i < jsonarr.size(); ++i) {
                try {
                    JsonObject image = jsonarr.getJsonObject(i);
                    images.add(new MapillaryImage(image.getString("key"), image.getJsonNumber("lat").doubleValue(), image.getJsonNumber("lon").doubleValue(), image.getJsonNumber("ca").doubleValue()));
                    continue;
                }
                catch (Exception e) {
                    Main.error((Throwable)e);
                }
            }
            MapillaryData.getInstance().add(images);
        }
        catch (Exception e) {
            Main.error((Throwable)e);
        }
    }
}

