/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.MapillaryToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;
import org.openstreetmap.josm.plugins.mapillary.commands.CommandMoveImage;
import org.openstreetmap.josm.plugins.mapillary.commands.CommandTurnImage;
import org.openstreetmap.josm.plugins.mapillary.commands.MapillaryRecord;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryDownloader;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryLayer
extends AbstractModifiableLayer
implements DataSetListener,
MapView.EditLayerChangeListener {
    public static final int SEQUENCE_MAX_JUMP_DISTANCE = 100;
    public static Boolean INSTANCED = false;
    public static MapillaryLayer INSTANCE;
    public static CacheAccess<String, BufferedImageCacheEntry> CACHE;
    public static MapillaryImage BLUE;
    public static MapillaryImage RED;
    private final MapillaryData mapillaryData = MapillaryData.getInstance();
    private final MapillaryRecord record = MapillaryRecord.getInstance();
    private List<Bounds> bounds = new ArrayList<Bounds>();
    private MapillaryToggleDialog tgd;
    private MouseAdapter mouseAdapter;

    public MapillaryLayer() {
        super(I18n.tr((String)"Mapillary Images", (Object[])new Object[0]));
        this.init();
    }

    private void init() {
        INSTANCED = true;
        INSTANCE = this;
        this.startMouseAdapter();
        try {
            CACHE = JCSCacheManager.getCache((String)"Mapillary");
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
        if (Main.map != null && Main.map.mapView != null) {
            Main.map.mapView.addMouseListener((MouseListener)this.mouseAdapter);
            Main.map.mapView.addMouseMotionListener((MouseMotionListener)this.mouseAdapter);
            Main.map.mapView.addLayer((Layer)this);
            MapView.addEditLayerChangeListener((MapView.EditLayerChangeListener)this, (boolean)false);
            Main.map.mapView.getEditLayer().data.addDataSetListener((DataSetListener)this);
            if (this.tgd == null) {
                if (MapillaryToggleDialog.INSTANCE == null) {
                    this.tgd = MapillaryToggleDialog.getInstance();
                    Main.map.addToggleDialog((ToggleDialog)this.tgd, false);
                } else {
                    this.tgd = MapillaryToggleDialog.getInstance();
                }
            }
        }
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.EXPORT_MENU, true);
        this.download();
        Main.map.mapView.setActiveLayer((Layer)this);
    }

    public void startMouseAdapter() {
        this.mouseAdapter = new MouseAdapter(){
            private Point start;
            private int lastButton;
            private MapillaryImage closest;

            @Override
            public void mousePressed(MouseEvent e) {
                this.lastButton = e.getButton();
                if (e.getButton() != 1) {
                    return;
                }
                if (Main.map.mapView.getActiveLayer() != MapillaryLayer.getInstance()) {
                    return;
                }
                MapillaryImage closest = this.getClosest(e.getPoint());
                if (e.getClickCount() == 2 && MapillaryLayer.this.mapillaryData.getSelectedImage() != null && closest != null) {
                    for (MapillaryImage img : closest.getSequence().getImages()) {
                        MapillaryLayer.this.mapillaryData.addMultiSelectedImage(img);
                    }
                }
                this.start = e.getPoint();
                this.closest = closest;
                if (MapillaryLayer.this.mapillaryData.getMultiSelectedImages().contains(closest)) {
                    return;
                }
                if (e.getModifiers() == 18 && closest != null) {
                    MapillaryLayer.this.mapillaryData.addMultiSelectedImage(closest);
                } else {
                    MapillaryLayer.this.mapillaryData.setSelectedImage(closest);
                }
            }

            private MapillaryImage getClosest(Point clickPoint) {
                double snapDistance = 10.0;
                double minDistance = Double.MAX_VALUE;
                MapillaryImage closest = null;
                for (MapillaryImage image : MapillaryLayer.this.mapillaryData.getImages()) {
                    Point imagePoint = Main.map.mapView.getPoint(image.getLatLon());
                    imagePoint.setLocation(imagePoint.getX(), imagePoint.getY());
                    double dist = clickPoint.distanceSq(imagePoint);
                    if (!(minDistance > dist) || !(clickPoint.distance(imagePoint) < snapDistance)) continue;
                    minDistance = dist;
                    closest = image;
                }
                return closest;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Main.map.mapView.getActiveLayer() != MapillaryLayer.getInstance()) {
                    return;
                }
                if (MapillaryData.getInstance().getSelectedImage() != null) {
                    if (this.lastButton == 1 && !e.isShiftDown()) {
                        LatLon to = Main.map.mapView.getLatLon(e.getX(), e.getY());
                        LatLon from = Main.map.mapView.getLatLon(this.start.getX(), this.start.getY());
                        for (MapillaryImage img : MapillaryData.getInstance().getMultiSelectedImages()) {
                            img.move(to.getX() - from.getX(), to.getY() - from.getY());
                        }
                        Main.map.repaint();
                    } else if (this.lastButton == 1 && e.isShiftDown()) {
                        this.closest.turn(Math.toDegrees(Math.atan2(e.getX() - this.start.x, -(e.getY() - this.start.y))) - this.closest.getTempCa());
                        for (MapillaryImage img : MapillaryData.getInstance().getMultiSelectedImages()) {
                            img.turn(Math.toDegrees(Math.atan2(e.getX() - this.start.x, -(e.getY() - this.start.y))) - this.closest.getTempCa());
                        }
                        Main.map.repaint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MapillaryLayer.this.mapillaryData.getSelectedImage() == null) {
                    return;
                }
                if (MapillaryLayer.this.mapillaryData.getSelectedImage().getTempCa() != MapillaryLayer.this.mapillaryData.getSelectedImage().getCa()) {
                    double from = MapillaryLayer.this.mapillaryData.getSelectedImage().getTempCa();
                    double to = MapillaryLayer.this.mapillaryData.getSelectedImage().getCa();
                    MapillaryLayer.this.record.addCommand(new CommandTurnImage(MapillaryLayer.this.mapillaryData.getMultiSelectedImages(), to - from));
                } else if (MapillaryLayer.this.mapillaryData.getSelectedImage().getTempLatLon() != MapillaryLayer.this.mapillaryData.getSelectedImage().getLatLon()) {
                    LatLon from = MapillaryLayer.this.mapillaryData.getSelectedImage().getTempLatLon();
                    LatLon to = MapillaryLayer.this.mapillaryData.getSelectedImage().getLatLon();
                    MapillaryLayer.this.record.addCommand(new CommandMoveImage(MapillaryLayer.this.mapillaryData.getMultiSelectedImages(), to.getX() - from.getX(), to.getY() - from.getY()));
                }
                for (MapillaryImage img : MapillaryLayer.this.mapillaryData.getMultiSelectedImages()) {
                    if (img == null) continue;
                    img.stopMoving();
                }
            }
        };
    }

    public static synchronized MapillaryLayer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryLayer();
        }
        return INSTANCE;
    }

    protected void download() {
        for (Bounds bounds : Main.map.mapView.getEditLayer().data.getDataSourceBounds()) {
            if (this.bounds.contains(bounds)) continue;
            this.bounds.add(bounds);
            new MapillaryDownloader().getImages(bounds.getMin(), bounds.getMax());
        }
    }

    public MapillaryData getMapillaryData() {
        return this.mapillaryData;
    }

    public void destroy() {
        MapillaryToggleDialog.getInstance().mapillaryImageDisplay.setImage(null);
        INSTANCED = false;
        INSTANCE = null;
        MapillaryPlugin.setMenuEnabled(MapillaryPlugin.EXPORT_MENU, false);
        MapillaryData.INSTANCE = null;
        Main.map.mapView.removeMouseListener((MouseListener)this.mouseAdapter);
        MapView.removeEditLayerChangeListener((MapView.EditLayerChangeListener)this);
        if (Main.map.mapView.getEditLayer() != null) {
            Main.map.mapView.getEditLayer().data.removeDataSetListener((DataSetListener)this);
        }
        super.destroy();
    }

    public boolean isModified() {
        for (MapillaryImage image : this.mapillaryData.getImages()) {
            if (!image.isModified()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics2D g, MapView mv, Bounds box) {
        MapillaryLayer mapillaryLayer = this;
        synchronized (mapillaryLayer) {
            BLUE = null;
            RED = null;
            MapillaryToggleDialog.getInstance().blueButton.setEnabled(false);
            MapillaryToggleDialog.getInstance().redButton.setEnabled(false);
            if (this.mapillaryData.getSelectedImage() != null) {
                MapillaryImage[] closestImages = this.getClosestImagesFromDifferentSequences();
                Point selected = mv.getPoint(this.mapillaryData.getSelectedImage().getLatLon());
                if (closestImages[0] != null) {
                    BLUE = closestImages[0];
                    g.setColor(Color.BLUE);
                    g.drawLine(mv.getPoint((LatLon)closestImages[0].getLatLon()).x, mv.getPoint((LatLon)closestImages[0].getLatLon()).y, selected.x, selected.y);
                    MapillaryToggleDialog.getInstance().blueButton.setEnabled(true);
                }
                if (closestImages[1] != null) {
                    RED = closestImages[1];
                    g.setColor(Color.RED);
                    g.drawLine(mv.getPoint((LatLon)closestImages[1].getLatLon()).x, mv.getPoint((LatLon)closestImages[1].getLatLon()).y, selected.x, selected.y);
                    MapillaryToggleDialog.getInstance().redButton.setEnabled(true);
                }
            }
            g.setColor(Color.WHITE);
            for (MapillaryImage image : this.mapillaryData.getImages()) {
                Point p = mv.getPoint(image.getLatLon());
                if (image.getSequence() != null && image.getSequence().next(image) != null) {
                    Point nextp = mv.getPoint(image.getSequence().next(image).getLatLon());
                    g.drawLine(p.x, p.y, nextp.x, nextp.y);
                }
                ImageIcon icon = !this.mapillaryData.getMultiSelectedImages().contains(image) ? MapillaryPlugin.MAP_ICON : MapillaryPlugin.MAP_ICON_SELECTED;
                Image imagetemp = icon.getImage();
                BufferedImage bi = (BufferedImage)imagetemp;
                int width = icon.getIconWidth();
                int height = icon.getIconHeight();
                double rotationRequired = Math.toRadians(image.getCa());
                double locationX = width / 2;
                double locationY = height / 2;
                AffineTransform tx = AffineTransform.getRotateInstance(rotationRequired, locationX, locationY);
                AffineTransformOp op = new AffineTransformOp(tx, 2);
                g.drawImage((Image)op.filter(bi, null), p.x - width / 2, p.y - height / 2, (ImageObserver)Main.map.mapView);
            }
        }
    }

    public Icon getIcon() {
        return MapillaryPlugin.ICON16;
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void mergeFrom(Layer from) {
        throw new UnsupportedOperationException("Notes layer does not support merging yet");
    }

    public Action[] getMenuEntries() {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(LayerListDialog.getInstance().createShowHideLayerAction());
        actions.add(LayerListDialog.getInstance().createDeleteLayerAction());
        actions.add(new LayerListPopup.InfoAction((Layer)this));
        return actions.toArray(new Action[actions.size()]);
    }

    private MapillaryImage[] getClosestImagesFromDifferentSequences() {
        MapillaryImage[] ret = new MapillaryImage[2];
        double[] distances = new double[]{100.0, 100.0};
        LatLon selectedCoords = this.mapillaryData.getSelectedImage().getLatLon();
        for (MapillaryImage image : this.mapillaryData.getImages()) {
            if (!(image.getLatLon().greatCircleDistance(selectedCoords) < 100.0) || this.mapillaryData.getSelectedImage().getSequence() == image.getSequence()) continue;
            if (ret[0] == null && ret[1] == null || image.getLatLon().greatCircleDistance(selectedCoords) < distances[0] && (ret[1] == null || image.getSequence() != ret[1].getSequence())) {
                ret[0] = image;
                distances[0] = image.getLatLon().greatCircleDistance(selectedCoords);
                continue;
            }
            if (ret[1] != null && !(image.getLatLon().greatCircleDistance(selectedCoords) < distances[1]) || image.getSequence() == ret[0].getSequence()) continue;
            ret[1] = image;
            distances[1] = image.getLatLon().greatCircleDistance(selectedCoords);
        }
        if (ret[0] != null) {
            new MapillaryCache(ret[0].getKey(), MapillaryCache.Type.THUMBNAIL).submit(MapillaryData.getInstance(), false);
        }
        if (ret[1] != null) {
            new MapillaryCache(ret[1].getKey(), MapillaryCache.Type.THUMBNAIL).submit(MapillaryData.getInstance(), false);
        }
        return ret;
    }

    public Object getInfoComponent() {
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.tr((String)"Mapillary layer", (Object[])new Object[0]));
        sb.append("\n");
        sb.append(I18n.tr((String)"Total images:", (Object[])new Object[0]));
        sb.append(" ");
        sb.append(this.size());
        sb.append("\n");
        return sb.toString();
    }

    public String getToolTipText() {
        return this.size() + " " + I18n.tr((String)"images", (Object[])new Object[0]);
    }

    private int size() {
        return this.mapillaryData.getImages().size();
    }

    public void editLayerChanged(OsmDataLayer oldLayer, OsmDataLayer newLayer) {
    }

    public void dataChanged(DataChangedEvent event) {
        Main.worker.submit(new delayedDownload());
    }

    public void primitivesAdded(PrimitivesAddedEvent event) {
    }

    public void primitivesRemoved(PrimitivesRemovedEvent event) {
    }

    public void tagsChanged(TagsChangedEvent event) {
    }

    public void nodeMoved(NodeMovedEvent event) {
    }

    public void wayNodesChanged(WayNodesChangedEvent event) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent event) {
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent event) {
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    private class delayedDownload
    extends Thread {
        private delayedDownload() {
        }

        @Override
        public void run() {
            try {
                delayedDownload.sleep(1000L);
            }
            catch (InterruptedException e) {
                Main.error((Throwable)e);
            }
            MapillaryLayer.getInstance().download();
        }
    }
}

