/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public class MapillaryImage {
    private final String key;
    public final LatLon latLon;
    private final double ca;
    private MapillarySequence sequence;
    private boolean isModified = false;
    public LatLon tempLatLon;
    public LatLon movingLatLon;
    private double tempCa;
    private double movingCa;

    public MapillaryImage(String key, double lat, double lon, double ca) {
        this.key = key;
        this.tempLatLon = this.latLon = new LatLon(lat, lon);
        this.movingLatLon = this.latLon;
        this.ca = ca;
        this.tempCa = ca;
        this.movingCa = ca;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public LatLon getLatLon() {
        return this.movingLatLon;
    }

    public LatLon getTempLatLon() {
        return this.tempLatLon;
    }

    public void move(double x, double y) {
        this.movingLatLon = new LatLon(this.tempLatLon.getY() + y, this.tempLatLon.getX() + x);
        this.isModified = true;
    }

    public void turn(double ca) {
        this.movingCa = this.tempCa + ca;
        this.isModified = true;
    }

    public void stopMoving() {
        this.tempLatLon = this.movingLatLon;
        this.tempCa = this.movingCa;
    }

    public double getCa() {
        return this.movingCa;
    }

    public double getTempCa() {
        return this.tempCa;
    }

    public String getKey() {
        return this.key;
    }

    public void setSequence(MapillarySequence sequence) {
        this.sequence = sequence;
    }

    public MapillarySequence getSequence() {
        return this.sequence;
    }

    public String toString() {
        return "Image[key=" + this.key + ";lat=" + this.latLon.lat() + ";lon=" + this.latLon.lon() + ";ca=" + this.ca + "]";
    }

    public boolean equals(Object image) {
        if (image instanceof MapillaryImage) {
            return this.key.equals(((MapillaryImage)image).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public MapillaryImage next() {
        if (this.getSequence() == null) {
            return null;
        }
        return this.getSequence().next(this);
    }

    public MapillaryImage previous() {
        if (this.getSequence() == null) {
            return null;
        }
        return this.getSequence().previous(this);
    }
}

