/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fastdraw;

import java.awt.Color;
import java.awt.Stroke;
import java.io.IOException;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;

public class FDSettings {
    public Color COLOR_FIXED;
    public Color COLOR_NORMAL;
    public Color COLOR_DELETE;
    public Color COLOR_SELECTEDFRAGMENT;
    public Color COLOR_EDITEDFRAGMENT;
    public Color COLOR_SIMPLIFIED;
    public double maxDist;
    public double epsilonMult;
    public double minPixelsBetweenPoints;
    public double startingEps;
    public double maxPointsPerKm;
    public int pkmBlockSize;
    public boolean drawLastSegment;
    public boolean snapNodes;
    public boolean fixedClick;
    public boolean fixedSpacebar;
    public boolean allowEditExistingWays;
    public boolean drawClosed;
    public int simplifyMode;
    public String autoTags;
    public Stroke normalStroke;
    public Stroke simplifiedStroke;
    public Stroke deleteStroke;
    public int dotSize;
    public int bigDotSize;

    public void loadPrefs() {
        this.COLOR_DELETE = Main.pref.getColor("fastdraw.color.delete", Color.red);
        this.COLOR_EDITEDFRAGMENT = Main.pref.getColor("fastdraw.color.edit", Color.orange);
        this.COLOR_FIXED = Main.pref.getColor("fastdraw.color.fixed", Color.green);
        this.COLOR_NORMAL = Main.pref.getColor("fastdraw.color.normal", Color.red);
        this.COLOR_SELECTEDFRAGMENT = Main.pref.getColor("fastdraw.color.select", Color.blue);
        this.COLOR_SIMPLIFIED = Main.pref.getColor("fastdraw.color.simplified", Color.orange);
        this.normalStroke = GuiHelper.getCustomizedStroke((String)Main.pref.get("fastdraw.stroke.normal", "2"));
        this.deleteStroke = GuiHelper.getCustomizedStroke((String)Main.pref.get("fastdraw.stroke.delete", "3"));
        this.simplifiedStroke = GuiHelper.getCustomizedStroke((String)Main.pref.get("fastdraw.stroke.simplified", "2"));
        this.bigDotSize = Main.pref.getInteger("fastdraw.point.bigsize", 7);
        this.dotSize = Main.pref.getInteger("fastdraw.point.normalsize", 5);
        this.maxDist = Main.pref.getDouble("fastdraw.maxdist", 5.0);
        this.epsilonMult = Main.pref.getDouble("fastdraw.epsilonmult", 1.1);
        this.minPixelsBetweenPoints = Main.pref.getDouble("fastdraw.mindelta", 20.0);
        this.startingEps = Main.pref.getDouble("fastdraw.startingEps", 5.0);
        this.maxPointsPerKm = Main.pref.getDouble("fastdraw.maxpkm", 150.0);
        this.pkmBlockSize = Main.pref.getInteger("fastdraw.pkmblocksize", 10);
        this.drawLastSegment = Main.pref.getBoolean("fastdraw.drawlastsegment", true);
        this.snapNodes = Main.pref.getBoolean("fastdraw.snapnodes", true);
        this.fixedClick = Main.pref.getBoolean("fastdraw.fixedclick", false);
        this.fixedSpacebar = Main.pref.getBoolean("fastdraw.fixedspacebar", false);
        this.drawClosed = Main.pref.getBoolean("fastdraw.drawclosed", false);
        this.simplifyMode = Main.pref.getInteger("fastdraw.simplifymode", 0) % 2;
        this.allowEditExistingWays = Main.pref.getBoolean("fastdraw.alloweditexisting", false);
        this.autoTags = Main.pref.get("fastdraw.autotags");
    }

    public void savePrefs() {
        Main.pref.putDouble("fastdraw.maxdist", Double.valueOf(this.maxDist));
        Main.pref.putDouble("fastdraw.epsilonmult", Double.valueOf(this.epsilonMult));
        Main.pref.putDouble("fastdraw.mindelta", Double.valueOf(this.minPixelsBetweenPoints));
        Main.pref.putDouble("fastdraw.startingEps", Double.valueOf(this.startingEps));
        Main.pref.putDouble("fastdraw.maxpkm", Double.valueOf(this.maxPointsPerKm));
        Main.pref.putInteger("fastdraw.pkmblocksize", Integer.valueOf(this.pkmBlockSize));
        Main.pref.put("fastdraw.drawlastsegment", this.drawLastSegment);
        Main.pref.put("fastdraw.snapnodes", this.snapNodes);
        Main.pref.put("fastdraw.fixedclick", this.fixedClick);
        Main.pref.put("fastdraw.fixedspacebar", this.fixedSpacebar);
        Main.pref.put("fastdraw.drawclosed", this.drawClosed);
        Main.pref.putInteger("fastdraw.simplifymode", Integer.valueOf(this.simplifyMode));
        Main.pref.put("fastdraw.autotags", this.autoTags);
        Main.pref.put("fastdraw.alloweditexisting", this.allowEditExistingWays);
        try {
            Main.pref.save();
        }
        catch (IOException e) {
            System.err.println(I18n.tr((String)"Can not save preferences", (Object[])new Object[0]));
        }
    }
}

