/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.PackageUtil;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Color;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.ColorCube;
import javax.media.jai.IHSColorSpace;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import javax.media.jai.WarpGrid;
import javax.media.jai.operator.AddConstDescriptor;
import javax.media.jai.operator.AddDescriptor;
import javax.media.jai.operator.AffineDescriptor;
import javax.media.jai.operator.AndDescriptor;
import javax.media.jai.operator.BandCombineDescriptor;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.BinarizeDescriptor;
import javax.media.jai.operator.ColorConvertDescriptor;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.ErrorDiffusionDescriptor;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.NotDescriptor;
import javax.media.jai.operator.NullDescriptor;
import javax.media.jai.operator.OrderedDitherDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import javax.media.jai.operator.ScaleDescriptor;
import javax.media.jai.operator.XorConstDescriptor;
import org.geotools.factory.Hints;
import org.geotools.image.GTWarpPropertyGenerator;
import org.geotools.image.crop.GTCropDescriptor;
import org.geotools.image.io.ImageIOExt;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.operation.matrix.AffineTransform2D;
import org.geotools.referencing.operation.transform.WarpBuilder;
import org.geotools.resources.Arguments;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.image.ColorUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.logging.Logging;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;

public class ImageWorker {
    private static final Logger LOGGER;
    private static final boolean CODEC_LIB_AVAILABLE;
    private static final ImageWriterSpi JDK_JPEG_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi IMAGEIO_GIF_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi IMAGEIO_JPEG_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI;
    private static final ImageWriterSpi CLIB_PNG_IMAGE_WRITER_SPI;
    static final float RS_EPS = 0.01f;
    public static final String WARP_REDUCTION_ENABLED_KEY = "org.geotools.image.reduceWarpAffine";
    static boolean WARP_REDUCTION_ENABLED;
    static final ColorSpace CS_PYCC;
    public static final Hints.Key TILING_ALLOWED;
    private static final String EXTREMA = "extrema";
    private RenderedImage inheritanceStopPoint;
    protected RenderedImage image;
    private ROI roi;
    private RenderingHints commonHints;
    private int tileCacheDisabled = 0;

    public ImageWorker() {
        this.image = null;
        this.inheritanceStopPoint = null;
    }

    public ImageWorker(File input) throws IOException {
        this(ImageIO.read(input));
    }

    public ImageWorker(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
    }

    public final ImageWorker setImage(RenderedImage image) {
        this.inheritanceStopPoint = this.image = image;
        return this;
    }

    private ImageWorker fork(RenderedImage image) {
        ImageWorker worker = new ImageWorker(image);
        if (this.commonHints != null && !this.commonHints.isEmpty()) {
            RenderingHints hints = new RenderingHints(null);
            hints.add(worker.commonHints);
            worker.commonHints = hints;
        }
        return worker;
    }

    public final void load(String source, int imageChoice, boolean readMetadata) {
        ParameterBlockJAI pbj = new ParameterBlockJAI("ImageRead");
        pbj.setParameter("Input", source).setParameter("ImageChoice", (Object)imageChoice).setParameter("ReadMetadata", (Object)readMetadata).setParameter("VerifyInput", Boolean.TRUE);
        this.image = JAI.create("ImageRead", pbj, this.getRenderingHints());
    }

    public final RenderedImage getRenderedImage() {
        return this.image;
    }

    public final BufferedImage getBufferedImage() {
        if (this.image instanceof BufferedImage) {
            return (BufferedImage)this.image;
        }
        return this.getPlanarImage().getAsBufferedImage();
    }

    public final PlanarImage getPlanarImage() {
        return PlanarImage.wrapRenderedImage(this.getRenderedImage());
    }

    public final RenderedOp getRenderedOperation() {
        RenderedImage image = this.getRenderedImage();
        if (image instanceof RenderedOp) {
            return (RenderedOp)image;
        }
        return NullDescriptor.create(image, this.getRenderingHints());
    }

    public final ROI getImageAsROI() {
        this.binarize();
        return new ROI(this.getRenderedImage());
    }

    public final ROI getROI() {
        return this.roi;
    }

    public final ImageWorker setROI(ROI roi) {
        this.roi = roi;
        this.invalidateStatistics();
        return this;
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.commonHints != null ? this.commonHints.get(key) : null;
    }

    public final ImageWorker setRenderingHint(RenderingHints.Key key, Object value) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        this.commonHints.add(new RenderingHints(key, value));
        return this;
    }

    public final ImageWorker setRenderingHints(RenderingHints hints) {
        if (this.commonHints == null) {
            this.commonHints = new RenderingHints(null);
        }
        if (hints != null) {
            this.commonHints.add(hints);
        }
        return this;
    }

    public final ImageWorker removeRenderingHint(RenderingHints.Key key) {
        if (this.commonHints != null) {
            this.commonHints.remove(key);
        }
        return this;
    }

    public final RenderingHints getRenderingHints() {
        RenderingHints hints = ImageUtilities.getRenderingHints(this.image);
        if (hints == null) {
            hints = new RenderingHints(null);
            if (this.commonHints != null) {
                hints.add(this.commonHints);
            }
        } else if (this.commonHints != null) {
            hints.putAll((Map<?, ?>)this.commonHints);
        }
        if (Boolean.FALSE.equals(hints.get(TILING_ALLOWED))) {
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            if (this.commonHints == null || layout != this.commonHints.get(JAI.KEY_IMAGE_LAYOUT)) {
                layout.setTileWidth(this.image.getWidth());
                layout.setTileHeight(this.image.getHeight());
                layout.setTileGridXOffset(this.image.getMinX());
                layout.setTileGridYOffset(this.image.getMinY());
                hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            }
        }
        if (this.tileCacheDisabled != 0 && this.commonHints != null && !this.commonHints.containsKey(JAI.KEY_TILE_CACHE)) {
            hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, null));
        }
        return hints;
    }

    private final RenderingHints getRenderingHints(int type) {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(512)) {
            return hints;
        }
        ColorModel oldCm = this.image.getColorModel();
        if (oldCm != null) {
            ComponentColorModel newCm = new ComponentColorModel(oldCm.getColorSpace(), oldCm.hasAlpha(), oldCm.isAlphaPremultiplied(), oldCm.getTransparency(), type);
            layout.setColorModel(newCm);
            layout.setSampleModel(((ColorModel)newCm).createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        } else {
            int numBands = this.image.getSampleModel().getNumBands();
            ComponentColorModel newCm = new ComponentColorModel(new BogusColorSpace(numBands), false, false, 1, type);
            layout.setColorModel(newCm);
            layout.setSampleModel(((ColorModel)newCm).createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        }
        hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        return hints;
    }

    private static ImageLayout getImageLayout(RenderingHints hints) {
        Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (candidate instanceof ImageLayout) {
            return (ImageLayout)candidate;
        }
        return new ImageLayout();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ImageWorker tileCacheEnabled(boolean status) {
        if (status) {
            if (this.tileCacheDisabled == 0) throw new IllegalStateException();
            --this.tileCacheDisabled;
            return this;
        } else {
            ++this.tileCacheDisabled;
        }
        return this;
    }

    public final int getNumBands() {
        return this.image.getSampleModel().getNumBands();
    }

    public final int getTransparentPixel() {
        ColorModel cm = this.image.getColorModel();
        return cm instanceof IndexColorModel ? ((IndexColorModel)cm).getTransparentPixel() : -1;
    }

    private Object getComputedProperty(String name) {
        Object value = this.image.getProperty(name);
        return value == this.inheritanceStopPoint.getProperty(name) ? Image.UndefinedProperty : value;
    }

    private double[][] getExtremas() {
        Object extrema = this.getComputedProperty(EXTREMA);
        if (!(extrema instanceof double[][])) {
            Integer ONE = 1;
            this.image = ExtremaDescriptor.create(this.image, this.roi, ONE, ONE, null, ONE, this.getRenderingHints());
            extrema = this.getComputedProperty(EXTREMA);
        }
        return (double[][])extrema;
    }

    private ImageWorker invalidateStatistics() {
        this.inheritanceStopPoint = this.image;
        return this;
    }

    public final double[] getMinimums() {
        return this.getExtremas()[0];
    }

    public final double[] getMaximums() {
        return this.getExtremas()[1];
    }

    public final boolean isBytes() {
        SampleModel sm = this.image.getSampleModel();
        int[] sampleSize = sm.getSampleSize();
        for (int i = 0; i < sampleSize.length; ++i) {
            if (sampleSize[i] == 8) continue;
            return false;
        }
        return true;
    }

    public final boolean isBinary() {
        return ImageUtil.isBinary(this.image.getSampleModel());
    }

    public final boolean isIndexed() {
        return this.image.getColorModel() instanceof IndexColorModel;
    }

    public final boolean isColorSpaceRGB() {
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace().getType() == 5;
    }

    public final boolean isColorSpaceYCbCr() {
        if (CS_PYCC == null) {
            throw new IllegalStateException("Unable to create an YCbCr profile most like since we are unable to locate the YCbCr color profile. Check the Java installation.");
        }
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace().getType() == 3 || cm.getColorSpace().equals(CS_PYCC);
    }

    public final boolean isColorSpaceIHS() {
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace() instanceof IHSColorSpace;
    }

    public final boolean isColorSpaceGRAYScale() {
        ColorModel cm = this.image.getColorModel();
        if (cm == null) {
            return false;
        }
        return cm.getColorSpace().getType() == 6;
    }

    public final boolean isTranslucent() {
        return this.image.getColorModel().getTransparency() == 3;
    }

    public final ImageWorker rescaleToBytes() {
        if (this.isBytes()) {
            return this;
        }
        this.forceComponentColorModel(true, true);
        double[][] extrema = this.getExtremas();
        int length = extrema[0].length;
        double[] scale = new double[length];
        double[] offset = new double[length];
        boolean computeRescale = false;
        for (int i = 0; i < length; ++i) {
            double delta = extrema[1][i] - extrema[0][i];
            if (Math.abs(delta) > 1.0E-6 && (extrema[1][i] - 255.0 > 1.0E-6 || extrema[0][i] < -1.0E-6)) {
                computeRescale = true;
                scale[i] = 255.0 / delta;
                offset[i] = -scale[i] * extrema[0][i];
                continue;
            }
            scale[i] = 1.0;
            offset[i] = 0.0;
        }
        RenderingHints hints = this.getRenderingHints(0);
        this.image = computeRescale ? RescaleDescriptor.create(this.image, scale, offset, hints) : FormatDescriptor.create(this.image, 0, hints);
        this.invalidateStatistics();
        assert (this.isBytes());
        return this;
    }

    public final ImageWorker forceIndexColorModel(boolean error) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this;
        }
        this.tileCacheEnabled(false);
        if (this.getNumBands() % 2 == 0) {
            this.retainBands(this.getNumBands() - 1);
        }
        this.forceColorSpaceRGB();
        RenderingHints hints = this.getRenderingHints();
        if (error) {
            KernelJAI ditherMask = KernelJAI.ERROR_FILTER_FLOYD_STEINBERG;
            ColorCube colorMap = ColorCube.BYTE_496;
            this.image = ErrorDiffusionDescriptor.create(this.image, colorMap, ditherMask, hints);
        } else {
            KernelJAI[] ditherMask = KernelJAI.DITHER_MASK_443;
            ColorCube colorMap = ColorCube.BYTE_496;
            this.image = OrderedDitherDescriptor.create(this.image, colorMap, ditherMask, hints);
        }
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        assert (this.isIndexed());
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel() {
        this.forceBitmaskIndexColorModel(this.getTransparentPixel(), true);
        return this;
    }

    public final ImageWorker forceBitmaskIndexColorModel(int suggestedTransparent, boolean errorDiffusion) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            LookupTableJAI lookupTable;
            int i;
            Object[] table;
            IndexColorModel oldCM = (IndexColorModel)cm;
            switch (oldCM.getTransparency()) {
                case 1: {
                    return this;
                }
                case 2: {
                    if (oldCM.getTransparentPixel() != suggestedTransparent) break;
                    return this;
                }
            }
            int transparentPixel = ColorUtilities.getTransparentPixel(oldCM);
            int mapSize = oldCM.getMapSize();
            suggestedTransparent = transparentPixel < 0 ? (suggestedTransparent <= mapSize ? mapSize + 1 : suggestedTransparent) : transparentPixel;
            int newSize = Math.max(mapSize, suggestedTransparent);
            int newPixelSize = ColorUtilities.getBitCount(newSize);
            if (newPixelSize > 16) {
                throw new IllegalArgumentException("Unable to create index color model with more than 65536 elements");
            }
            if (newPixelSize <= 8) {
                table = new byte[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (byte)(oldCM.getAlpha(i) == 0 ? suggestedTransparent : i);
                }
                lookupTable = new LookupTableJAI((byte[])table);
            } else {
                table = new short[mapSize];
                for (i = 0; i < mapSize; ++i) {
                    table[i] = (short)(oldCM.getAlpha(i) == 0 ? suggestedTransparent : i);
                }
                lookupTable = new LookupTableJAI((short[])table, true);
            }
            byte[][] rgb = new byte[3][newSize];
            oldCM.getReds(rgb[0]);
            oldCM.getGreens(rgb[1]);
            oldCM.getBlues(rgb[2]);
            IndexColorModel newCM = new IndexColorModel(newPixelSize, newSize, rgb[0], rgb[1], rgb[2], suggestedTransparent);
            RenderingHints hints = this.getRenderingHints();
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel(newCM);
            hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
            this.image = LookupDescriptor.create(this.image, lookupTable, hints);
            this.image = FormatDescriptor.create(this.image, this.image.getSampleModel().getDataType(), hints);
        } else {
            this.forceComponentColorModel(true);
            if (cm.hasAlpha()) {
                this.tileCacheEnabled(false);
                int numBands = this.getNumBands();
                RenderingHints hints = this.getRenderingHints();
                RenderedOp alphaChannel = BandSelectDescriptor.create(this.image, new int[]{--numBands}, hints);
                this.retainBands(numBands);
                this.forceIndexColorModel(errorDiffusion);
                this.tileCacheEnabled(true);
                this.addTransparencyToIndexColorModel(alphaChannel, false, suggestedTransparent, errorDiffusion);
            } else {
                this.forceIndexColorModel(errorDiffusion);
            }
        }
        assert (this.isIndexed());
        assert (!this.isTranslucent());
        return this;
    }

    public final ImageWorker forceIndexColorModelForGIF(boolean errorDiffusion) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof PackedColorModel) {
            this.forceComponentColorModel();
            cm = this.image.getColorModel();
        }
        if (!(cm instanceof IndexColorModel) || cm.getPixelSize() > 8) {
            this.rescaleToBytes();
        }
        if (this.isTranslucent()) {
            this.forceBitmaskIndexColorModel(255, errorDiffusion);
        } else {
            this.forceIndexColorModel(errorDiffusion);
        }
        assert (this.isIndexed());
        assert (!this.isTranslucent());
        return this;
    }

    public final ImageWorker forceComponentColorModel() {
        return this.forceComponentColorModel(false);
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent, boolean optimizeGray) {
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof ComponentColorModel) {
            return this;
        }
        if (cm instanceof IndexColorModel) {
            ImageLayout layout;
            IndexColorModel icm = (IndexColorModel)cm;
            SampleModel sm = this.image.getSampleModel();
            int datatype = sm.getDataType();
            boolean gray = ColorUtilities.isGrayPalette(icm, checkTransparent) & optimizeGray;
            boolean alpha = icm.hasAlpha();
            int numDestinationBands = gray ? (alpha ? 2 : 1) : (alpha ? 4 : 3);
            LookupTableJAI lut = null;
            switch (datatype) {
                case 0: {
                    byte[][] data = new byte[numDestinationBands][icm.getMapSize()];
                    icm.getReds(data[0]);
                    if (numDestinationBands >= 2) {
                        if (!gray) {
                            icm.getGreens(data[1]);
                        } else {
                            icm.getAlphas(data[1]);
                        }
                    }
                    if (numDestinationBands >= 3) {
                        icm.getBlues(data[2]);
                    }
                    if (numDestinationBands == 4) {
                        icm.getAlphas(data[3]);
                    }
                    lut = new LookupTableJAI(data);
                    break;
                }
                case 1: {
                    int mapSize = icm.getMapSize();
                    short[][] data = new short[numDestinationBands][mapSize];
                    for (int i = 0; i < mapSize; ++i) {
                        data[0][i] = (short)icm.getRed(i);
                        if (numDestinationBands >= 2) {
                            data[1][i] = !gray ? (short)icm.getGreen(i) : (short)icm.getAlpha(i);
                        }
                        if (numDestinationBands >= 3) {
                            data[2][i] = (short)icm.getBlue(i);
                        }
                        if (numDestinationBands != 4) continue;
                        data[3][i] = (short)icm.getAlpha(i);
                    }
                    lut = new LookupTableJAI(data, datatype == 1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format(58, "datatype", datatype));
                }
            }
            if (lut == null) {
                throw new IllegalStateException(Errors.format(143, "lut"));
            }
            RenderingHints hints = this.getRenderingHints();
            Object candidate = hints.get(JAI.KEY_IMAGE_LAYOUT);
            if (candidate instanceof ImageLayout) {
                layout = (ImageLayout)candidate;
            } else {
                layout = new ImageLayout(this.image);
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            }
            int[] bits = new int[numDestinationBands];
            for (int i = 0; i < numDestinationBands; ++i) {
                bits[i] = sm.getSampleSize(i);
            }
            ComponentColorModel destinationColorModel = new ComponentColorModel(numDestinationBands >= 3 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003), bits, alpha, cm.isAlphaPremultiplied(), alpha ? 3 : 1, datatype);
            SampleModel destinationSampleModel = destinationColorModel.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight());
            layout.setColorModel(destinationColorModel);
            layout.setSampleModel(destinationSampleModel);
            this.image = LookupDescriptor.create(this.image, lut, hints);
        } else {
            int type = cm instanceof DirectColorModel ? 0 : this.image.getSampleModel().getTransferType();
            RenderingHints hints = this.getRenderingHints(type);
            this.image = FormatDescriptor.create(this.image, type, hints);
        }
        this.invalidateStatistics();
        assert (this.image.getColorModel() instanceof ComponentColorModel);
        return this;
    }

    public final ImageWorker forceComponentColorModel(boolean checkTransparent) {
        return this.forceComponentColorModel(checkTransparent, true);
    }

    public final ImageWorker forceColorSpaceRGB() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, this.image.getSampleModel().getDataType());
            this.forceColorModel(cm);
        }
        assert (this.isColorSpaceRGB());
        return this;
    }

    public final ImageWorker forceColorSpaceYCbCr() {
        if (!this.isColorSpaceYCbCr()) {
            this.forceComponentColorModel();
            ComponentColorModel cm = new ComponentColorModel(CS_PYCC, false, false, 1, this.image.getSampleModel().getDataType());
            this.forceColorModel(cm);
        }
        assert (this.isColorSpaceYCbCr());
        return this;
    }

    public final ImageWorker forceColorSpaceIHS() {
        if (!this.isColorSpaceIHS()) {
            this.forceComponentColorModel();
            IHSColorSpace ihs = IHSColorSpace.getInstance();
            int numBits = this.image.getColorModel().getComponentSize(0);
            ComponentColorModel ihsColorModel = new ComponentColorModel(ihs, new int[]{numBits, numBits, numBits}, false, false, 1, this.image.getSampleModel().getDataType());
            this.forceColorModel(ihsColorModel);
        }
        assert (this.isColorSpaceIHS());
        return this;
    }

    private void forceColorModel(ColorModel cm) {
        ImageLayout2 il = new ImageLayout2(this.image);
        il.setColorModel(cm);
        il.setSampleModel(cm.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight()));
        RenderingHints oldRi = this.getRenderingHints();
        RenderingHints newRi = (RenderingHints)oldRi.clone();
        newRi.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il));
        this.setRenderingHints(newRi);
        this.image = ColorConvertDescriptor.create(this.image, cm, this.getRenderingHints());
        this.setRenderingHints(oldRi);
        this.invalidateStatistics();
    }

    public final ImageWorker bandMerge(int writeband) {
        ParameterBlock pb = new ParameterBlock();
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage(this.getRenderedImage());
        int numBands = sourceImage.getSampleModel().getNumBands();
        RenderedOp firstBand = JAI.create("bandSelect", (RenderedImage)sourceImage, (Object)new int[]{0});
        int length = writeband - numBands;
        for (int i = 0; i < length; ++i) {
            pb.removeParameters();
            pb.removeSources();
            pb.addSource(sourceImage);
            pb.addSource(firstBand);
            sourceImage = JAI.create("bandmerge", pb);
            pb.removeParameters();
            pb.removeSources();
        }
        this.image = sourceImage;
        this.invalidateStatistics();
        assert (this.image.getSampleModel().getNumBands() == writeband);
        return this;
    }

    public final ImageWorker addBand(RenderedImage image, boolean before) {
        this.image = before ? BandMergeDescriptor.create(image, this.image, this.getRenderingHints()) : BandMergeDescriptor.create(this.image, image, this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker forceColorSpaceGRAYScale() {
        if (!this.isColorSpaceRGB()) {
            ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
            this.image = ColorConvertDescriptor.create(this.image, cm, this.getRenderingHints());
            this.invalidateStatistics();
        }
        assert (this.isColorSpaceGRAYScale());
        return this;
    }

    public final ImageWorker intensity() {
        ColorModel cm = this.image.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        if (cs.getType() == 6 || cs instanceof IHSColorSpace) {
            this.retainFirstBand();
            return this;
        }
        if (cm instanceof IndexColorModel) {
            this.forceComponentColorModel();
            cm = this.image.getColorModel();
        }
        int numBands = cm.getNumComponents();
        int numColorBands = cm.getNumColorComponents();
        boolean hasAlpha = cm.hasAlpha();
        if (numBands == 1) {
            return this;
        }
        if (numColorBands == 1 && hasAlpha) {
            this.retainFirstBand();
            return this;
        }
        if (numColorBands != numBands) {
            this.retainBands(numBands);
        }
        double[][] coeff = new double[1][numBands + 1];
        Arrays.fill(coeff[0], 0, numColorBands, 1.0 / (double)numColorBands);
        this.image = BandCombineDescriptor.create(this.image, coeff, this.getRenderingHints());
        this.invalidateStatistics();
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainFirstBand() {
        this.retainBands(1);
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainLastBand() {
        int band = this.getNumBands() - 1;
        if (band != 0) {
            this.retainBands(new int[]{band});
        }
        assert (this.getNumBands() == 1);
        return this;
    }

    public final ImageWorker retainBands(int numBands) {
        if (numBands <= 0) {
            throw new IndexOutOfBoundsException(Errors.format(58, "numBands", numBands));
        }
        if (this.getNumBands() > numBands) {
            int[] bands = new int[numBands];
            for (int i = 0; i < bands.length; ++i) {
                bands[i] = i;
            }
            this.image = BandSelectDescriptor.create(this.image, bands, this.getRenderingHints());
        }
        assert (this.getNumBands() <= numBands);
        return this;
    }

    public final ImageWorker retainBands(int[] bands) {
        this.image = BandSelectDescriptor.create(this.image, bands, this.getRenderingHints());
        return this;
    }

    public final ImageWorker format(int dataType) {
        this.image = FormatDescriptor.create(this.image, dataType, this.getRenderingHints());
        assert (this.image.getSampleModel().getDataType() == dataType);
        return this;
    }

    public final ImageWorker binarize() {
        this.binarize(Double.NaN);
        assert (this.isBinary());
        return this;
    }

    public final ImageWorker binarize(double threshold) {
        if (!this.isBinary()) {
            if (Double.isNaN(threshold)) {
                if (this.getNumBands() != 1) {
                    this.tileCacheEnabled(false);
                    this.intensity();
                    this.tileCacheEnabled(true);
                }
                double[][] extremas = this.getExtremas();
                threshold = 0.5 * (extremas[0][0] + extremas[1][0]);
            }
            RenderingHints hints = this.getRenderingHints();
            this.image = BinarizeDescriptor.create(this.image, threshold, hints);
            this.invalidateStatistics();
        }
        assert (this.isBinary());
        return this;
    }

    public final ImageWorker binarize(int value0, int value1) {
        int max;
        this.tileCacheEnabled(false);
        this.binarize();
        this.tileCacheEnabled(true);
        int min = Math.min(value0, value1);
        LookupTableJAI table = min >= 0 ? ((max = Math.max(value0, value1)) < 256 ? new LookupTableJAI(new byte[]{(byte)value0, (byte)value1}) : (max < 65536 ? new LookupTableJAI(new short[]{(short)value0, (short)value1}, true) : new LookupTableJAI(new int[]{value0, value1}))) : new LookupTableJAI(new int[]{value0, value1});
        this.image = LookupDescriptor.create(this.image, table, this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker makeColorTransparent(Color transparentColor) throws IllegalStateException {
        if (transparentColor == null) {
            throw new IllegalArgumentException(Errors.format(143, "transparentColor"));
        }
        ColorModel cm = this.image.getColorModel();
        if (cm instanceof IndexColorModel) {
            return this.maskIndexColorModel(transparentColor);
        }
        if (cm instanceof ComponentColorModel) {
            switch (this.image.getSampleModel().getDataType()) {
                case 0: {
                    return this.maskComponentColorModelByte(transparentColor);
                }
            }
        }
        throw new IllegalStateException(Errors.format(198));
    }

    private final ImageWorker maskIndexColorModel(Color transparentColor) {
        int found;
        int transpColor;
        assert (this.image.getColorModel() instanceof IndexColorModel);
        IndexColorModel cm = (IndexColorModel)this.image.getColorModel();
        int numComponents = cm.getNumComponents();
        int transparency = cm.getTransparency();
        int transparencyIndex = cm.getTransparentPixel();
        int mapSize = cm.getMapSize();
        int transparentRGB = transparentColor.getRGB() & 0xFFFFFF;
        if (transparency == 2 && transparencyIndex != -1 && (transpColor = cm.getRGB(transparencyIndex) & 0xFFFFFF) == transparentRGB) {
            return this;
        }
        ArrayList<Integer> transparentPixelsIndexes = new ArrayList<Integer>();
        for (int i = 0; i < mapSize; ++i) {
            int color = cm.getRGB(i) & 0xFFFFFF;
            if (transparentRGB != color) continue;
            transparentPixelsIndexes.add(i);
            if (2 == transparency) break;
        }
        if ((found = transparentPixelsIndexes.size()) == 1) {
            transparencyIndex = (Integer)transparentPixelsIndexes.get(0);
            transparency = 2;
        } else {
            if (found == 0) {
                return this;
            }
            transparencyIndex = -1;
            transparency = 3;
        }
        byte[][] rgb = new byte[4][mapSize];
        cm.getReds(rgb[0]);
        cm.getGreens(rgb[1]);
        cm.getBlues(rgb[2]);
        if (numComponents == 4) {
            cm.getAlphas(rgb[3]);
        } else {
            Arrays.fill(rgb[3], (byte)-1);
        }
        if (transparency != 3) {
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], transparencyIndex);
        } else {
            for (int k = 0; k < found; ++k) {
                rgb[3][((Integer)transparentPixelsIndexes.get((int)k)).intValue()] = 0;
            }
            cm = new IndexColorModel(cm.getPixelSize(), mapSize, rgb[0], rgb[1], rgb[2], rgb[3]);
        }
        ImageLayout layout = new ImageLayout(this.image);
        layout.setColorModel(cm);
        RenderingHints hints = this.getRenderingHints();
        hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        this.image = FormatDescriptor.create(this.image, this.image.getSampleModel().getDataType(), hints);
        this.invalidateStatistics();
        return this;
    }

    private final ImageWorker maskComponentColorModelByte(Color transparentColor) {
        boolean singleStep;
        assert (this.image.getColorModel() instanceof ComponentColorModel);
        assert (this.image.getSampleModel().getDataType() == 0);
        int numBands = this.image.getSampleModel().getNumBands();
        int numColorBands = this.image.getColorModel().getNumColorComponents();
        RenderingHints hints = this.getRenderingHints();
        if (numColorBands != numBands) {
            int[] opaqueBands = new int[numColorBands];
            for (int i = 0; i < opaqueBands.length; ++i) {
                opaqueBands[i] = i;
            }
            this.image = BandSelectDescriptor.create(this.image, opaqueBands, hints);
            numBands = numColorBands;
        }
        byte[][] tableData = new byte[numColorBands][256];
        boolean bl = singleStep = numColorBands == 1;
        if (singleStep) {
            byte[] data = tableData[0];
            Arrays.fill(data, (byte)-1);
            data[transparentColor.getRed()] = 0;
        } else {
            switch (numColorBands) {
                case 3: {
                    Arrays.fill(tableData[2], (byte)-1);
                    tableData[2][transparentColor.getBlue()] = 0;
                }
                case 2: {
                    Arrays.fill(tableData[1], (byte)-1);
                    tableData[1][transparentColor.getGreen()] = 0;
                }
                case 1: {
                    Arrays.fill(tableData[0], (byte)-1);
                    tableData[0][transparentColor.getRed()] = 0;
                }
            }
        }
        LookupTableJAI table = new LookupTableJAI(tableData);
        hints.put(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.FALSE);
        RenderedOp luImage = LookupDescriptor.create(this.image, table, hints);
        if (!singleStep) {
            double[][] matrix = new double[1][4];
            Arrays.fill(matrix[0], 0, 3, 1.0);
            luImage = BandCombineDescriptor.create(luImage, matrix, hints);
        }
        this.image = BandMergeDescriptor.create(this.image, luImage, hints);
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker invert() {
        this.image = InvertDescriptor.create(this.image, this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker mask(RenderedImage mask, boolean maskValue, int newValue) {
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(true);
        RenderingHints hints = new RenderingHints(JAI.KEY_TILE_CACHE, null);
        if (newValue == 255 && !maskValue) {
            byte[] lutData = new byte[256];
            Arrays.fill(lutData, (byte)0);
            lutData[0] = -1;
            LookupTableJAI lut = new LookupTableJAI(lutData);
            mask = LookupDescriptor.create(mask, lut, hints);
            this.image = AddDescriptor.create(this.image, mask, this.getRenderingHints());
            this.tileCacheEnabled(true);
            this.invalidateStatistics();
            return this;
        }
        if (!this.isBinary()) {
            this.binarize();
        }
        if (maskValue) {
            mask = NotDescriptor.create(mask, new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        }
        this.tileCacheEnabled(false);
        this.image = AndDescriptor.create(mask, this.image, this.getRenderingHints());
        mask = AddConstDescriptor.create(mask, new double[]{newValue}, new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
        this.image = AddDescriptor.create(mask, this.image, this.getRenderingHints());
        this.tileCacheEnabled(true);
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker addImage(RenderedImage renderedImage) {
        this.image = AddDescriptor.create(this.image, renderedImage, this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker multiplyConst(double[] inValues) {
        this.image = MultiplyConstDescriptor.create(this.image, inValues, this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public final ImageWorker xorConst(int[] values) {
        this.image = XorConstDescriptor.create(this.image, values, this.getRenderingHints());
        this.invalidateStatistics();
        return this;
    }

    public ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean errorDiffusion) {
        this.addTransparencyToIndexColorModel(alphaChannel, true, this.getTransparentPixel(), errorDiffusion);
        return this;
    }

    public final ImageWorker addTransparencyToIndexColorModel(RenderedImage alphaChannel, boolean translucent, int transparent, boolean errorDiffusion) {
        boolean forceBitmask;
        this.tileCacheEnabled(false);
        this.forceIndexColorModel(errorDiffusion);
        this.tileCacheEnabled(true);
        ImageWorker worker = this.fork(this.image);
        RenderingHints hints = worker.getRenderingHints();
        IndexColorModel oldCM = (IndexColorModel)this.image.getColorModel();
        int pixelSize = oldCM.getPixelSize();
        boolean bl = forceBitmask = !translucent && oldCM.getTransparency() == 3;
        if (forceBitmask || oldCM.getTransparentPixel() != (transparent &= (1 << pixelSize) - 1)) {
            IndexColorModel newCM;
            int mapSize = Math.max(oldCM.getMapSize(), transparent + 1);
            byte[][] RGBA = new byte[translucent ? 4 : 3][mapSize];
            oldCM.getReds(RGBA[0]);
            oldCM.getGreens(RGBA[1]);
            oldCM.getBlues(RGBA[2]);
            if (translucent) {
                oldCM.getAlphas(RGBA[3]);
                RGBA[3][transparent] = 0;
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], RGBA[3]);
            } else {
                newCM = new IndexColorModel(pixelSize, mapSize, RGBA[0], RGBA[1], RGBA[2], transparent);
            }
            ImageLayout layout = ImageWorker.getImageLayout(hints);
            layout.setColorModel(newCM);
            worker.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        worker.setRenderingHint(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        worker.mask(alphaChannel, false, transparent);
        this.image = worker.image;
        this.invalidateStatistics();
        assert (this.isIndexed());
        assert (translucent || !this.isTranslucent()) : translucent;
        assert (((IndexColorModel)this.image.getColorModel()).getAlpha(transparent) == 0);
        return this;
    }

    public final ImageWorker tile() {
        RenderingHints hints = this.getRenderingHints();
        ImageLayout layout = ImageWorker.getImageLayout(hints);
        if (layout.isValid(64) || layout.isValid(128)) {
            int type = this.image.getSampleModel().getDataType();
            this.image = FormatDescriptor.create(this.image, type, hints);
        }
        return this;
    }

    public ImageWorker applyOpacity(float opacity) {
        RenderedOp result;
        ColorModel colorModel = this.image.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel index = (IndexColorModel)colorModel;
            byte[] reds = new byte[index.getMapSize()];
            byte[] greens = new byte[index.getMapSize()];
            byte[] blues = new byte[index.getMapSize()];
            byte[] alphas = new byte[index.getMapSize()];
            index.getReds(reds);
            index.getGreens(greens);
            index.getBlues(blues);
            index.getAlphas(alphas);
            int transparentPixel = index.getTransparentPixel();
            for (int i = 0; i < alphas.length; ++i) {
                alphas[i] = (byte)Math.round((float)(0xFF & alphas[i]) * opacity);
                if (i != transparentPixel) continue;
                alphas[i] = 0;
            }
            IndexColorModel newColorModel = new IndexColorModel(index.getPixelSize(), index.getMapSize(), reds, greens, blues, alphas);
            LookupTableJAI table = this.buildOpacityLookupTable(0.0f, 1, -1);
            ImageLayout layout = new ImageLayout(this.image);
            layout.setColorModel(newColorModel);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            result = LookupDescriptor.create(this.image, table, hints);
        } else {
            RenderedImage expanded = !(colorModel instanceof ComponentColorModel) ? new ImageWorker(this.image).forceComponentColorModel().getRenderedImage() : this.image;
            if (!expanded.getColorModel().hasAlpha()) {
                byte alpha = (byte)Math.round(255.0f * opacity);
                ImageLayout layout = new ImageLayout(this.image.getMinX(), this.image.getMinY(), this.image.getWidth(), this.image.getHeight());
                RenderedOp alphaBand = ConstantDescriptor.create(Float.valueOf(this.image.getWidth()), Float.valueOf(this.image.getHeight()), new Byte[]{new Byte(alpha)}, new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                result = BandMergeDescriptor.create(expanded, alphaBand, null);
            } else {
                int bands = expanded.getSampleModel().getNumBands();
                int alphaBand = bands - 1;
                LookupTableJAI table = this.buildOpacityLookupTable(opacity, bands, alphaBand);
                result = LookupDescriptor.create(expanded, table, null);
            }
        }
        this.image = result;
        return this;
    }

    LookupTableJAI buildOpacityLookupTable(float opacity, int bands, int alphaBand) {
        byte[][] matrix = new byte[bands][256];
        for (int band = 0; band < matrix.length; ++band) {
            int i;
            if (band == alphaBand) {
                for (i = 0; i < 256; ++i) {
                    matrix[band][i] = (byte)Math.round((float)i * opacity);
                }
                continue;
            }
            for (i = 0; i < 256; ++i) {
                matrix[band][i] = (byte)i;
            }
        }
        LookupTableJAI table = new LookupTableJAI(matrix);
        return table;
    }

    public final ImageWorker write(File output) throws IOException {
        String filename = output.getName();
        int dot = filename.lastIndexOf(46);
        if (dot < 0) {
            throw new IIOException(Errors.format(135));
        }
        String extension = filename.substring(dot + 1).trim();
        this.write(output, ImageIO.getImageWritersBySuffix(extension));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writePNG(Object destination, String compression, float compressionRate, boolean nativeAcc, boolean paletted) throws IOException {
        IndexColorModel icm;
        boolean hasColorModel;
        boolean hasPalette = this.image.getColorModel() instanceof IndexColorModel;
        boolean bl = hasColorModel = hasPalette ? false : this.image.getColorModel() instanceof ComponentColorModel;
        if (paletted && !hasPalette) {
            this.forceIndexColorModelForGIF(true);
        } else if (!hasColorModel && !hasPalette) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("Forcing input image to be compatible with PNG: No palette, no component color model");
            }
            this.forceComponentColorModel();
        }
        if (hasPalette && (icm = (IndexColorModel)this.image.getColorModel()).getMapSize() > 256) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.fine("Forcing input image to be compatible with PNG: Palette with > 256 color is not supported.");
            }
            this.rescaleToBytes();
            if (paletted) {
                this.forceIndexColorModelForGIF(true);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Encoded input image for png writer");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a writer");
        }
        ImageWriter writer = null;
        Object originatingProvider = null;
        if (nativeAcc) {
            if (CLIB_PNG_IMAGE_WRITER_SPI != null) {
                if (CLIB_PNG_IMAGE_WRITER_SPI.canEncodeImage(new ImageTypeSpecifier(this.image))) {
                    writer = CLIB_PNG_IMAGE_WRITER_SPI.createWriterInstance();
                    originatingProvider = CLIB_PNG_IMAGE_WRITER_SPI;
                } else {
                    LOGGER.fine("The ImageIO PNG native encode cannot encode this image!");
                    writer = null;
                    originatingProvider = null;
                }
            } else {
                LOGGER.fine("Unable to use Native ImageIO PNG writer.");
            }
        }
        if (!nativeAcc || writer == null) {
            Iterator<ImageWriter> it = ImageIO.getImageWriters(new ImageTypeSpecifier(this.image), "PNG");
            if (!it.hasNext()) {
                throw new IllegalStateException(Errors.format(135));
            }
            while (it.hasNext()) {
                writer = it.next();
                originatingProvider = writer.getOriginatingProvider();
                if (CLIB_PNG_IMAGE_WRITER_SPI != null && originatingProvider.getClass().equals(CLIB_PNG_IMAGE_WRITER_SPI.getClass())) {
                    if (it.hasNext()) {
                        writer = it.next();
                        originatingProvider = writer.getOriginatingProvider();
                    } else {
                        LOGGER.fine("Unable to use PNG writer different than ImageIO CLib one");
                    }
                }
                if (((ImageWriterSpi)originatingProvider).canEncodeImage(new ImageTypeSpecifier(this.image))) break;
                writer = null;
                originatingProvider = null;
            }
        }
        if (writer == null) {
            List providers = com.sun.media.imageioimpl.common.ImageUtil.getJDKImageReaderWriterSPI(IIORegistry.getDefaultInstance(), "PNG", false);
            if (providers == null || providers.isEmpty()) {
                throw new IllegalStateException("Unable to find JDK Png encoder!");
            }
            originatingProvider = (ImageWriterSpi)providers.get(0);
            writer = ((ImageWriterSpi)originatingProvider).createWriterInstance();
            this.forceComponentColorModel(true, true);
            this.rescaleToBytes();
            if (!((ImageWriterSpi)originatingProvider).canEncodeImage(this.image)) {
                throw new IllegalArgumentException("Unable to find a valid PNG Encoder! And believe me, we tried hard!");
            }
        }
        LOGGER.fine("Using ImageIO Writer with SPI: " + originatingProvider.getClass().getCanonicalName());
        LOGGER.fine("Setting write parameters for this writer");
        ImageWriteParam iwp = null;
        ImageOutputStream memOutStream = ImageIOExt.createImageOutputStream(this.image, destination);
        if (memOutStream == null) {
            throw new IIOException(Errors.format(143, "stream"));
        }
        if (CLIB_PNG_IMAGE_WRITER_SPI != null && originatingProvider.getClass().equals(CLIB_PNG_IMAGE_WRITER_SPI.getClass())) {
            LOGGER.fine("Writer is native");
            iwp = writer.getDefaultWriteParam();
            iwp.setCompressionMode(2);
            iwp.setCompressionType(compression);
            iwp.setCompressionQuality(compressionRate);
            iwp.setDestinationType(new ImageTypeSpecifier(this.image.getColorModel(), this.image.getSampleModel()));
        } else {
            LOGGER.fine("Writer is NOT native");
            iwp = new PNGImageWriteParam();
            iwp.setCompressionMode(1);
        }
        LOGGER.fine("About to write png image");
        try {
            writer.setOutput(memOutStream);
            writer.write(null, new IIOImage(this.image, null, null), iwp);
        }
        finally {
            block39: {
                block38: {
                    try {
                        writer.dispose();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block38;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    memOutStream.close();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block39;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ImageWorker writeGIF(Object destination, String compression, float compressionRate) throws IOException {
        this.forceIndexColorModelForGIF(true);
        if (IMAGEIO_GIF_IMAGE_WRITER_SPI == null) {
            throw new IIOException(Errors.format(135));
        }
        ImageOutputStream stream = ImageIOExt.createImageOutputStream(this.image, destination);
        if (stream == null) {
            throw new IIOException(Errors.format(143, "stream"));
        }
        ImageWriter writer = IMAGEIO_GIF_IMAGE_WRITER_SPI.createWriterInstance();
        ImageWriteParam param = writer.getDefaultWriteParam();
        param.setCompressionMode(2);
        param.setCompressionType(compression);
        param.setCompressionQuality(compressionRate);
        try {
            writer.setOutput(stream);
            writer.write(null, new IIOImage(this.image, null, null), param);
        }
        finally {
            block15: {
                block14: {
                    try {
                        stream.close();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block14;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    writer.dispose();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block15;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeJPEG(Object destination, String compression, float compressionRate, boolean nativeAcc) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Encoding input image to write out as JPEG.");
        }
        ColorModel cm = this.image.getColorModel();
        boolean hasAlpha = cm.hasAlpha();
        this.forceComponentColorModel();
        cm = this.image.getColorModel();
        this.rescaleToBytes();
        cm = this.image.getColorModel();
        int numBands = this.image.getSampleModel().getNumBands();
        if (hasAlpha) {
            this.retainBands(numBands - 1);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting a JPEG writer and configuring it.");
        }
        ImageWriter writer = null;
        if (nativeAcc && CODEC_LIB_AVAILABLE && IMAGEIO_JPEG_IMAGE_WRITER_SPI != null) {
            try {
                writer = IMAGEIO_JPEG_IMAGE_WRITER_SPI.createWriterInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Unable to instantiate CLIB JPEG ImageWriter", e);
                }
                writer = null;
            }
        }
        if (writer == null) {
            if (JDK_JPEG_IMAGE_WRITER_SPI == null) {
                throw new IllegalStateException(Errors.format(61, "Unable to find JDK JPEG Writer"));
            }
            writer = JDK_JPEG_IMAGE_WRITER_SPI.createWriterInstance();
        }
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        ImageOutputStream outStream = ImageIOExt.createImageOutputStream(this.image, destination);
        if (outStream == null) {
            throw new IIOException(Errors.format(143, "stream"));
        }
        iwp.setCompressionMode(2);
        iwp.setCompressionType(compression);
        iwp.setCompressionQuality(compressionRate);
        if (iwp instanceof JPEGImageWriteParam) {
            JPEGImageWriteParam param = (JPEGImageWriteParam)iwp;
            param.setOptimizeHuffmanTables(true);
            try {
                param.setProgressiveMode(1);
            }
            catch (UnsupportedOperationException e) {
                throw new IOException(e);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Writing out...");
        }
        try {
            writer.setOutput(outStream);
            if (!nativeAcc && (this.image.getMinX() != 0 || this.image.getMinY() != 0) || nativeAcc && (this.image.getNumXTiles() > 1 || this.image.getNumYTiles() > 1)) {
                BufferedImage finalImage = new BufferedImage(this.image.getColorModel(), ((WritableRaster)this.image.getData()).createWritableTranslatedChild(0, 0), this.image.getColorModel().isAlphaPremultiplied(), null);
                writer.write(null, new IIOImage(finalImage, null, null), iwp);
            } else {
                writer.write(null, new IIOImage(this.image, null, null), iwp);
            }
        }
        finally {
            block30: {
                block29: {
                    try {
                        writer.dispose();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block29;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    outStream.close();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block30;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Writing out... Done!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeTIFF(Object destination, String compression, float compressionRate, int tileSizeX, int tileSizeY) throws IOException {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Encoding input image to write out as TIFF.");
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Getting a TIFF writer and configuring it.");
        }
        ImageWriter writer = null;
        if (IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI == null) {
            LOGGER.finer("Unable to find ImageIO-Ext Tiff Writer, looking for another one");
            Iterator<ImageWriter> it = ImageIO.getImageWritersByFormatName("TIFF");
            if (!it.hasNext()) {
                throw new IllegalStateException(Errors.format(135));
            }
            writer = it.next();
        } else {
            writer = IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI.createWriterInstance();
        }
        if (writer == null) {
            throw new IllegalStateException("Unable to find Tiff ImageWriter!");
        }
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        ImageOutputStream outStream = ImageIOExt.createImageOutputStream(this.image, destination);
        if (outStream == null) {
            throw new IIOException(Errors.format(143, "stream"));
        }
        if (compression != null) {
            iwp.setCompressionMode(2);
            iwp.setCompressionType(compression);
            iwp.setCompressionQuality(compressionRate);
        } else {
            iwp.setCompressionMode(1);
        }
        if (tileSizeX > 0 && tileSizeY > 0) {
            iwp.setTilingMode(2);
            iwp.setTiling(tileSizeX, tileSizeY, 0, 0);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("Writing out...");
        }
        try {
            writer.setOutput(outStream);
            writer.write(null, new IIOImage(this.image, null, null), iwp);
        }
        finally {
            block24: {
                block23: {
                    try {
                        writer.dispose();
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block23;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    outStream.close();
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block24;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public ImageWorker affine(AffineTransform tx, Interpolation interpolation, double[] bgValues) {
        boolean intTranslateY;
        boolean hasTranslateY;
        int size = Math.max(this.image.getWidth(), this.image.getHeight());
        boolean hasScaleX = Math.abs(tx.getScaleX() - 1.0) * (double)size > (double)0.01f;
        boolean hasScaleY = Math.abs(tx.getScaleY() - 1.0) * (double)size > (double)0.01f;
        boolean hasShearX = Math.abs(tx.getShearX()) * (double)size > (double)0.01f;
        boolean hasShearY = Math.abs(tx.getShearY()) * (double)size > (double)0.01f;
        boolean hasTranslateX = Math.abs(tx.getTranslateX()) > (double)0.01f;
        boolean bl = hasTranslateY = Math.abs(tx.getTranslateY()) > (double)0.01f;
        if (!(hasScaleX || hasScaleY || hasShearX || hasShearY || hasTranslateX || hasTranslateY)) {
            return this;
        }
        ParameterListDescriptor pld = new AffineDescriptor().getParameterListDescriptor("rendered");
        if (interpolation == null) {
            interpolation = (Interpolation)pld.getParamDefaultValue("interpolation");
        }
        if (bgValues == null) {
            bgValues = (double[])pld.getParamDefaultValue("backgroundValues");
        }
        RenderedImage source = this.image;
        if (this.image instanceof RenderedOp) {
            RenderedImage sSource;
            ParameterBlock paramBlock;
            RenderedOp op = (RenderedOp)this.image;
            Object mtProperty = op.getProperty("MathTransform");
            Object sourceBoundsProperty = op.getProperty("SourceBoundingBox");
            String opName = op.getOperationName();
            if (WARP_REDUCTION_ENABLED && "Warp".equals(opName) && mtProperty instanceof MathTransform2D && sourceBoundsProperty instanceof Rectangle) {
                try {
                    MathTransform2D originalTransform = (MathTransform2D)mtProperty;
                    MathTransformFactory factory = ReferencingFactoryFinder.getMathTransformFactory(null);
                    MathTransform affineMT = factory.createAffineTransform(new AffineTransform2D(tx));
                    MathTransform2D chained = (MathTransform2D)factory.createConcatenatedTransform(affineMT.inverse(), originalTransform);
                    Double tolerance = (Double)this.getRenderingHint(Hints.RESAMPLE_TOLERANCE);
                    if (tolerance == null) {
                        tolerance = (Double)Hints.getSystemDefault(Hints.RESAMPLE_TOLERANCE);
                    }
                    if (tolerance == null) {
                        tolerance = 0.333;
                    }
                    WarpBuilder wb = new WarpBuilder(tolerance);
                    wb.setMaxPositions(0x400000);
                    RenderedOp at = AffineDescriptor.create(source, tx, interpolation, bgValues, this.commonHints);
                    Rectangle targetBB = at.getBounds();
                    at.dispose();
                    Rectangle sourceBB = (Rectangle)sourceBoundsProperty;
                    Rectangle mappingBB = source.getProperty("ROI") instanceof ROI ? sourceBB.union(targetBB) : targetBB;
                    Warp warp = wb.buildWarp(chained, mappingBB);
                    Warp sourceWarp = (Warp)op.getParameterBlock().getObjectParameter(0);
                    if (warp instanceof WarpGrid || warp instanceof WarpAffine || !(sourceWarp instanceof WarpGrid) && !(sourceWarp instanceof WarpAffine)) {
                        PlanarImage sourceImage = op.getSourceImage(0);
                        ParameterBlock paramBlk = new ParameterBlock().addSource(sourceImage);
                        Object property = sourceImage.getProperty("ROI");
                        if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                            paramBlk.add(warp).add(interpolation).add(bgValues);
                        } else {
                            paramBlk.add(warp).add(interpolation).add(bgValues).add(property);
                        }
                        Hints localHints = new Hints(this.commonHints);
                        localHints.remove(JAI.KEY_IMAGE_LAYOUT);
                        ImageLayout il = new ImageLayout();
                        il.setMinX(targetBB.x);
                        il.setMinY(targetBB.y);
                        il.setWidth(targetBB.width);
                        il.setHeight(targetBB.height);
                        il.setTileHeight(op.getTileHeight());
                        il.setTileWidth(op.getTileWidth());
                        il.setTileGridXOffset(0);
                        il.setTileGridYOffset(0);
                        localHints.put(JAI.KEY_IMAGE_LAYOUT, il);
                        RenderedOp result = JAI.create("Warp", paramBlk, localHints);
                        result.setProperty("MathTransform", chained);
                        this.image = result;
                        return this;
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to squash warp and affine into a single operation, chaining them instead", e);
                }
            }
            if ("Affine".equals(opName)) {
                paramBlock = op.getParameterBlock();
                sSource = paramBlock.getRenderedSource(0);
                AffineTransform sTx = (AffineTransform)paramBlock.getObjectParameter(0);
                Interpolation sInterp = (Interpolation)paramBlock.getObjectParameter(1);
                double[] sBgValues = (double[])paramBlock.getObjectParameter(2);
                if (sInterp == interpolation && Arrays.equals(sBgValues, bgValues)) {
                    AffineTransform concat = new AffineTransform(tx);
                    concat.concatenate(sTx);
                    tx = concat;
                    source = sSource;
                }
            } else if ("Scale".equals(opName)) {
                paramBlock = op.getParameterBlock();
                sSource = paramBlock.getRenderedSource(0);
                float xScale = paramBlock.getFloatParameter(0);
                float yScale = paramBlock.getFloatParameter(1);
                float xTrans = paramBlock.getFloatParameter(2);
                float yTrans = paramBlock.getFloatParameter(3);
                Interpolation sInterp = (Interpolation)paramBlock.getObjectParameter(4);
                if (sInterp == interpolation) {
                    AffineTransform concat = new AffineTransform(tx);
                    concat.concatenate(new AffineTransform(xScale, 0.0f, 0.0f, yScale, xTrans, yTrans));
                    tx = concat;
                    source = sSource;
                }
            }
        }
        hasScaleX = Math.abs(tx.getScaleX() - 1.0) * (double)size > (double)0.01f;
        hasScaleY = Math.abs(tx.getScaleY() - 1.0) * (double)size > (double)0.01f;
        hasShearX = Math.abs(tx.getShearX()) * (double)size > (double)0.01f;
        hasShearY = Math.abs(tx.getShearY()) * (double)size > (double)0.01f;
        hasTranslateX = Math.abs(tx.getTranslateX()) > (double)0.01f;
        hasTranslateY = Math.abs(tx.getTranslateY()) > (double)0.01f;
        boolean intTranslateX = Math.abs(tx.getTranslateX() - (double)Math.round(tx.getTranslateX())) < (double)0.01f;
        boolean bl2 = intTranslateY = Math.abs(tx.getTranslateY() - (double)Math.round(tx.getTranslateY())) < (double)0.01f;
        if (!(hasScaleX || hasScaleY || hasShearX || hasShearY || hasTranslateX || hasTranslateY)) {
            this.image = source;
            return this;
        }
        if (!hasShearX && !hasShearY) {
            if (!hasScaleX && !hasScaleY && intTranslateX && intTranslateY) {
                Hints localHints = new Hints(this.commonHints);
                localHints.remove(JAI.KEY_IMAGE_LAYOUT);
                this.image = ScaleDescriptor.create(source, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(Math.round(tx.getTranslateX())), Float.valueOf(Math.round(tx.getTranslateY())), interpolation, localHints);
            } else {
                this.image = ScaleDescriptor.create(source, Float.valueOf((float)tx.getScaleX()), Float.valueOf((float)tx.getScaleY()), Float.valueOf((float)tx.getTranslateX()), Float.valueOf((float)tx.getTranslateY()), interpolation, this.commonHints);
            }
        } else {
            this.image = AffineDescriptor.create(source, tx, interpolation, bgValues, this.commonHints);
        }
        return this;
    }

    public ImageWorker crop(float x, float y, float width, float height) {
        RenderedOp op;
        if ((float)this.image.getMinX() == x && (float)this.image.getMinY() == y && (float)this.image.getWidth() == width && (float)this.image.getHeight() == height) {
            return this;
        }
        RenderedImage source = this.image;
        if (this.image instanceof RenderedOp && ("Crop".equals((op = (RenderedOp)this.image).getOperationName()) || "GTCrop".equals(op.getOperationName()))) {
            ParameterBlock paramBlock = op.getParameterBlock();
            source = paramBlock.getRenderedSource(0);
            float sx = paramBlock.getFloatParameter(0);
            float sy = paramBlock.getFloatParameter(1);
            float sWidth = paramBlock.getFloatParameter(2);
            float sHeight = paramBlock.getFloatParameter(3);
            if (sx > 0.0f) {
                x = sx + x;
            }
            if (sy > 0.0f) {
                y = sy + y;
            }
        }
        this.image = GTCropDescriptor.create(source, Float.valueOf(x), Float.valueOf(y), Float.valueOf(width), Float.valueOf(height), this.commonHints);
        return this;
    }

    private ImageWorker write(Object output, Iterator<? extends ImageWriter> encoders) throws IOException {
        if (encoders != null) {
            while (encoders.hasNext()) {
                ImageOutputStream stream;
                Class<?>[] outputTypes;
                ImageWriter writer = encoders.next();
                ImageWriterSpi spi = writer.getOriginatingProvider();
                if (spi == null) {
                    outputTypes = ImageWriterSpi.STANDARD_OUTPUT_TYPE;
                } else {
                    String[] formats = spi.getFormatNames();
                    if (ImageWorker.containsFormatName(formats, "gif")) {
                        this.forceIndexColorModelForGIF(true);
                    } else {
                        this.tile();
                    }
                    if (!spi.canEncodeImage(this.image)) continue;
                    outputTypes = spi.getOutputTypes();
                }
                if (ImageWorker.acceptInputType(outputTypes, output.getClass())) {
                    writer.setOutput(output);
                    stream = null;
                } else {
                    if (!ImageWorker.acceptInputType(outputTypes, ImageOutputStream.class)) continue;
                    stream = ImageIOExt.createImageOutputStream(this.image, output);
                    writer.setOutput(stream);
                }
                writer.write(this.image);
                writer.dispose();
                if (stream != null) {
                    stream.close();
                }
                return this;
            }
        }
        throw new IIOException(Errors.format(135));
    }

    private static boolean acceptInputType(Class<?>[] types, Class<?> searchFor) {
        int i = types.length;
        while (--i >= 0) {
            if (!searchFor.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean containsFormatName(String[] formats, String searchFor) {
        int i = formats.length;
        while (--i >= 0) {
            if (!searchFor.equalsIgnoreCase(formats[i])) continue;
            return true;
        }
        return false;
    }

    public final ImageWorker show() throws HeadlessException {
        Class<?> c;
        try {
            c = Class.forName("org.geotools.gui.swing.image.OperationTreeBrowser");
        }
        catch (ClassNotFoundException cause) {
            HeadlessException e = new HeadlessException("The \"gt2-widgets-swing.jar\" file is required.");
            e.initCause(cause);
            throw e;
        }
        try {
            c.getMethod("show", RenderedImage.class).invoke(null, this.image);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new AssertionError((Object)e);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public final void dispose() {
        if (this.commonHints != null) {
            this.commonHints.clear();
        }
        this.commonHints = null;
        this.roi = null;
        if (this.image instanceof PlanarImage) {
            ImageUtilities.disposePlanarImageChain(PlanarImage.wrapRenderedImage(this.image));
        } else if (this.image instanceof BufferedImage) {
            ((BufferedImage)this.image).flush();
            this.image = null;
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        String operation = arguments.getOptionalString("-operation");
        args = arguments.getRemainingArguments(1);
        if (args.length != 0) {
            try {
                ImageWorker worker = new ImageWorker(new File(args[0]));
                worker.setRenderingHint(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache());
                if (operation != null) {
                    worker.getClass().getMethod(operation, null).invoke((Object)worker, (Object[])null);
                }
                worker.show();
            }
            catch (FileNotFoundException e) {
                arguments.printSummary(e);
            }
            catch (NoSuchMethodException e) {
                arguments.printSummary(e);
            }
            catch (Exception e) {
                e.printStackTrace(arguments.err);
            }
        }
    }

    static {
        ColorSpace cs;
        block13: {
            Class<?> clazz;
            LOGGER = Logging.getLogger("org.geotools.image");
            CODEC_LIB_AVAILABLE = PackageUtil.isCodecLibAvailable();
            ImageWriterSpi temp = null;
            try {
                clazz = Class.forName("com.sun.imageio.plugins.jpeg.JPEGImageWriterSpi");
                temp = clazz != null ? (ImageWriterSpi)clazz.newInstance() : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            JDK_JPEG_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                clazz = Class.forName("com.sun.media.imageioimpl.plugins.gif.GIFImageWriterSpi");
                temp = clazz != null ? (ImageWriterSpi)clazz.newInstance() : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            IMAGEIO_GIF_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                clazz = Class.forName("com.sun.media.imageioimpl.plugins.jpeg.CLibJPEGImageWriterSpi");
                temp = clazz != null && PackageUtil.isCodecLibAvailable() ? (ImageWriterSpi)clazz.newInstance() : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            IMAGEIO_JPEG_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                clazz = Class.forName("it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi");
                temp = clazz != null ? (ImageWriterSpi)clazz.newInstance() : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            IMAGEIO_EXT_TIFF_IMAGE_WRITER_SPI = temp;
            temp = null;
            try {
                clazz = Class.forName("com.sun.media.imageioimpl.plugins.png.CLibPNGImageWriterSpi");
                temp = clazz != null && PackageUtil.isCodecLibAvailable() ? (ImageWriterSpi)clazz.newInstance() : null;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
                temp = null;
            }
            CLIB_PNG_IMAGE_WRITER_SPI = temp;
            WARP_REDUCTION_ENABLED = Boolean.parseBoolean(System.getProperty(WARP_REDUCTION_ENABLED_KEY, "TRUE"));
            cs = null;
            try {
                cs = ColorSpace.getInstance(1002);
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.FINE)) break block13;
                LOGGER.log(Level.FINE, t.getLocalizedMessage(), t);
            }
        }
        CS_PYCC = cs;
        TILING_ALLOWED = new Hints.Key(Boolean.class);
        GTCropDescriptor.register();
        if (WARP_REDUCTION_ENABLED) {
            GTWarpPropertyGenerator.register(false);
        }
        LOGGER.log(Level.INFO, "Warp/affine reduction enabled: " + WARP_REDUCTION_ENABLED);
    }

    public static final class PNGImageWriteParam
    extends ImageWriteParam {
        public PNGImageWriteParam() {
            this.canWriteProgressive = true;
            this.canWriteCompressed = true;
            this.locale = Locale.getDefault();
        }
    }
}

