/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.collection.SubFeatureList;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class AbstractFeatureCollection
implements SimpleFeatureCollection {
    protected String id;
    protected SimpleFeatureType schema;

    protected AbstractFeatureCollection(SimpleFeatureType memberType) {
        this.id = this.id == null ? "featureCollection" : this.id;
        this.schema = memberType;
    }

    @Override
    public SimpleFeatureIterator features() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        if (iterator instanceof SimpleFeatureIterator) {
            return (SimpleFeatureIterator)((Object)iterator);
        }
        DelegateSimpleFeatureIterator iter = new DelegateSimpleFeatureIterator(this, iterator);
        return iter;
    }

    protected abstract Iterator<SimpleFeature> openIterator();

    @Override
    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Iterator<SimpleFeature> e = null;
        e = this.iterator();
        try {
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)((Object)e)).close();
            }
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator = this.openIterator();
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            boolean bl = !iterator.hasNext();
            return bl;
        }
        finally {
            if (iterator instanceof FeatureIterator) {
                ((FeatureIterator)((Object)iterator)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            if (e instanceof FeatureIterator) {
                ((FeatureIterator)((Object)e)).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <O> O[] toArray(O[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        Iterator<SimpleFeature> it = this.iterator();
        try {
            O[] result = a;
            for (int i = 0; i < size; ++i) {
                result[i] = it.next();
            }
            if (a.length > size) {
                a[size] = null;
            }
            Object[] objectArray = a;
            return objectArray;
        }
        finally {
            if (it instanceof FeatureIterator) {
                ((FeatureIterator)((Object)it)).close();
            }
        }
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return new SubFeatureList((SimpleFeatureCollection)this, order);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public abstract ReferencedEnvelope getBounds();
}

