/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.Splinex;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.Splinex.SplineHitTest;
import org.openstreetmap.josm.plugins.Splinex.UndeleteNodeCommand;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class Spline {
    public static IntegerProperty PROP_SPLINEPOINTS = new IntegerProperty("edit.spline.num_points", 10);
    private final ArrayList<SNode> nodes = new ArrayList();
    SplineHitTest sht = new SplineHitTest();

    public SNode getFirstSegment() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(0);
    }

    public SNode getLastSegment() {
        if (this.nodes.isEmpty()) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int nodeCount() {
        return this.nodes.size();
    }

    public boolean isClosed() {
        if (this.nodes.size() < 2) {
            return false;
        }
        return this.nodes.get(0) == this.nodes.get(this.nodes.size() - 1);
    }

    public void paint(Graphics2D g, MapView mv, Color curveColor, Color ctlColor, Point helperEndpoint, short direction) {
        if (this.nodes.isEmpty()) {
            return;
        }
        GeneralPath curv = new GeneralPath();
        GeneralPath ctl = new GeneralPath();
        Point2D cbPrev = null;
        if (helperEndpoint != null && direction == -1) {
            cbPrev = new Point2D.Double(helperEndpoint.x, helperEndpoint.y);
            curv.moveTo(helperEndpoint.x, helperEndpoint.y);
        }
        for (SNode sn : this.nodes) {
            Point2D pt = mv.getPoint2D(sn.node);
            EastNorth en = sn.node.getEastNorth();
            Point2D ca = mv.getPoint2D(en.add(sn.cprev));
            Point2D cb = mv.getPoint2D(en.add(sn.cnext));
            if (cbPrev != null || !this.isClosed()) {
                ctl.moveTo(ca.getX(), ca.getY());
                ctl.lineTo(pt.getX(), pt.getY());
                ctl.lineTo(cb.getX(), cb.getY());
            }
            if (cbPrev == null) {
                curv.moveTo(pt.getX(), pt.getY());
            } else {
                curv.curveTo(((Point2D)cbPrev).getX(), ((Point2D)cbPrev).getY(), ca.getX(), ca.getY(), pt.getX(), pt.getY());
            }
            cbPrev = cb;
        }
        if (helperEndpoint != null && direction == 1) {
            curv.curveTo(((Point2D)cbPrev).getX(), ((Point2D)cbPrev).getY(), helperEndpoint.getX(), helperEndpoint.getY(), helperEndpoint.getX(), helperEndpoint.getY());
        }
        g.setStroke(new BasicStroke(3.0f, 1, 1));
        g.setColor(curveColor);
        g.draw(curv);
        g.setStroke(new BasicStroke(1.0f));
        g.setColor(ctlColor);
        g.draw(ctl);
    }

    public PointHandle getNearestPoint(MapView mv, Point2D point) {
        PointHandle bestPH = null;
        double bestDistSq = NavigatableComponent.PROP_SNAP_DISTANCE.get().intValue();
        bestDistSq *= bestDistSq;
        for (int i = 0; i < this.nodes.size(); ++i) {
            for (SplinePoint sp : SplinePoint.values()) {
                PointHandle ph = new PointHandle(i, sp);
                double distSq = point.distanceSq(mv.getPoint2D(ph.getPoint()));
                if (!(distSq < bestDistSq)) continue;
                bestPH = ph;
                bestDistSq = distSq;
            }
        }
        return bestPH;
    }

    public boolean doesHit(double x, double y, MapView mv) {
        this.sht.setCoord(x, y, NavigatableComponent.PROP_SNAP_DISTANCE.get().intValue());
        Point2D prev = null;
        Point2D cbPrev = null;
        for (SNode sn : this.nodes) {
            Point2D pt = mv.getPoint2D(sn.node);
            EastNorth en = sn.node.getEastNorth();
            Point2D ca = mv.getPoint2D(en.add(sn.cprev));
            if (cbPrev != null && this.sht.checkCurve(prev.getX(), prev.getY(), cbPrev.getX(), cbPrev.getY(), ca.getX(), ca.getY(), pt.getX(), pt.getY())) {
                return true;
            }
            cbPrev = mv.getPoint2D(en.add(sn.cnext));
            prev = pt;
        }
        return false;
    }

    public void finishSpline() {
        if (this.nodes.isEmpty()) {
            return;
        }
        int detail = PROP_SPLINEPOINTS.get();
        Way w = new Way();
        LinkedList<Command> cmds = new LinkedList<Command>();
        Iterator<SNode> it = this.nodes.iterator();
        SNode sn = it.next();
        if (sn.node.isDeleted()) {
            cmds.add(new UndeleteNodeCommand(sn.node));
        }
        w.addNode(sn.node);
        EastNorth a = sn.node.getEastNorth();
        EastNorth ca = a.add(sn.cnext);
        while (it.hasNext()) {
            sn = it.next();
            if (sn.node.isDeleted() && sn != this.nodes.get(0)) {
                cmds.add(new UndeleteNodeCommand(sn.node));
            }
            EastNorth b = sn.node.getEastNorth();
            EastNorth cb = b.add(sn.cprev);
            if (!a.equalsEpsilon(ca, 1.0E-13) || !b.equalsEpsilon(cb, 1.0E-13)) {
                for (int i = 1; i < detail; ++i) {
                    Node n = new Node(Main.getProjection().eastNorth2latlon(Spline.cubicBezier(a, ca, cb, b, (double)i / (double)detail)));
                    if (n.getCoor().isOutSideWorld()) {
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Spline goes outside of the world.", (Object[])new Object[0]));
                        return;
                    }
                    cmds.add((Command)new AddCommand((OsmPrimitive)n));
                    w.addNode(n);
                }
            }
            w.addNode(sn.node);
            a = b;
            ca = a.add(sn.cnext);
        }
        if (!cmds.isEmpty()) {
            cmds.add((Command)new AddCommand((OsmPrimitive)w));
        }
        Main.main.undoRedo.add((Command)new FinishSplineCommand(cmds));
    }

    public static EastNorth cubicBezier(EastNorth a0, EastNorth a1, EastNorth a2, EastNorth a3, double t) {
        return new EastNorth(Spline.cubicBezierPoint(a0.getX(), a1.getX(), a2.getX(), a3.getX(), t), Spline.cubicBezierPoint(a0.getY(), a1.getY(), a2.getY(), a3.getY(), t));
    }

    private static double cubicBezierPoint(double a0, double a1, double a2, double a3, double t) {
        return Math.pow(1.0 - t, 3.0) * a0 + 3.0 * Math.pow(1.0 - t, 2.0) * t * a1 + 3.0 * (1.0 - t) * Math.pow(t, 2.0) * a2 + Math.pow(t, 3.0) * a3;
    }

    public List<OsmPrimitive> getNodes() {
        ArrayList<OsmPrimitive> result = new ArrayList<OsmPrimitive>(this.nodes.size());
        for (SNode sn : this.nodes) {
            result.add((OsmPrimitive)sn.node);
        }
        return result;
    }

    public class FinishSplineCommand
    extends SequenceCommand {
        public SNode[] saveSegments;

        public FinishSplineCommand(Collection<Command> sequenz) {
            super(I18n.tr((String)"Finish spline", (Object[])new Object[0]), sequenz);
        }

        public boolean executeCommand() {
            this.saveSegments = new SNode[Spline.this.nodes.size()];
            int i = 0;
            for (SNode sn : Spline.this.nodes) {
                this.saveSegments[i++] = sn;
            }
            Spline.this.nodes.clear();
            return super.executeCommand();
        }

        public void undoCommand() {
            super.undoCommand();
            Spline.this.nodes.clear();
            Spline.this.nodes.addAll(Arrays.asList(this.saveSegments));
        }
    }

    public class CloseSplineCommand
    extends Command {
        public boolean executeCommand() {
            Spline.this.nodes.add(Spline.this.nodes.get(0));
            return true;
        }

        public void undoCommand() {
            Spline.this.nodes.remove(Spline.this.nodes.size() - 1);
        }

        public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        }

        public String getDescriptionText() {
            return "Close spline";
        }

        public Icon getDescriptionIcon() {
            return ImageProvider.get((String)"aligncircle");
        }
    }

    public class EditSplineCommand
    extends Command {
        EastNorth cprev;
        EastNorth cnext;
        SNode sn;

        public EditSplineCommand(SNode sn) {
            this.sn = sn;
            this.cprev = sn.cprev.add(0.0, 0.0);
            this.cnext = sn.cnext.add(0.0, 0.0);
        }

        public boolean executeCommand() {
            EastNorth en = this.sn.cprev;
            this.sn.cprev = this.cprev;
            this.cprev = en;
            en = this.sn.cnext;
            this.sn.cnext = this.cnext;
            this.cnext = en;
            return true;
        }

        public void undoCommand() {
            this.executeCommand();
        }

        public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        }

        public String getDescriptionText() {
            return "Edit spline";
        }

        public Icon getDescriptionIcon() {
            return ImageProvider.get((String)"data", (String)"node");
        }
    }

    public class DeleteSplineNodeCommand
    extends Command {
        int idx;
        SNode sn;
        boolean wasDeleted;
        boolean affected;

        public DeleteSplineNodeCommand(int idx) {
            this.idx = idx;
        }

        private boolean deleteUnderlying() {
            return !this.sn.node.hasKeys() && this.sn.node.getReferrers().isEmpty() && (!Spline.this.isClosed() || this.idx < Spline.this.nodes.size() - 1);
        }

        public boolean executeCommand() {
            if (Spline.this.isClosed() && this.idx == 0) {
                this.idx = Spline.this.nodes.size() - 1;
            }
            this.sn = (SNode)Spline.this.nodes.get(this.idx);
            this.wasDeleted = this.sn.node.isDeleted();
            if (this.deleteUnderlying()) {
                this.sn.node.setDeleted(true);
                this.affected = true;
            }
            Spline.this.nodes.remove(this.idx);
            return true;
        }

        public void undoCommand() {
            this.affected = false;
            this.sn.node.setDeleted(this.wasDeleted);
            Spline.this.nodes.add(this.idx, this.sn);
        }

        public String getDescriptionText() {
            return I18n.tr((String)"Delete spline node {0}", (Object[])new Object[]{this.sn.node.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
        }

        public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
            if (this.deleteUnderlying()) {
                deleted.add((OsmPrimitive)this.sn.node);
            }
        }

        public Icon getDescriptionIcon() {
            return ImageProvider.get((String)"data", (String)"node");
        }

        public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
            return this.affected ? Collections.singleton(this.sn.node) : super.getParticipatingPrimitives();
        }
    }

    public class AddSplineNodeCommand
    extends Command {
        private final SNode sn;
        private final boolean existing;
        private final int idx;
        boolean affected;

        public AddSplineNodeCommand(SNode sn, boolean existing, int idx) {
            this.sn = sn;
            this.existing = existing;
            this.idx = idx;
        }

        public AddSplineNodeCommand(SNode sn, boolean existing) {
            this(sn, existing, spline.nodes.size() - 1);
        }

        public boolean executeCommand() {
            Spline.this.nodes.add(this.idx, this.sn);
            if (!this.existing) {
                this.getLayer().data.addPrimitive((OsmPrimitive)this.sn.node);
                this.sn.node.setModified(true);
                this.affected = true;
            }
            return true;
        }

        public void undoCommand() {
            if (!this.existing) {
                this.getLayer().data.removePrimitive((PrimitiveId)this.sn.node);
            }
            Spline.this.nodes.remove(this.idx);
            this.affected = false;
        }

        public String getDescriptionText() {
            if (this.existing) {
                return I18n.tr((String)"Add an existing node to spline: {0}", (Object[])new Object[]{this.sn.node.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
            }
            return I18n.tr((String)"Add a new node to spline: {0}", (Object[])new Object[]{this.sn.node.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
        }

        public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
            if (!this.existing) {
                added.add((OsmPrimitive)this.sn.node);
            }
        }

        public Icon getDescriptionIcon() {
            return ImageProvider.get((String)"data", (String)"node");
        }

        public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
            return this.affected ? Collections.singleton(this.sn.node) : super.getParticipatingPrimitives();
        }
    }

    public class PointHandle {
        public final int idx;
        public final SNode sn;
        public final SplinePoint point;

        public PointHandle(int idx, SplinePoint point) {
            if (point == null) {
                throw new IllegalArgumentException("Invalid SegmentPoint passed for PointHandle contructor");
            }
            this.idx = idx;
            this.sn = (SNode)Spline.this.nodes.get(idx);
            this.point = point;
        }

        public PointHandle otherPoint(SplinePoint point) {
            return new PointHandle(this.idx, point);
        }

        public Spline getSpline() {
            return Spline.this;
        }

        public EastNorth getPoint() {
            EastNorth en = this.sn.node.getEastNorth();
            switch (this.point) {
                case ENDPOINT: {
                    return en;
                }
                case CONTROL_PREV: {
                    return en.add(this.sn.cprev);
                }
                case CONTROL_NEXT: {
                    return en.add(this.sn.cnext);
                }
            }
            throw new AssertionError();
        }

        public void movePoint(EastNorth en) {
            switch (this.point) {
                case ENDPOINT: {
                    this.sn.node.setEastNorth(en);
                    return;
                }
                case CONTROL_PREV: {
                    this.sn.cprev = this.sn.node.getEastNorth().sub(en);
                    return;
                }
                case CONTROL_NEXT: {
                    this.sn.cnext = this.sn.node.getEastNorth().sub(en);
                    return;
                }
            }
            throw new AssertionError();
        }

        public boolean equals(Object other) {
            if (!(other instanceof PointHandle)) {
                return false;
            }
            PointHandle o = (PointHandle)other;
            return this.sn == o.sn && this.point == o.point;
        }
    }

    public static enum SplinePoint {
        ENDPOINT,
        CONTROL_PREV,
        CONTROL_NEXT;

    }

    public static class SNode {
        public final Node node;
        public EastNorth cprev;
        public EastNorth cnext;

        public SNode(Node node) {
            this.node = node;
            this.cprev = new EastNorth(0.0, 0.0);
            this.cnext = new EastNorth(0.0, 0.0);
        }
    }
}

