/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.SplineDrawingTool;

import java.util.Collection;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.tools.I18n;

class UndeleteNodeCommand
extends Command {
    Node n;
    boolean wasModified;

    public UndeleteNodeCommand(Node n) {
        this.n = n;
    }

    public boolean executeCommand() {
        if (!this.n.isDeleted()) {
            return false;
        }
        this.n.setDeleted(false);
        this.wasModified = this.n.isModified();
        this.n.setModified(true);
        return true;
    }

    public void undoCommand() {
        this.n.setDeleted(true);
        this.n.setModified(this.wasModified);
    }

    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
        modified.add((OsmPrimitive)this.n);
    }

    public String getDescriptionText() {
        return I18n.tr((String)"Undelete node {0}", (Object[])new Object[]{this.n.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
    }
}

