/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.SplineDrawingTool;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.plugins.SplineDrawingTool.Spline;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DrawSplineAction
extends MapMode
implements MapViewPaintable,
KeyPressReleaseListener,
ModifierListener,
MapView.LayerChangeListener {
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Color rubberLineColor;
    private final Shortcut backspaceShortcut;
    private final BackSpaceAction backspaceAction;
    boolean drawHelperLine;
    int initialMoveDelay;
    private Long mouseDownTime;
    private Spline.PointHandle ph;
    private Point helperEndpoint;
    public int index = 0;
    boolean lockCounterpart;
    private MoveCommand mc;
    private boolean dragControl;
    Node nodeHighlight;
    private Spline splCached;
    Map<Layer, Spline> layerSplines = new HashMap<Layer, Spline>();

    public DrawSplineAction(MapFrame mapFrame) {
        super(I18n.tr((String)"Spline drawing", (Object[])new Object[0]), "spline2", I18n.tr((String)"Draw a spline curve", (Object[])new Object[0]), mapFrame, DrawSplineAction.getCursor());
        this.backspaceShortcut = Shortcut.registerShortcut((String)"mapmode:backspace", (String)I18n.tr((String)"Backspace in Add mode", (Object[])new Object[0]), (int)8, (int)5003);
        this.backspaceAction = new BackSpaceAction();
        this.cursorJoinNode = ImageProvider.getCursor((String)"crosshair", (String)"joinnode");
        this.cursorJoinWay = ImageProvider.getCursor((String)"crosshair", (String)"joinway");
        MapView.addLayerChangeListener((MapView.LayerChangeListener)this);
        this.readPreferences();
    }

    private static Cursor getCursor() {
        try {
            return ImageProvider.getCursor((String)"crosshair", (String)"spline");
        }
        catch (Exception e) {
            Main.error((Throwable)e);
            return Cursor.getPredefinedCursor(1);
        }
    }

    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.readPreferences();
        Main.registerActionShortcut((Action)this.backspaceAction, (Shortcut)this.backspaceShortcut);
        Main.map.mapView.addMouseListener((MouseListener)((Object)this));
        Main.map.mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.addTemporaryLayer((MapViewPaintable)this);
        Main.map.keyDetector.addModifierListener((ModifierListener)this);
        Main.map.keyDetector.addKeyListener((KeyPressReleaseListener)this);
    }

    private void readPreferences() {
        this.rubberLineColor = Main.pref.getColor(I18n.marktr((String)"helper line"), null);
        if (this.rubberLineColor == null) {
            this.rubberLineColor = PaintColors.SELECTED.get();
        }
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener((MouseListener)((Object)this));
        Main.map.mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        Main.map.mapView.removeTemporaryLayer((MapViewPaintable)this);
        Main.unregisterActionShortcut((Action)this.backspaceAction, (Shortcut)this.backspaceShortcut);
        Main.map.statusLine.activateAnglePanel(false);
        Main.map.keyDetector.removeModifierListener((ModifierListener)this);
        Main.map.keyDetector.removeKeyListener((KeyPressReleaseListener)this);
        this.removeHighlighting();
        Main.map.mapView.repaint();
    }

    public void modifiersChanged(int modifiers) {
        this.updateKeyModifiers(modifiers);
    }

    public void mousePressed(MouseEvent e) {
        this.mouseDownTime = null;
        this.updateKeyModifiers(e);
        if (e.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        this.helperEndpoint = null;
        this.dragControl = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.ph = spl.getNearestPoint(Main.map.mapView, e.getPoint());
        if (e.getClickCount() == 2) {
            if (!spl.isClosed() && spl.nodeCount() > 1 && this.ph != null && this.ph.idx == 0 && this.ph.point == Spline.SplinePoint.ENDPOINT) {
                Main.main.undoRedo.add((Command)new Spline.CloseSplineCommand(spl));
                return;
            }
            spl.finishSpline();
            Main.map.repaint();
            return;
        }
        if (this.ph != null) {
            Command cmd;
            if (this.ctrl) {
                if (this.ph.point == Spline.SplinePoint.ENDPOINT) {
                    this.ph = this.ph.otherPoint(Spline.SplinePoint.CONTROL_NEXT);
                    this.lockCounterpart = true;
                } else {
                    this.lockCounterpart = false;
                }
            } else {
                boolean bl = this.lockCounterpart = this.ph.point != Spline.SplinePoint.ENDPOINT && Math.abs(this.ph.sn.cprev.east() + this.ph.sn.cnext.east()) < 1.0E-13 && Math.abs(this.ph.sn.cprev.north() + this.ph.sn.cnext.north()) < 1.0E-13;
            }
            if (this.ph.point == Spline.SplinePoint.ENDPOINT && !Main.main.undoRedo.commands.isEmpty() && (cmd = (Command)Main.main.undoRedo.commands.getLast()) instanceof MoveCommand) {
                this.mc = (MoveCommand)cmd;
                Collection pp = this.mc.getParticipatingPrimitives();
                if (pp.size() != 1 || !pp.contains(this.ph.sn.node)) {
                    this.mc = null;
                } else {
                    this.mc.changeStartPoint(this.ph.sn.node.getEastNorth());
                }
            }
            if (!(this.ph.point == Spline.SplinePoint.ENDPOINT || Main.main.undoRedo.commands.isEmpty() || (cmd = (Command)Main.main.undoRedo.commands.getLast()) instanceof Spline.EditSplineCommand && ((Spline.EditSplineCommand)cmd).sn == this.ph.sn)) {
                this.dragControl = true;
            }
            return;
        }
        if (spl.isClosed()) {
            return;
        }
        Node n = null;
        boolean existing = false;
        if (!this.ctrl) {
            n = Main.map.mapView.getNearestNode(e.getPoint(), OsmPrimitive.isUsablePredicate);
            existing = true;
        }
        if (n == null) {
            n = new Node(Main.map.mapView.getLatLon(e.getX(), e.getY()));
            existing = false;
        }
        UndoRedoHandler undoRedoHandler = Main.main.undoRedo;
        Spline spline = spl;
        spline.getClass();
        undoRedoHandler.add((Command)new Spline.AddSplineNodeCommand(spline, new Spline.SNode(n), existing));
        Spline spline2 = spl;
        spline2.getClass();
        this.ph = new Spline.PointHandle(spline2, spl.nodeCount() - 1, Spline.SplinePoint.CONTROL_NEXT);
        this.lockCounterpart = true;
        Main.map.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        this.mc = null;
        this.mouseDownTime = null;
        this.mouseMoved(e);
    }

    public void mouseDragged(MouseEvent e) {
        this.updateKeyModifiers(e);
        if (this.mouseDownTime == null) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        if (System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.ph == null) {
            return;
        }
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        if (spl.isEmpty()) {
            return;
        }
        EastNorth en = Main.map.mapView.getEastNorth(e.getX(), e.getY());
        if (Main.getProjection().eastNorth2latlon(en).isOutSideWorld()) {
            return;
        }
        if (this.ph.point == Spline.SplinePoint.ENDPOINT) {
            if (this.mc == null) {
                this.mc = new MoveCommand((OsmPrimitive)this.ph.sn.node, this.ph.sn.node.getEastNorth(), en);
                Main.main.undoRedo.add((Command)this.mc);
            } else {
                this.mc.applyVectorTo(en);
            }
        } else {
            if (this.dragControl) {
                UndoRedoHandler undoRedoHandler = Main.main.undoRedo;
                Spline spline = spl;
                spline.getClass();
                undoRedoHandler.add((Command)new Spline.EditSplineCommand(spline, this.ph.sn));
                this.dragControl = false;
            }
            this.ph.movePoint(en);
            if (this.lockCounterpart) {
                if (this.ph.point == Spline.SplinePoint.CONTROL_NEXT) {
                    this.ph.sn.cprev = this.ph.sn.cnext.sub(new EastNorth(0.0, 0.0));
                } else if (this.ph.point == Spline.SplinePoint.CONTROL_PREV) {
                    this.ph.sn.cnext = this.ph.sn.cprev.sub(new EastNorth(0.0, 0.0));
                }
            }
        }
        Main.map.repaint();
    }

    public void mouseMoved(MouseEvent e) {
        this.updateKeyModifiers(e);
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        Point oldHelperEndpoint = this.helperEndpoint;
        Spline.PointHandle oldph = this.ph;
        boolean redraw = false;
        this.ph = spl.getNearestPoint(Main.map.mapView, e.getPoint());
        if (this.ph == null) {
            Node n = null;
            if (!this.ctrl) {
                n = Main.map.mapView.getNearestNode(e.getPoint(), OsmPrimitive.isUsablePredicate);
            }
            if (n == null) {
                redraw = this.removeHighlighting();
                this.helperEndpoint = e.getPoint();
                Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            } else {
                redraw = this.setHighlight(n);
                Main.map.mapView.setNewCursor(this.cursorJoinNode, (Object)this);
                this.helperEndpoint = Main.map.mapView.getPoint(n);
            }
        } else {
            this.helperEndpoint = null;
            Main.map.mapView.setNewCursor(this.cursorJoinWay, (Object)this);
            redraw = this.ph.point == Spline.SplinePoint.ENDPOINT ? this.setHighlight(this.ph.sn.node) : this.removeHighlighting();
        }
        if (!this.drawHelperLine || spl.isClosed()) {
            this.helperEndpoint = null;
        }
        if (redraw || oldHelperEndpoint != this.helperEndpoint || oldph == null && this.ph != null || oldph != null && !oldph.equals(this.ph)) {
            Main.map.repaint();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.removeHighlighting();
        this.helperEndpoint = null;
        Main.map.mapView.repaint();
    }

    private boolean setHighlight(Node n) {
        if (this.nodeHighlight == n) {
            return false;
        }
        this.removeHighlighting();
        this.nodeHighlight = n;
        n.setHighlighted(true);
        return true;
    }

    private boolean removeHighlighting() {
        if (this.nodeHighlight != null) {
            this.nodeHighlight.setHighlighted(false);
            this.nodeHighlight = null;
            return true;
        }
        return false;
    }

    public void paint(Graphics2D g, MapView mv, Bounds box) {
        Spline spl = this.getSpline();
        if (spl == null) {
            return;
        }
        spl.paint(g, mv, this.rubberLineColor, Color.green, this.helperEndpoint);
        if (this.ph != null && this.ph.point != Spline.SplinePoint.ENDPOINT) {
            g.setColor(MapPaintSettings.INSTANCE.getSelectedColor());
            Point p = mv.getPoint(this.ph.getPoint());
            g.fillRect(p.x - 1, p.y - 1, 3, 3);
        }
    }

    public boolean layerIsSupported(Layer l) {
        return l instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(DrawSplineAction.getEditLayer() != null);
    }

    Spline getSpline() {
        if (this.splCached != null) {
            return this.splCached;
        }
        OsmDataLayer l = Main.main.getEditLayer();
        if (!(l instanceof OsmDataLayer)) {
            return null;
        }
        this.splCached = this.layerSplines.get(l);
        if (this.splCached == null) {
            this.splCached = new Spline();
        }
        this.layerSplines.put((Layer)l, this.splCached);
        return this.splCached;
    }

    public void activeLayerChange(Layer oldLayer, Layer newLayer) {
        this.splCached = this.layerSplines.get(newLayer);
    }

    public void layerAdded(Layer newLayer) {
    }

    public void layerRemoved(Layer oldLayer) {
        this.layerSplines.remove(oldLayer);
        this.splCached = null;
    }

    public void doKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127 && this.ph != null) {
            Spline spl = this.ph.getSpline();
            if (spl.nodeCount() == 3 && spl.isClosed() && this.ph.idx == 1) {
                return;
            }
            UndoRedoHandler undoRedoHandler = Main.main.undoRedo;
            Spline spline = spl;
            spline.getClass();
            undoRedoHandler.add((Command)new Spline.DeleteSplineNodeCommand(spline, this.ph.idx));
            e.consume();
        }
    }

    public void doKeyReleased(KeyEvent e) {
    }

    public class BackSpaceAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            Main.main.undoRedo.undo();
        }
    }
}

