/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.kartverket;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.DecimalFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.plugins.kartverket.CheckNextWayI;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CheckDirectionDialog
extends JDialog {
    private StopCheck stop = new StopCheck();
    private WayDirectionCorrect wayCorrect;
    private WayDirectionWrong wayWrong;
    private WayDirectionIgnore wayIgnore;
    private SideButton defaultButton;

    public CheckDirectionDialog(CheckNextWayI checkNextWay, double progress) {
        super(JOptionPane.getFrameForComponent(Main.parent), false);
        this.wayCorrect = new WayDirectionCorrect(checkNextWay);
        this.wayWrong = new WayDirectionWrong(checkNextWay);
        this.wayIgnore = new WayDirectionIgnore(checkNextWay);
        this.build(progress);
    }

    public void makeVisible() {
        this.setVisible(true);
        this.defaultButton.requestFocus();
    }

    protected void build(double progress) {
        this.setLayout(new BorderLayout());
        this.setTitle(I18n.tr((String)"Check the direction", (Object[])new Object[0]));
        DecimalFormat df = new DecimalFormat("#");
        JLabel description = new JLabel(I18n.tr((String)I18n.tr((String)"Check the direction of the selected stream/river. Is it correct?\n Progress: ", (Object[])new Object[0]), (Object[])new Object[0]) + df.format(progress * 100.0) + " %");
        this.add((Component)description, "Center");
        JPanel pnl = new JPanel();
        pnl.setLayout(new FlowLayout(1));
        SideButton btn = new SideButton((Action)this.wayCorrect);
        btn.setName(I18n.tr((String)"Correct", (Object[])new Object[0]));
        pnl.add((Component)btn);
        this.defaultButton = btn;
        btn = new SideButton((Action)this.wayWrong);
        btn.setName(I18n.tr((String)"Wrong", (Object[])new Object[0]));
        pnl.add((Component)btn);
        btn = new SideButton((Action)this.wayIgnore);
        btn.setName(I18n.tr((String)"Ignore", (Object[])new Object[0]));
        pnl.add((Component)btn);
        btn = new SideButton((Action)this.stop);
        btn.setName(I18n.tr((String)"Stop", (Object[])new Object[0]));
        pnl.add((Component)btn);
        this.add((Component)pnl, "South");
        Point p = new Point(200, 100);
        this.setLocation(p);
        Dimension minimumSize = new Dimension(500, 120);
        this.setMinimumSize(minimumSize);
    }

    class WayDirectionIgnore
    extends AbstractAction {
        CheckNextWayI parent;

        public WayDirectionIgnore(CheckNextWayI parent) {
            this.putValue("Name", I18n.tr((String)"<HTML><U>I</U>gnore this way</HTML>", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Ignore direction of this way.", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"redo"));
            this.putValue("MnemonicKey", 73);
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.wayDirectionIgnore();
            CheckDirectionDialog.this.setVisible(false);
        }
    }

    class WayDirectionWrong
    extends AbstractAction {
        CheckNextWayI parent;

        public WayDirectionWrong(CheckNextWayI parent) {
            this.putValue("Name", I18n.tr((String)"<HTML><U>W</U>rong dirrection</HTML>", (Object[])new Object[0]));
            this.putValue("MnemonicKey", 87);
            this.putValue("ShortDescription", I18n.tr((String)"Direction of river is wrong.", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"wayflip"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.wayDirectionIsWrong();
            CheckDirectionDialog.this.setVisible(false);
        }
    }

    class WayDirectionCorrect
    extends AbstractAction {
        CheckNextWayI parent;

        public WayDirectionCorrect(CheckNextWayI parent) {
            this.putValue("Name", I18n.tr((String)"<HTML><U>C</U>orrect direction</HTML>", (Object[])new Object[0]));
            this.putValue("MnemonicKey", 67);
            this.putValue("ShortDescription", I18n.tr((String)"Direction of river is correct.", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"ok"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.wayDirectionIsCorrect();
            CheckDirectionDialog.this.setVisible(false);
        }
    }

    class StopCheck
    extends AbstractAction {
        public StopCheck() {
            this.putValue("Name", I18n.tr((String)"Close", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Close the dialog", (Object[])new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get((String)"cancel"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckDirectionDialog.this.setVisible(false);
        }
    }
}

