/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.kartverket.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryCommand;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryException;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ReplaceWayAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Replace way", (Object[])new Object[0]);

    public ReplaceWayAction() {
        super(TITLE, null, I18n.tr((String)"Replace way of selected way with a new way", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:replacecoastline", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Replace Geometry", (Object[])new Object[0])}), (int)83, (int)5009), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (ReplaceWayAction.getCurrentDataSet() == null) {
            return;
        }
        ArrayList selection = new ArrayList(ReplaceWayAction.getCurrentDataSet().getSelected());
        if (selection.size() != 2 && selection.get(0) instanceof Way && selection.get(1) instanceof Way) {
            new Notification(I18n.tr((String)"This tool replaces coastline of one way with another, and so requires exactly two coatline ways to be selected.", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        Way firstObject = (Way)selection.get(0);
        Way secondObject = (Way)selection.get(1);
        Map keys = firstObject.getId() < 0L ? firstObject.getKeys() : secondObject.getKeys();
        String source = null;
        String sourceDate = null;
        if (keys.containsKey("source")) {
            source = (String)keys.get("source");
        }
        if (keys.containsKey("source:date")) {
            sourceDate = (String)keys.get("source:date");
        }
        this.setSourceAndFixme(firstObject, source, sourceDate);
        this.setSourceAndFixme(secondObject, source, sourceDate);
        try {
            firstObject.getKeys();
            ReplaceGeometryCommand replaceCommand = ReplaceGeometryUtils.buildReplaceWayWithNewCommand(Arrays.asList(firstObject, secondObject));
            if (replaceCommand == null) {
                return;
            }
            Main.main.undoRedo.add((Command)replaceCommand);
        }
        catch (IllegalArgumentException ex) {
            new Notification(ex.getMessage()).setIcon(2).show();
        }
        catch (ReplaceGeometryException ex) {
            new Notification(ex.getMessage()).setIcon(2).show();
        }
    }

    private void setSourceAndFixme(Way way, String source, String sourceDate) {
        Map keys = way.getKeys();
        if (source != null) {
            keys.put("source", source);
        }
        if (sourceDate != null) {
            keys.put("source:date", sourceDate);
        }
        if (keys.containsKey("FIXME") && keys.get("FIXME") == "Merge") {
            keys.remove("FIXME");
        }
        way.setKeys(keys);
    }

    protected void updateEnabledState() {
        if (ReplaceWayAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ReplaceWayAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() >= 2);
    }
}

