/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImageDisplay;
import org.openstreetmap.josm.plugins.mapillary.MapillaryLayer;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPlugin;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryToggleDialog
extends ToggleDialog
implements ICachedLoaderListener {
    public static MapillaryToggleDialog INSTANCE;
    public volatile MapillaryImage image;
    final SideButton nextButton = new SideButton((Action)new nextPictureAction());
    final SideButton previousButton = new SideButton((Action)new previousPictureAction());
    final SideButton redButton = new SideButton((Action)new redAction());
    final SideButton blueButton = new SideButton((Action)new blueAction());
    private JPanel buttonsPanel;
    private JPanel top;
    public MapillaryImageDisplay mapillaryImageDisplay = new MapillaryImageDisplay();
    private MapillaryCache imageCache;
    private MapillaryCache thumbnailCache;

    public MapillaryToggleDialog() {
        super(I18n.tr((String)"Mapillary image", (Object[])new Object[0]), "mapillary.png", I18n.tr((String)"Open Mapillary window", (Object[])new Object[0]), null, 200);
        this.blueButton.setForeground(Color.BLUE);
        this.redButton.setForeground(Color.RED);
        this.setLayout(new BorderLayout());
        this.top = new JPanel();
        this.top.setLayout(new BorderLayout());
        this.top.add((Component)this.titleBar, "North");
        this.createLayout(this.mapillaryImageDisplay, Arrays.asList(this.blueButton, this.previousButton, this.nextButton, this.redButton), Main.pref.getBoolean("mapillary.reverse-buttons"));
    }

    public static MapillaryToggleDialog getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryToggleDialog();
        }
        return INSTANCE;
    }

    public static void destroyInstance() {
        INSTANCE = null;
    }

    public synchronized void updateImage() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryToggleDialog.this.updateImage();
                }
            });
        } else {
            if (!MapillaryLayer.INSTANCED.booleanValue()) {
                return;
            }
            if (this.image == null) {
                return;
            }
            this.nextButton.setEnabled(true);
            this.previousButton.setEnabled(true);
            if (this.image.next() == null) {
                this.nextButton.setEnabled(false);
            }
            if (this.image.previous() == null) {
                this.previousButton.setEnabled(false);
            }
            try {
                this.mapillaryImageDisplay.setImage(null);
                MapillaryPlugin.CACHE = JCSCacheManager.getCache((String)"mapillary");
                if (this.thumbnailCache != null) {
                    this.thumbnailCache.cancelOutstandingTasks();
                }
                this.thumbnailCache = new MapillaryCache(this.image.getKey(), MapillaryCache.Type.THUMBNAIL);
                this.thumbnailCache.submit(this, false);
                if (this.imageCache != null) {
                    this.imageCache.cancelOutstandingTasks();
                }
                this.imageCache = new MapillaryCache(this.image.getKey(), MapillaryCache.Type.FULL_IMAGE);
                this.imageCache.submit(this, false);
            }
            catch (IOException e) {
                Main.error((Throwable)e);
            }
        }
    }

    public synchronized void setImage(MapillaryImage image) {
        this.image = image;
    }

    public synchronized MapillaryImage getImage() {
        return this.image;
    }

    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MapillaryToggleDialog.this.updateImage();
                }
            });
        } else if (data != null) {
            try {
                BufferedImage img = ImageIO.read(new ByteArrayInputStream(data.getContent()));
                if (this.mapillaryImageDisplay.getImage() == null) {
                    this.mapillaryImageDisplay.setImage(img);
                } else if (img.getHeight() > this.mapillaryImageDisplay.getImage().getHeight()) {
                    this.mapillaryImageDisplay.setImage(img);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void createLayout(Component data, List<SideButton> buttons, boolean reverse) {
        this.add(data, "Center");
        if (!buttons.isEmpty() && buttons.get(0) != null) {
            this.buttonsPanel = new JPanel(new GridLayout(1, 1));
            JPanel buttonRowPanel = new JPanel(Main.pref.getBoolean("dialog.align.left", false) ? new FlowLayout(0) : new GridLayout(1, buttons.size()));
            this.buttonsPanel.add(buttonRowPanel);
            for (SideButton button : buttons) {
                buttonRowPanel.add((Component)button);
            }
            if (reverse) {
                this.top.add((Component)this.buttonsPanel, "South");
            } else {
                this.add(this.buttonsPanel, "South");
            }
        }
        this.add(this.top, "North");
    }

    class blueAction
    extends AbstractAction {
        public blueAction() {
            this.putValue("Name", "Jump to blue");
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().setSelectedImage(MapillaryLayer.BLUE);
                MapillaryToggleDialog.getInstance().setImage(MapillaryLayer.BLUE);
                MapillaryToggleDialog.getInstance().updateImage();
                Main.map.mapView.zoomTo(MapillaryData.getInstance().getSelectedImage().getLatLon());
            }
        }
    }

    class redAction
    extends AbstractAction {
        public redAction() {
            this.putValue("Name", "Jump to red");
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().setSelectedImage(MapillaryLayer.RED);
                MapillaryToggleDialog.getInstance().setImage(MapillaryLayer.RED);
                MapillaryToggleDialog.getInstance().updateImage();
                Main.map.mapView.zoomTo(MapillaryData.getInstance().getSelectedImage().getLatLon());
            }
        }
    }

    class previousPictureAction
    extends AbstractAction {
        public previousPictureAction() {
            this.putValue("Name", I18n.tr((String)"Previous picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the previous picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().selectPrevious();
                if (MapillaryData.getInstance().getSelectedImage() != null) {
                    Main.map.mapView.zoomTo(MapillaryData.getInstance().getSelectedImage().getLatLon());
                }
            }
        }
    }

    class nextPictureAction
    extends AbstractAction {
        public nextPictureAction() {
            this.putValue("Name", I18n.tr((String)"Next picture", (Object[])new Object[0]));
            this.putValue("ShortDescription", I18n.tr((String)"Shows the next picture in the sequence", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MapillaryToggleDialog.getInstance().getImage() != null) {
                MapillaryData.getInstance().selectNext();
                if (MapillaryData.getInstance().getSelectedImage() != null) {
                    Main.map.mapView.zoomTo(MapillaryData.getInstance().getSelectedImage().getLatLon());
                }
            }
        }
    }
}

