/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.mapillary.MapillaryDownloadAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryExportAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryPreferenceSetting;
import org.openstreetmap.josm.plugins.mapillary.MapillaryToggleDialog;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapillaryPlugin
extends Plugin {
    public static final ImageIcon ICON24 = new ImageProvider("icon24.png").get();
    public static final ImageIcon ICON16 = new ImageProvider("icon16.png").get();
    public static final ImageIcon MAP_ICON = new ImageProvider("mapicon.png").get();
    public static final ImageIcon MAP_ICON_SELECTED = new ImageProvider("mapiconselected.png").get();
    public static final int ICON_SIZE = 24;
    public static CacheAccess<String, BufferedImageCacheEntry> CACHE;
    private final MapillaryDownloadAction downloadAction = new MapillaryDownloadAction();
    private final MapillaryExportAction exportAction = new MapillaryExportAction();
    public static JMenuItem DOWNLOAD_MENU;
    public static JMenuItem EXPORT_MENU;

    public MapillaryPlugin(PluginInformation info) {
        super(info);
        DOWNLOAD_MENU = MainMenu.add((JMenu)Main.main.menu.imageryMenu, (JosmAction)this.downloadAction, (boolean)false);
        EXPORT_MENU = MainMenu.add((JMenu)Main.main.menu.fileMenu, (JosmAction)this.exportAction, (boolean)false, (Integer)14);
        EXPORT_MENU.setEnabled(false);
        try {
            CACHE = JCSCacheManager.getCache((String)"mapillary", (int)10, (int)10000, (String)(this.getPluginDir() + "/cache/"));
        }
        catch (IOException e) {
            Main.error((Throwable)e);
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (oldFrame != null || newFrame != null) {
            // empty if block
        }
        if (oldFrame != null && newFrame == null) {
            MapillaryToggleDialog.destroyInstance();
        }
    }

    public static void setMenuEnabled(JMenuItem menu, boolean value) {
        menu.setEnabled(value);
    }

    public PreferenceSetting getPreferenceSetting() {
        return new MapillaryPreferenceSetting();
    }
}

