/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySequenceDownloadThread;

public class MapillarySquareDownloadManagerThread
implements Runnable {
    private final String urlImages;
    private final String urlSequences;
    private final Bounds bounds;

    public MapillarySquareDownloadManagerThread(String urlImages, String urlSequences, Bounds bounds) {
        this.urlImages = urlImages;
        this.urlSequences = urlSequences;
        this.bounds = bounds;
    }

    @Override
    public void run() {
        this.downloadSequences();
    }

    public void downloadSequences() {
        ThreadPoolExecutor ex = new ThreadPoolExecutor(3, 5, 25L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(5));
        int page = 0;
        while (!ex.isShutdown()) {
            ex.execute(new MapillarySequenceDownloadThread(ex, this.urlSequences + "&page=" + page + "&limit=1", this.bounds));
            try {
                while (ex.getQueue().remainingCapacity() == 0) {
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                Main.error((Throwable)e);
            }
            ++page;
        }
        try {
            while (!ex.awaitTermination(15L, TimeUnit.SECONDS)) {
            }
        }
        catch (Exception e) {
            Main.error((Throwable)e);
        }
        MapillaryData.getInstance().dataUpdated();
    }
}

