/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.util.concurrent.ConcurrentHashMap;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillarySquareDownloadManagerThread;

public class MapillaryDownloader {
    public static final String BASE_URL = "https://a.mapillary.com/v2/";
    public static final String CLIENT_ID = "NzNRM2otQkR2SHJzaXJmNmdQWVQ0dzo1YTA2NmNlODhlNWMwOTBm";
    private String[] parameters = new String[]{"lat", "lon", "distance", "limit", "min_lat", "min_lon", "max_lat", "max_lon"};

    public void getImages(LatLon minLatLon, LatLon maxLatLon) {
        String url1 = BASE_URL;
        String url2 = BASE_URL;
        url1 = url1 + "search/im/";
        url2 = url2 + "search/s/";
        ConcurrentHashMap<String, Double> hash = new ConcurrentHashMap<String, Double>();
        hash.put("min_lat", minLatLon.lat());
        hash.put("min_lon", minLatLon.lon());
        hash.put("max_lat", maxLatLon.lat());
        hash.put("max_lon", maxLatLon.lon());
        url1 = url1 + this.buildParameters(hash);
        url2 = url2 + this.buildParameters(hash);
        try {
            Main.info((String)("MapillaryPlugin GET " + url2));
            Main.worker.submit(new MapillarySquareDownloadManagerThread(url1, url2, new Bounds(minLatLon, maxLatLon)));
        }
        catch (Exception e) {
            Main.error((Throwable)e);
        }
    }

    private String buildParameters(ConcurrentHashMap<String, Double> hash) {
        String ret = "?client_id=NzNRM2otQkR2SHJzaXJmNmdQWVQ0dzo1YTA2NmNlODhlNWMwOTBm";
        for (int i = 0; i < this.parameters.length; ++i) {
            if (hash.get(this.parameters[i]) == null) continue;
            ret = ret + "&" + this.parameters[i] + "=" + hash.get(this.parameters[i]);
        }
        return ret;
    }
}

