/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;

public class MapillarySequence {
    private final List<MapillaryImage> images = new ArrayList<MapillaryImage>();
    private final String key;
    private final int created_at;

    public MapillarySequence(String key, int created_at) {
        this.key = key;
        this.created_at = created_at;
    }

    public List<MapillaryImage> getImages() {
        return this.images;
    }

    public int getCreatedAt() {
        return this.created_at;
    }

    public synchronized void add(MapillaryImage image) {
        this.images.add(image);
    }

    public String getKey() {
        return this.key;
    }

    public synchronized void add(List<MapillaryImage> images) {
        for (MapillaryImage image : images) {
            this.add(image);
        }
    }

    public void remove(MapillaryImage image) {
        this.images.remove(image);
    }

    public MapillaryImage next(MapillaryImage image) {
        if (!this.images.contains(image)) {
            throw new IllegalArgumentException();
        }
        int i = this.images.indexOf(image);
        if (i == this.images.size() - 1) {
            return null;
        }
        return this.images.get(i + 1);
    }

    public MapillaryImage previous(MapillaryImage image) {
        if (!this.images.contains(image)) {
            throw new IllegalArgumentException();
        }
        int i = this.images.indexOf(image);
        if (i == 0) {
            return null;
        }
        return this.images.get(i - 1);
    }

    public int getDistance(MapillaryImage image1, MapillaryImage image2) {
        if (!this.images.contains(image1) || !this.images.contains(image2)) {
            throw new IllegalArgumentException();
        }
        return Math.abs(this.images.indexOf(image1) - this.images.indexOf(image2));
    }

    public boolean equals(MapillarySequence sequence) {
        return this.getKey() == sequence.getKey();
    }
}

