/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary.downloads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public class MapillarySequenceDownloadThread
implements Runnable {
    private String url;
    private ExecutorService ex;
    private Bounds bounds;

    public MapillarySequenceDownloadThread(ExecutorService ex, String url, Bounds bounds) {
        this.url = url;
        this.ex = ex;
        this.bounds = bounds;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(this.url).openStream()));
            JsonObject jsonall = Json.createReader((Reader)br).readObject();
            if (!jsonall.getBoolean("more") && !this.ex.isShutdown()) {
                this.ex.shutdown();
            }
            JsonArray jsonseq = jsonall.getJsonArray("ss");
            boolean isSequenceWrong = false;
            for (int i = 0; i < jsonseq.size(); ++i) {
                JsonObject jsonobj = jsonseq.getJsonObject(i);
                JsonArray cas = jsonobj.getJsonArray("cas");
                JsonArray coords = jsonobj.getJsonArray("coords");
                JsonArray keys = jsonobj.getJsonArray("keys");
                ArrayList<MapillaryImage> images = new ArrayList<MapillaryImage>();
                for (int j = 0; j < cas.size(); ++j) {
                    try {
                        images.add(new MapillaryImage(keys.getString(j), coords.getJsonArray(j).getJsonNumber(1).doubleValue(), coords.getJsonArray(j).getJsonNumber(0).doubleValue(), cas.getJsonNumber(j).doubleValue()));
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        Main.warn((String)("Mapillary bug at " + this.url));
                        isSequenceWrong = true;
                        continue;
                    }
                    catch (Exception e) {
                        Main.error((Throwable)e);
                    }
                }
                if (!isSequenceWrong) {
                    MapillarySequence sequence = new MapillarySequence(jsonobj.getString("key"), jsonobj.getJsonNumber("captured_at").intValue());
                    for (MapillaryImage mimage : MapillaryData.getInstance().getImages()) {
                        if (mimage.getSequence().getKey() == sequence.getKey()) break;
                    }
                    int first = -1;
                    int last = -1;
                    int pos = 0;
                    for (MapillaryImage img : images) {
                        if (first == -1 && this.bounds.contains(img.getLatLon())) {
                            first = pos;
                        } else if (first != -1 && last == -1 && !this.bounds.contains(img.getLatLon())) {
                            last = pos;
                        } else if (last != -1 && this.bounds.contains(img.getLatLon())) {
                            last = -1;
                        }
                        ++pos;
                    }
                    if (last == -1) {
                        last = pos;
                    }
                    if (first == -1) continue;
                    List<MapillaryImage> finalImages = images.subList(first, last);
                    for (MapillaryImage img : finalImages) {
                        img.setSequence(sequence);
                    }
                    MapillaryData.getInstance().addWithoutUpdate(finalImages);
                    sequence.add(finalImages);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            Main.error((String)("Error reading the url " + this.url + " might be a Mapillary problem."));
        }
    }
}

