/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.MapillaryToggleDialog;
import org.openstreetmap.josm.plugins.mapillary.cache.MapillaryCache;

public class MapillaryData
implements ICachedLoaderListener {
    public static volatile MapillaryData INSTANCE;
    private final List<MapillaryImage> images = new CopyOnWriteArrayList<MapillaryImage>();
    private MapillaryImage selectedImage = null;
    private final List<MapillaryImage> multiSelectedImages = new ArrayList<MapillaryImage>();

    public static MapillaryData getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MapillaryData();
        }
        return INSTANCE;
    }

    public synchronized void add(List<MapillaryImage> images) {
        for (MapillaryImage image : images) {
            this.add(image);
        }
    }

    public synchronized void add(MapillaryImage image) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
        this.dataUpdated();
    }

    public synchronized void addWithoutUpdate(List<MapillaryImage> images) {
        for (MapillaryImage image : images) {
            this.addWithoutUpdate(image);
        }
    }

    public synchronized void addWithoutUpdate(MapillaryImage image) {
        if (!this.images.contains(image)) {
            this.images.add(image);
        }
    }

    public synchronized void dataUpdated() {
        Main.map.mapView.repaint();
    }

    public List<MapillaryImage> getImages() {
        return this.images;
    }

    public MapillaryImage getSelectedImage() {
        return this.selectedImage;
    }

    public void selectNext() {
        if (this.getSelectedImage() == null) {
            return;
        }
        if (this.getSelectedImage().getSequence() == null) {
            return;
        }
        this.setSelectedImage(this.getSelectedImage().next());
    }

    public void selectPrevious() {
        if (this.getSelectedImage() == null) {
            return;
        }
        if (this.getSelectedImage().getSequence() == null) {
            throw new IllegalStateException();
        }
        this.setSelectedImage(this.getSelectedImage().previous());
    }

    public void setSelectedImage(MapillaryImage image) {
        this.selectedImage = image;
        this.multiSelectedImages.clear();
        this.multiSelectedImages.add(image);
        if (image != null) {
            MapillaryToggleDialog.getInstance().setImage(this.selectedImage);
            MapillaryToggleDialog.getInstance().updateImage();
            if (image.next() != null) {
                new MapillaryCache(image.next().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                if (image.next().next() != null) {
                    new MapillaryCache(image.next().next().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                }
            }
            if (image.previous() != null) {
                new MapillaryCache(image.previous().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                if (image.previous().previous() != null) {
                    new MapillaryCache(image.previous().previous().getKey(), MapillaryCache.Type.THUMBNAIL).submit(this, false);
                }
            }
        }
        if (Main.map != null) {
            Main.map.mapView.repaint();
        }
    }

    public void addMultiSelectedImage(MapillaryImage image) {
        this.multiSelectedImages.add(image);
        Main.map.mapView.repaint();
    }

    public List<MapillaryImage> getMultiSelectedImages() {
        return this.multiSelectedImages;
    }

    public void loadingFinished(CacheEntry data, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
    }
}

