/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;

public class MapillarySequence {
    private final List<MapillaryImage> images;
    private String timestamp;

    public MapillarySequence() {
        this.images = new ArrayList<MapillaryImage>();
    }

    public MapillarySequence(List<MapillaryImage> images) {
        this.images = images;
    }

    public List<MapillaryImage> getImages() {
        return this.images;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public synchronized void add(MapillaryImage image) {
        this.images.add(image);
    }

    public synchronized void add(List<MapillaryImage> images) {
        for (MapillaryImage image : images) {
            this.add(image);
        }
    }

    public void remove(MapillaryImage image) {
        this.images.remove(image);
    }

    public MapillaryImage next(MapillaryImage image) {
        if (!this.images.contains(image)) {
            throw new IllegalArgumentException();
        }
        int i = this.images.indexOf(image);
        if (i == this.images.size() - 1) {
            return null;
        }
        return this.images.get(i + 1);
    }

    public MapillaryImage previous(MapillaryImage image) {
        if (!this.images.contains(image)) {
            throw new IllegalArgumentException();
        }
        int i = this.images.indexOf(image);
        if (i == 0) {
            return null;
        }
        return this.images.get(i - 1);
    }

    public int getDistance(MapillaryImage image1, MapillaryImage image2) {
        if (!this.images.contains(image1) || !this.images.contains(image2)) {
            throw new IllegalArgumentException();
        }
        return Math.abs(this.images.indexOf(image1) - this.images.indexOf(image2));
    }
}

