/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.plugins.mapillary.MapillaryExportDialog;
import org.openstreetmap.josm.plugins.mapillary.MapillaryImage;
import org.openstreetmap.josm.plugins.mapillary.downloads.MapillaryExportManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class MapillaryExportAction
extends JosmAction {
    MapillaryExportDialog dialog;

    public MapillaryExportAction() {
        super(I18n.tr((String)"Export images", (Object[])new Object[0]), new ImageProvider("icon24.png"), I18n.tr((String)"Export images.", (Object[])new Object[0]), null, false, "mapillaryExport", false);
    }

    public void actionPerformed(ActionEvent e) {
        this.dialog = new MapillaryExportDialog();
        JOptionPane pane = new JOptionPane(this.dialog, -1, 2);
        JDialog dlg = pane.createDialog(Main.parent, I18n.tr((String)"Export images", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0 && this.dialog.chooser != null) {
            if (this.dialog.group.isSelected(this.dialog.all.getModel())) {
                this.export(MapillaryData.getInstance().getImages());
            } else if (this.dialog.group.isSelected(this.dialog.sequence.getModel())) {
                this.export(MapillaryData.getInstance().getSelectedImage().getSequence().getImages());
            } else if (this.dialog.group.isSelected(this.dialog.selected.getModel())) {
                this.export(MapillaryData.getInstance().getMultiSelectedImages());
            }
        }
        dlg.dispose();
    }

    public void export(List<MapillaryImage> images) {
        Main.worker.submit(new Thread((Runnable)((Object)new MapillaryExportManager(images, this.dialog.chooser.getSelectedFile().toString()))));
    }
}

