/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.plugins.mapillary.MapillarySequence;

public class MapillaryImage {
    private String key;
    private LatLon latLon;
    private Double ca;
    private boolean isModified = false;
    private MapillarySequence sequence;

    public MapillaryImage(String key, double lat, double lon, double ca) {
        this.key = key;
        this.latLon = new LatLon(lat, lon);
        this.ca = ca;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public LatLon getLatLon() {
        return this.latLon;
    }

    public Double getCa() {
        return this.ca;
    }

    public String getKey() {
        return this.key;
    }

    public void setSequence(MapillarySequence sequence) {
        this.sequence = sequence;
    }

    public MapillarySequence getSequence() {
        return this.sequence;
    }

    public String toString() {
        return "Image[key=" + this.key + ";lat=" + this.latLon.lat() + ";lon=" + this.latLon.lon() + ";ca=" + this.ca + "]";
    }

    public Boolean equals(MapillaryImage image) {
        return this.key.equals(image.getKey());
    }

    public MapillaryImage next() {
        if (this.getSequence() == null) {
            return null;
        }
        return this.getSequence().next(this);
    }

    public MapillaryImage previous() {
        if (this.getSequence() == null) {
            return null;
        }
        return this.getSequence().previous(this);
    }
}

