/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.mapillary;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.plugins.mapillary.MapillaryData;
import org.openstreetmap.josm.tools.I18n;

public class MapillaryExportDialog
extends JPanel
implements ActionListener {
    protected JOptionPane optionPane;
    protected JRadioButton all;
    protected JRadioButton sequence;
    protected JRadioButton selected;
    protected ButtonGroup group;
    protected JButton choose;
    protected JLabel path;
    protected JFileChooser chooser;
    protected String exportDirectory;

    public MapillaryExportDialog() {
        this.setLayout(new BoxLayout(this, 3));
        this.group = new ButtonGroup();
        this.all = new JRadioButton(I18n.tr((String)"Export all images", (Object[])new Object[0]));
        this.sequence = new JRadioButton(I18n.tr((String)"Export selected sequence", (Object[])new Object[0]));
        this.selected = new JRadioButton(I18n.tr((String)"Export selected images", (Object[])new Object[0]));
        this.group.add(this.all);
        this.group.add(this.sequence);
        this.group.add(this.selected);
        if (MapillaryData.getInstance().getSelectedImage() == null || MapillaryData.getInstance().getSelectedImage().getSequence() == null) {
            this.sequence.setEnabled(false);
        }
        if (MapillaryData.getInstance().getMultiSelectedImages().isEmpty()) {
            this.selected.setEnabled(false);
        }
        this.path = new JLabel("Select a folder");
        this.choose = new JButton(I18n.tr((String)"Explore", (Object[])new Object[0]));
        this.choose.addActionListener(this);
        JPanel jpanel = new JPanel();
        jpanel.setLayout(new BoxLayout(jpanel, 3));
        jpanel.add(this.all);
        jpanel.add(this.sequence);
        jpanel.add(this.selected);
        jpanel.setAlignmentX(0.5f);
        this.path.setAlignmentX(0.5f);
        this.choose.setAlignmentX(0.5f);
        this.add(jpanel);
        this.add(this.path);
        this.add(this.choose);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.chooser = new JFileChooser();
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.chooser.setDialogTitle("Select a directory");
        this.chooser.setFileSelectionMode(1);
        this.chooser.setAcceptAllFileFilterUsed(false);
        if (this.chooser.showOpenDialog(this) == 0) {
            this.path.setText(this.chooser.getSelectedFile().toString());
            this.updateUI();
        }
    }
}

