/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.kartverket.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.kartverket.CheckDirectionDialog;
import org.openstreetmap.josm.plugins.kartverket.CheckNextWayI;
import org.openstreetmap.josm.tools.I18n;

public class CheckDirectionAction
extends JosmAction
implements CheckNextWayI {
    private int nWaysCompleted;
    private int nWaysFixme;
    Collection<Way> ways;
    Iterator<Way> waysIterator;
    Way w;

    public CheckDirectionAction() {
        super(I18n.tr((String)"Check direction of streams", (Object[])new Object[0]), null, I18n.tr((String)"Check direction of streams and rivers", (Object[])new Object[0]), null, true);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.ways = CheckDirectionAction.getCurrentDataSet().getWays();
        this.nWaysFixme = 0;
        this.nWaysCompleted = 0;
        for (Way w : this.ways) {
            if (!w.hasTag("FIXME", "Check direction of river/stream")) continue;
            ++this.nWaysFixme;
        }
        this.waysIterator = this.ways.iterator();
        this.nextWay();
    }

    private void nextWay() {
        boolean isDone = true;
        while (this.waysIterator.hasNext()) {
            this.w = this.waysIterator.next();
            if (!this.w.hasTag("FIXME", "Check direction of river/stream")) continue;
            CheckDirectionAction.getCurrentDataSet().clearSelection();
            CheckDirectionAction.getCurrentDataSet().addSelected(new PrimitiveId[]{this.w.getPrimitiveId()});
            BoundingXYVisitor boundingVisitor = new BoundingXYVisitor();
            boundingVisitor.visit(this.w);
            boundingVisitor.enlargeToMinSize(2000.0);
            Main.map.mapView.zoomTo(boundingVisitor);
            CheckDirectionDialog dialog = new CheckDirectionDialog(this, (double)this.nWaysCompleted / (1.0 * (double)this.nWaysFixme));
            dialog.makeVisible();
            isDone = false;
            break;
        }
        if (isDone) {
            Notification note = new Notification(I18n.tr((String)"No more directions to check!", (Object[])new Object[0]));
            note.show();
        }
    }

    @Override
    public void wayDirectionIsCorrect() {
        this.w.remove("FIXME");
        ++this.nWaysCompleted;
        this.nextWay();
    }

    @Override
    public void wayDirectionIsWrong() {
        List nd = this.w.getNodes();
        Collections.reverse(nd);
        this.w.setNodes(nd);
        this.wayDirectionIsCorrect();
    }

    @Override
    public void wayDirectionIgnore() {
        ++this.nWaysCompleted;
        this.nextWay();
    }

    protected void updateEnabledState() {
        if (CheckDirectionAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }
}

