/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.osmrec.personalization;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.opengis.referencing.FactoryException;
import org.openstreetmap.josm.plugins.container.OSMWay;
import org.openstreetmap.josm.plugins.core.TrainWorker;
import org.openstreetmap.josm.plugins.extractor.LanguageDetector;
import org.openstreetmap.josm.plugins.osmrec.personalization.HistoryParser;
import org.openstreetmap.josm.plugins.osmrec.personalization.TrainByUser;
import org.openstreetmap.josm.plugins.parsers.OSMParser;

public class UserDataExtractAndTrainWorker
extends SwingWorker<Void, Void> {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final ArrayList<String> timeIntervals = new ArrayList();
    private final String username;
    private final Integer days;
    private List<OSMWay> wayList;
    private final boolean byArea;
    private final String inputFilePath;
    private final boolean validateFlag;
    private final double cParameterFromUser;
    private final int topK;
    private final int frequency;
    private final boolean topKIsSelected;
    private final LanguageDetector languageDetector;

    public UserDataExtractAndTrainWorker(String inputFilePath, String username, Integer days, boolean byArea, boolean validateFlag, double cParameterFromUser, int topK, int frequency, boolean topKIsSelected, LanguageDetector languageDetector) {
        this.inputFilePath = inputFilePath;
        this.username = username;
        this.days = days;
        this.byArea = byArea;
        this.validateFlag = validateFlag;
        this.cParameterFromUser = cParameterFromUser;
        this.topK = topK;
        this.frequency = frequency;
        this.topKIsSelected = topKIsSelected;
        this.languageDetector = languageDetector;
    }

    @Override
    protected Void doInBackground() throws Exception {
        if (this.byArea) {
            this.extractByArea();
        } else {
            this.extractHistory();
        }
        TrainByUser trainByUser = new TrainByUser(this.inputFilePath, this.username, this.validateFlag, this.cParameterFromUser, this.topK, this.frequency, this.topKIsSelected, this.languageDetector, this.wayList);
        trainByUser.executeTraining();
        return null;
    }

    private void extractHistory() {
        this.wayList.clear();
        this.produceTimeIntervals(this.days);
        HistoryParser historyParser = new HistoryParser(this.username);
        for (String time : timeIntervals) {
            System.out.println("interval\n " + time);
            historyParser.historyParse(time);
        }
        this.wayList = historyParser.getWayList();
    }

    private void extractByArea() {
        this.wayList.clear();
        OSMParser osmParser = null;
        try {
            osmParser = new OSMParser(this.inputFilePath);
        }
        catch (FactoryException ex) {
            Logger.getLogger(TrainWorker.class.getName()).log(Level.SEVERE, null, ex);
        }
        List<OSMWay> completeWayList = osmParser.getWayList();
        for (OSMWay way : completeWayList) {
            if (!way.getUser().equals(this.username)) continue;
            this.wayList.add(way);
        }
    }

    private void produceTimeIntervals(Integer days) {
        String startingTimeString;
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date currentDate = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentDate);
        String currentTimeString = sdf.format(currentDate);
        cal.add(5, -days.intValue());
        Date startingTime = cal.getTime();
        String nextIntervalTime = startingTimeString = sdf.format(startingTime);
        do {
            cal.add(5, 10);
            Date intervalTime = cal.getTime();
            String intervalTimeString = sdf.format(intervalTime);
            String timeOsmApiArgument = nextIntervalTime + "," + intervalTimeString;
            if (cal.getTime().after(currentDate)) {
                timeOsmApiArgument = nextIntervalTime + "," + currentTimeString;
                timeIntervals.add(timeOsmApiArgument);
                System.out.println(timeOsmApiArgument);
                break;
            }
            timeIntervals.add(timeOsmApiArgument);
            nextIntervalTime = intervalTimeString;
            System.out.println(" ti: " + timeOsmApiArgument);
        } while (cal.getTime().before(currentDate));
    }
}

