/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ExponentialTransform1D;
import org.geotools.referencing.operation.transform.LinearTransform1D;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;

public class LogarithmicTransform1D
extends AbstractMathTransform
implements MathTransform1D,
Serializable {
    private static final long serialVersionUID = 1535101265352133948L;
    private static final double EPS = 1.0E-8;
    public final double base;
    final double lnBase;
    public final double offset;
    private MathTransform1D inverse;

    private LogarithmicTransform1D(ExponentialTransform1D inverse) {
        this.base = inverse.base;
        this.lnBase = inverse.lnBase;
        this.offset = -Math.log(inverse.scale) / this.lnBase;
        this.inverse = inverse;
    }

    protected LogarithmicTransform1D(double base, double offset) {
        this.base = base;
        this.offset = offset;
        this.lnBase = Math.log(base);
    }

    static LogarithmicTransform1D create(ExponentialTransform1D inverse) {
        if (Math.abs(inverse.base - 10.0) < 1.0E-8) {
            return new Base10(inverse);
        }
        return new LogarithmicTransform1D(inverse);
    }

    public static MathTransform1D create(double base, double offset) {
        if (base == Double.POSITIVE_INFINITY || Math.abs(base) <= 1.0E-8) {
            return LinearTransform1D.create(0.0, offset);
        }
        if (Math.abs(base - 10.0) < 1.0E-8) {
            return new Base10(offset);
        }
        return new LogarithmicTransform1D(base, offset);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return new ParameterGroup(this.getParameterDescriptors(), (GeneralParameterValue[])new ParameterValue[]{new FloatParameter(Provider.BASE, this.base), new FloatParameter(Provider.OFFSET, this.offset)});
    }

    @Override
    public int getSourceDimensions() {
        return 1;
    }

    @Override
    public int getTargetDimensions() {
        return 1;
    }

    @Override
    public MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = new ExponentialTransform1D(this);
        }
        return this.inverse;
    }

    @Override
    public double derivative(double value) {
        return 1.0 / (this.lnBase * value);
    }

    @Override
    public double transform(double value) {
        return Math.log(value) / this.lnBase + this.offset;
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(Math.log(srcPts[srcOff++]) / this.lnBase + this.offset);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(Math.log(srcPts[srcOff++]) / this.lnBase + this.offset);
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = Math.log(srcPts[srcOff++]) / this.lnBase + this.offset;
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = Math.log(srcPts[srcOff++]) / this.lnBase + this.offset;
            }
        }
    }

    @Override
    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        if (other instanceof LinearTransform) {
            LinearTransform1D linear = (LinearTransform1D)other;
            if (applyOtherFirst) {
                if (linear.offset == 0.0 && linear.scale > 0.0) {
                    return LogarithmicTransform1D.create(this.base, Math.log(linear.scale) / this.lnBase + this.offset);
                }
            } else {
                double newBase = Math.pow(this.base, 1.0 / linear.scale);
                if (!Double.isNaN(newBase)) {
                    return LogarithmicTransform1D.create(newBase, linear.scale * this.offset + linear.offset);
                }
            }
        } else if (other instanceof ExponentialTransform1D) {
            return ((ExponentialTransform1D)other).concatenateLog(this, !applyOtherFirst);
        }
        return super.concatenate(other, applyOtherFirst);
    }

    @Override
    public int hashCode() {
        long code = 1535101265352133948L + Double.doubleToLongBits(this.base);
        code = code * 37L + Double.doubleToLongBits(this.offset);
        return (int)(code >>> 32) ^ (int)code;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            LogarithmicTransform1D that = (LogarithmicTransform1D)object;
            return Double.doubleToLongBits(this.base) == Double.doubleToLongBits(that.base) && Double.doubleToLongBits(this.offset) == Double.doubleToLongBits(that.offset);
        }
        return false;
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -7235097164208708484L;
        public static final ParameterDescriptor<Double> BASE = DefaultParameterDescriptor.create("base", 10.0, 0.0, Double.POSITIVE_INFINITY, Unit.ONE);
        public static final ParameterDescriptor<Double> OFFSET = DefaultParameterDescriptor.create("offset", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Unit.ONE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(130))}, new ParameterDescriptor[]{BASE, OFFSET});

        public Provider() {
            super(1, 1, PARAMETERS);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform1D createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException {
            return LogarithmicTransform1D.create(Provider.doubleValue(BASE, values), Provider.doubleValue(OFFSET, values));
        }
    }

    private static final class Base10
    extends LogarithmicTransform1D {
        private static final long serialVersionUID = -5435804027536647558L;

        Base10(ExponentialTransform1D inverse) {
            super(inverse);
        }

        protected Base10(double offset) {
            super(10.0, offset);
        }

        @Override
        public double transform(double value) {
            return Math.log10(value) + this.offset;
        }

        @Override
        public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
            if (srcPts != dstPts || srcOff >= dstOff) {
                while (--numPts >= 0) {
                    dstPts[dstOff++] = (float)(Math.log10(srcPts[srcOff++]) + this.offset);
                }
            } else {
                srcOff += numPts;
                dstOff += numPts;
                while (--numPts >= 0) {
                    dstPts[--dstOff] = (float)(Math.log10(srcPts[srcOff++]) + this.offset);
                }
            }
        }

        @Override
        public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
            if (srcPts != dstPts || srcOff >= dstOff) {
                while (--numPts >= 0) {
                    dstPts[dstOff++] = Math.log10(srcPts[srcOff++]) + this.offset;
                }
            } else {
                srcOff += numPts;
                dstOff += numPts;
                while (--numPts >= 0) {
                    dstPts[--dstOff] = Math.log10(srcPts[srcOff++]) + this.offset;
                }
            }
        }
    }
}

