/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

public class AbstractReferenceSystem
extends AbstractIdentifiedObject
implements ReferenceSystem {
    private static final long serialVersionUID = 3337659819553899435L;
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    private final Extent domainOfValidity;
    private final InternationalString scope;

    public AbstractReferenceSystem(ReferenceSystem object) {
        super(object);
        this.domainOfValidity = object.getDomainOfValidity();
        this.scope = object.getScope();
    }

    public AbstractReferenceSystem(Map<String, ?> properties) {
        this(properties, new HashMap<String, Object>());
    }

    private AbstractReferenceSystem(Map<String, ?> properties, Map<String, Object> subProperties) {
        super(properties, subProperties, LOCALIZABLES);
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    public Extent getValidArea() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (!compareMetadata) {
                return true;
            }
            AbstractReferenceSystem that = (AbstractReferenceSystem)object;
            return Utilities.equals(this.domainOfValidity, that.domainOfValidity) && Utilities.equals(this.scope, that.scope);
        }
        return false;
    }
}

