/*
 * Decompiled with CFR 0.152.
 */
package buildings_tools;

import java.awt.event.ActionEvent;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeAddrPointsAction
extends JosmAction {
    public MergeAddrPointsAction() {
        super(I18n.tr((String)"Merge address points", (Object[])new Object[0]), "mergeaddr", I18n.tr((String)"Move tags from address nodes inside buildings to building ways", (Object[])new Object[0]), Shortcut.registerShortcut((String)"edit:mergeaddrpoints", (String)I18n.tr((String)"Edit: {0}", (Object[])new Object[]{I18n.tr((String)"Merge address points", (Object[])new Object[0])}), (int)65535, (int)5000), true);
    }

    public void actionPerformed(ActionEvent arg0) {
        if (!this.isEnabled()) {
            return;
        }
        Collection selection = MergeAddrPointsAction.getCurrentDataSet().getSelected();
        if (selection.isEmpty()) {
            new Notification(I18n.tr((String)"Select both address nodes and building ways to merge", (Object[])new Object[0])).setIcon(1).show();
            return;
        }
        LinkedList<Node> addrNodes = new LinkedList<Node>();
        LinkedList<Way> buildings = new LinkedList<Way>();
        block0: for (OsmPrimitive p : selection) {
            if (p.getType() == OsmPrimitiveType.NODE) {
                for (OsmPrimitive r : p.getReferrers()) {
                    if (r.getType() != OsmPrimitiveType.WAY) continue;
                    continue block0;
                }
                for (String key : p.getKeys().keySet()) {
                    if (!key.startsWith("addr:")) continue;
                    addrNodes.add((Node)p);
                    continue block0;
                }
                continue;
            }
            if (p.getType() != OsmPrimitiveType.WAY || !p.getKeys().containsKey("building")) continue;
            buildings.add((Way)p);
        }
        if (addrNodes.isEmpty()) {
            new Notification(I18n.tr((String)"No address nodes found in the selection", (Object[])new Object[0])).setIcon(0).show();
            return;
        }
        if (buildings.isEmpty()) {
            new Notification(I18n.tr((String)"No building ways found in the selection", (Object[])new Object[0])).setIcon(0).show();
            return;
        }
        LinkedList<Object> cmds = new LinkedList<Object>();
        int multi = 0;
        int conflicts = 0;
        block3: for (Way w : buildings) {
            Node mergeNode = null;
            for (Node n : addrNodes) {
                if (!Geometry.nodeInsidePolygon((Node)n, (List)w.getNodes())) continue;
                if (mergeNode != null) {
                    ++multi;
                    continue block3;
                }
                mergeNode = n;
            }
            if (mergeNode == null) continue;
            boolean hasConflicts = false;
            HashMap tags = new HashMap();
            for (Map.Entry entry : mergeNode.getKeys().entrySet()) {
                String oldValue;
                String newValue = (String)entry.getValue();
                if (newValue == null || newValue.equals(oldValue = (String)w.getKeys().get(entry.getKey()))) continue;
                if (oldValue == null) {
                    ((AbstractMap)tags).put(entry.getKey(), newValue);
                    continue;
                }
                hasConflicts = true;
            }
            if (hasConflicts) {
                ++conflicts;
            }
            if (!((AbstractMap)tags).isEmpty()) {
                cmds.add(new ChangePropertyCommand(Collections.singleton(w), tags));
            }
            if (hasConflicts) continue;
            for (OsmPrimitive p : mergeNode.getReferrers()) {
                Relation r = (Relation)p;
                Relation rnew = new Relation(r);
                for (int i = 0; i < r.getMembersCount(); ++i) {
                    RelationMember member = r.getMember(i);
                    if (member.getMember() != mergeNode) continue;
                    rnew.removeMember(i);
                    rnew.addMember(i, new RelationMember(member.getRole(), (OsmPrimitive)w));
                }
                cmds.add(new ChangeCommand((OsmPrimitive)r, (OsmPrimitive)rnew));
            }
            cmds.add(new DeleteCommand((OsmPrimitive)mergeNode));
        }
        if (multi != 0) {
            new Notification(I18n.tr((String)"There are {0} buildings with multiple address nodes inside", (Object[])new Object[]{multi})).setIcon(2).show();
        }
        if (conflicts != 0) {
            new Notification(I18n.tr((String)"There are {0} buildings with address conflicts", (Object[])new Object[]{conflicts})).setIcon(2).show();
        }
        if (cmds.isEmpty() && multi == 0 && conflicts == 0) {
            new Notification(I18n.tr((String)"No address nodes inside buildings found", (Object[])new Object[0])).setIcon(1).show();
        }
        if (!cmds.isEmpty()) {
            Main.main.undoRedo.add((Command)new SequenceCommand("Merge addresses", cmds));
        }
    }

    protected void updateEnabledState() {
        this.setEnabled(MergeAddrPointsAction.getCurrentDataSet() != null);
    }
}

