/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import org.geotools.image.palette.ColorIndexer;

public class ColorIndexerOpImage
extends PointOpImage {
    private ColorIndexer palette;
    private IndexColorModel icm;

    public ColorIndexerOpImage(RenderedImage image, ColorIndexer palette, RenderingHints hints) {
        super(image, ColorIndexerOpImage.buildLayout(image, palette.toIndexColorModel()), (Map)hints, false);
        this.icm = palette.toIndexColorModel();
        this.setSource(image, 0);
        this.palette = palette;
    }

    static ImageLayout buildLayout(RenderedImage image, IndexColorModel icm) {
        ImageLayout il = new ImageLayout();
        il.setMinX(image.getMinX());
        il.setMinY(image.getMinY());
        il.setWidth(image.getWidth());
        il.setHeight(image.getHeight());
        il.setColorModel(icm);
        SampleModel sm = icm.createCompatibleSampleModel(image.getWidth(), image.getHeight());
        il.setSampleModel(sm);
        if (!(image instanceof BufferedImage)) {
            il.setTileWidth(image.getTileWidth());
            il.setTileHeight(image.getTileHeight());
            il.setTileGridXOffset(image.getTileGridXOffset());
            il.setTileGridYOffset(image.getTileGridYOffset());
        } else {
            il.setTileWidth(image.getWidth());
            il.setTileHeight(image.getHeight());
            il.setTileGridXOffset(0);
            il.setTileGridYOffset(0);
        }
        return il;
    }

    @Override
    public Raster computeTile(int tx, int ty) {
        PlanarImage sourceImage = this.getSourceImage(0);
        Raster src = sourceImage.getTile(tx, ty);
        if (src == null) {
            return null;
        }
        WritableRaster dest = this.icm.createCompatibleWritableRaster(src.getWidth(), src.getHeight()).createWritableTranslatedChild(src.getMinX(), src.getMinY());
        int w = dest.getWidth();
        int h = dest.getHeight();
        int srcMinX = Math.max(sourceImage.getMinX(), src.getMinX());
        int srcMinY = Math.max(sourceImage.getMinY(), src.getMinY());
        int srcMaxX = Math.min(sourceImage.getMinX() + sourceImage.getWidth(), src.getMinX() + w);
        int srcMaxY = Math.min(sourceImage.getMinY() + sourceImage.getHeight(), src.getMinY() + h);
        int dstMinX = Math.max(src.getMinX(), sourceImage.getMinX());
        int dstMinY = Math.max(src.getMinY(), sourceImage.getMinY());
        int srcBands = src.getNumBands();
        int[] pixel = new int[srcBands];
        byte[] bytes = new byte[srcBands];
        int y = srcMinY;
        int y_ = dstMinY;
        while (y < srcMaxY) {
            int x = srcMinX;
            int x_ = dstMinX;
            while (x < srcMaxX) {
                int a;
                int r;
                int g;
                int b;
                src.getPixel(x, y, pixel);
                for (int i = 0; i < srcBands; ++i) {
                    bytes[i] = (byte)(pixel[i] & 0xFF);
                }
                if (srcBands == 1 || srcBands == 2) {
                    g = b = pixel[0] & 0xFF;
                    r = b;
                    a = srcBands == 2 ? pixel[1] & 0xFF : 255;
                } else {
                    r = pixel[0] & 0xFF;
                    g = pixel[1] & 0xFF;
                    b = pixel[2] & 0xFF;
                    a = srcBands == 4 ? pixel[3] & 0xFF : 255;
                }
                int idx = this.palette.getClosestIndex(r, g, b, a);
                dest.setSample(x_, y_, 0, (byte)(idx & 0xFF));
                ++x;
                ++x_;
            }
            ++y;
            ++y_;
        }
        return dest;
    }
}

