/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MemoryFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    ContentState state;
    SimpleFeatureType featureType;
    Map<String, SimpleFeature> contents;
    Iterator<SimpleFeature> iterator;
    SimpleFeature live = null;
    SimpleFeature current = null;

    public MemoryFeatureWriter(ContentState state, Query query) throws IOException {
        this.state = state;
        this.featureType = state.getFeatureType();
        String typeName = this.featureType.getTypeName();
        MemoryDataStore store = (MemoryDataStore)state.getEntry().getDataStore();
        this.contents = store.features(typeName);
        this.iterator = this.contents.values().iterator();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    @Override
    public SimpleFeature next() throws IOException, NoSuchElementException {
        if (this.hasNext()) {
            this.live = this.iterator.next();
            try {
                this.current = SimpleFeatureBuilder.copy(this.live);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + this.featureType.getTypeName());
            }
        }
        this.live = null;
        try {
            this.current = SimpleFeatureBuilder.template(this.featureType, null);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Unable to add additional Features of " + this.featureType.getTypeName());
        }
        return this.current;
    }

    @Override
    public void remove() throws IOException {
        if (this.contents == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to remove");
        }
        if (this.live != null) {
            this.iterator.remove();
            this.live = null;
            this.current = null;
        } else {
            this.current = null;
        }
    }

    @Override
    public void write() throws IOException {
        if (this.contents == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        if (this.current == null) {
            throw new IOException("No feature available to write");
        }
        if (this.live != null) {
            if (this.live.equals(this.current)) {
                this.live = null;
                this.current = null;
            } else {
                try {
                    this.live.setAttributes(this.current.getAttributes());
                }
                catch (Exception e) {
                    throw new DataSourceException("Unable to accept modifications to " + this.live.getID() + " on " + this.featureType.getTypeName());
                }
                ReferencedEnvelope bounds = new ReferencedEnvelope();
                bounds.expandToInclude(new ReferencedEnvelope(this.live.getBounds()));
                bounds.expandToInclude(new ReferencedEnvelope(this.current.getBounds()));
                this.live = null;
                this.current = null;
            }
        } else {
            this.contents.put(this.current.getID(), this.current);
            this.current = null;
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.contents == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator = null;
        }
        if (this.featureType != null) {
            this.featureType = null;
        }
        this.contents = null;
        this.current = null;
        this.live = null;
    }
}

