/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.geotools.factory.Hints;
import org.geotools.image.jai.Registry;
import org.geotools.image.palette.ColorIndexer;
import org.geotools.image.palette.ColorIndexerCRIF;
import org.geotools.util.logging.Logging;

public class ColorIndexerDescriptor
extends OperationDescriptorImpl {
    static final Logger LOGGER = Logging.getLogger(ColorIndexerCRIF.class);
    private static final long serialVersionUID = 4951347100540806326L;
    public static final String OPERATION_NAME = "org.geotools.ColorIndexer";

    public static void register() {
        block3: {
            try {
                OperationRegistry opr = JAI.getDefaultInstance().getOperationRegistry();
                if (opr.getDescriptor("rendered", OPERATION_NAME) == null) {
                    Registry.registerRIF(JAI.getDefaultInstance(), (OperationDescriptor)new ColorIndexerDescriptor(), (RenderedImageFactory)((Object)new ColorIndexerCRIF()), "org.geotools");
                }
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block3;
                LOGGER.log(Level.FINE, e.getLocalizedMessage());
            }
        }
    }

    public ColorIndexerDescriptor() {
        super((String[][])new String[][]{{"GlobalName", OPERATION_NAME}, {"LocalName", OPERATION_NAME}, {"Vendor", "org.geotools"}, {"Description", "Produce a paletted image from an RGB or RGBA image using a provided palette."}, {"DocURL", "http://www.geo-solutions.it/"}, {"Version", "1.0"}, {"arg0Desc", "Indexer."}}, new String[]{"rendered"}, 1, new String[]{"Indexer"}, new Class[]{ColorIndexer.class}, new Object[]{null}, null);
    }

    protected boolean validateSources(String modeName, ParameterBlock param, StringBuffer message) {
        if (super.validateSources(modeName, param, message)) {
            int i = param.getNumSources();
            while (--i >= 0) {
                Object source = param.getSource(i);
                if (source instanceof RenderedImage) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
        if (!super.validateParameters(modeName, param, message)) {
            return false;
        }
        return param.getObjectParameter(0) instanceof ColorIndexer;
    }

    public static RenderedOp create(RenderedImage source, ColorIndexer indexer, Hints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI(OPERATION_NAME, "rendered");
        pb.setSource("source0", (Object)source);
        pb.setParameter("Indexer", (Object)indexer);
        return JAI.create((String)OPERATION_NAME, (ParameterBlock)pb, (RenderingHints)hints);
    }
}

