/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryCommand;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryException;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.ReplaceGeometryUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class ReplaceGeometryAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Replace Geometry", (Object[])new Object[0]);

    public ReplaceGeometryAction() {
        super(TITLE, "dumbutils/replacegeometry", I18n.tr((String)"Replace geometry of selected object with a new one", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:replacegeometry", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Replace Geometry", (Object[])new Object[0])}), (int)71, (int)5009), true);
    }

    public void actionPerformed(ActionEvent e) {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            return;
        }
        ArrayList selection = new ArrayList(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        if (selection.size() != 2) {
            new Notification(I18n.tr((String)"This tool replaces geometry of one object with another, and so requires exactly two objects to be selected.", (Object[])new Object[0])).setIcon(2).show();
            return;
        }
        OsmPrimitive firstObject = (OsmPrimitive)selection.get(0);
        OsmPrimitive secondObject = (OsmPrimitive)selection.get(1);
        try {
            ReplaceGeometryCommand replaceCommand = ReplaceGeometryUtils.buildReplaceWithNewCommand(firstObject, secondObject);
            if (replaceCommand == null) {
                return;
            }
            Main.main.undoRedo.add((Command)replaceCommand);
        }
        catch (IllegalArgumentException ex) {
            new Notification(ex.getMessage()).setIcon(2).show();
        }
        catch (ReplaceGeometryException ex) {
            new Notification(ex.getMessage()).setIcon(2).show();
        }
    }

    protected void updateEnabledState() {
        if (ReplaceGeometryAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(ReplaceGeometryAction.getCurrentDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && selection.size() >= 2);
    }
}

