/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.modules;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleDownloadException;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ModuleDownloadTask
extends PleaseWaitRunnable {
    private final Collection<ModuleInformation> toUpdate = new LinkedList<ModuleInformation>();
    private final Collection<ModuleInformation> failed = new LinkedList<ModuleInformation>();
    private final Collection<ModuleInformation> downloaded = new LinkedList<ModuleInformation>();
    private boolean canceled;
    private HttpURLConnection downloadConnection;

    public ModuleDownloadTask(Component parent, Collection<ModuleInformation> toUpdate, String title) throws IllegalArgumentException {
        super(parent, title == null ? "" : title, false);
        CheckParameterUtil.ensureParameterNotNull(toUpdate, (String)"toUpdate");
        this.toUpdate.addAll(toUpdate);
    }

    public ModuleDownloadTask(ProgressMonitor monitor, Collection<ModuleInformation> toUpdate, String title) {
        super(title, monitor == null ? NullProgressMonitor.INSTANCE : monitor, false);
        CheckParameterUtil.ensureParameterNotNull(toUpdate, (String)"toUpdate");
        this.toUpdate.addAll(toUpdate);
    }

    public void setModulesToDownload(Collection<ModuleInformation> toUpdate) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(toUpdate, (String)"toUpdate");
        this.toUpdate.clear();
        this.toUpdate.addAll(toUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancel() {
        this.canceled = true;
        ModuleDownloadTask moduleDownloadTask = this;
        synchronized (moduleDownloadTask) {
            if (this.downloadConnection != null) {
                this.downloadConnection.disconnect();
            }
        }
    }

    protected void finish() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void download(ModuleInformation pi, File file) throws ModuleDownloadException {
        try {
            if (pi.downloadlink == null) {
                String msg = I18n.tr((String)"Warning: Cannot download module ''{0}''. Its download link is not known. Skipping download.", (Object[])new Object[]{pi.name});
                Main.warn((String)msg);
                throw new ModuleDownloadException(msg);
            }
            Object url = new URL(pi.downloadlink);
            ModuleDownloadTask moduleDownloadTask = this;
            synchronized (moduleDownloadTask) {
                this.downloadConnection = (HttpURLConnection)url.openConnection();
                this.downloadConnection.setRequestProperty("Cache-Control", "no-cache");
                this.downloadConnection.setRequestProperty("User-Agent", Version.getInstance().getAgentString());
                this.downloadConnection.setRequestProperty("Host", url.getHost());
                this.downloadConnection.connect();
            }
            try (InputStream in = this.downloadConnection.getInputStream();
                 FileOutputStream out = new FileOutputStream(file);){
                byte[] buffer = new byte[8192];
                int read = in.read(buffer);
                while (read != -1) {
                    ((OutputStream)out).write(buffer, 0, read);
                    read = in.read(buffer);
                }
            }
        }
        catch (MalformedURLException e) {
            String msg = I18n.tr((String)"Warning: Cannot download module ''{0}''. Its download link ''{1}'' is not a valid URL. Skipping download.", (Object[])new Object[]{pi.name, pi.downloadlink});
            Main.warn((String)msg);
            throw new ModuleDownloadException(msg);
        }
        catch (IOException e) {
            if (this.canceled) {
                return;
            }
            throw new ModuleDownloadException(e);
        }
        finally {
            ModuleDownloadTask moduleDownloadTask = this;
            synchronized (moduleDownloadTask) {
                this.downloadConnection = null;
            }
        }
    }

    protected void realRun() throws SAXException, IOException {
        File moduleDir = OdPlugin.getInstance().getModulesDirectory();
        if (!moduleDir.exists() && !moduleDir.mkdirs()) {
            this.failed.addAll(this.toUpdate);
            return;
        }
        this.getProgressMonitor().setTicksCount(this.toUpdate.size());
        for (ModuleInformation d : this.toUpdate) {
            if (this.canceled) {
                return;
            }
            this.progressMonitor.subTask(I18n.tr((String)"Downloading Module {0}...", (Object[])new Object[]{d.name}));
            this.progressMonitor.worked(1);
            File moduleFile = new File(moduleDir, d.name + ".jar.new");
            try {
                this.download(d, moduleFile);
            }
            catch (ModuleDownloadException e) {
                e.printStackTrace();
                this.failed.add(d);
                continue;
            }
            this.downloaded.add(d);
        }
        ModuleHandler.installDownloadedModules(false);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public Collection<ModuleInformation> getFailedModules() {
        return this.failed;
    }

    public Collection<ModuleInformation> getDownloadedModules() {
        return this.downloaded;
    }
}

