/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

public class DateUtil {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long DAY_MILLISECONDS = 86400000L;
    private static final Pattern date_ptrn1 = Pattern.compile("^\\[\\$\\-.*?\\]");
    private static final Pattern date_ptrn2 = Pattern.compile("^\\[[a-zA-Z]+\\]");
    private static final Pattern date_ptrn3 = Pattern.compile("^[yYmMdDhHsS\\-/,. :\"\\\\]+0?[ampAMP/]*$");

    protected DateUtil() {
    }

    public static Date getJavaDate(double d, boolean bl) {
        if (!DateUtil.isValidExcelDate(d)) {
            return null;
        }
        int n = (int)Math.floor(d);
        int n2 = (int)((d - (double)n) * 8.64E7 + 0.5);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DateUtil.setCalendar(gregorianCalendar, n, n2, bl);
        return gregorianCalendar.getTime();
    }

    public static void setCalendar(Calendar calendar, int n, int n2, boolean bl) {
        int n3 = 1900;
        int n4 = -1;
        if (bl) {
            n3 = 1904;
            n4 = 1;
        } else if (n < 61) {
            n4 = 0;
        }
        calendar.set(n3, 0, n + n4, 0, 0, 0);
        calendar.set(14, n2);
    }

    public static boolean isADateFormat(int n, String string) {
        if (DateUtil.isInternalDateFormat(n)) {
            return true;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = string;
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        block3: for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (i < string2.length() - 1) {
                char c2 = string2.charAt(i + 1);
                if (c == '\\') {
                    switch (c2) {
                        case ' ': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '\\': {
                            continue block3;
                        }
                    }
                } else if (c == ';' && c2 == '@') {
                    ++i;
                    continue;
                }
            }
            stringBuilder.append(c);
        }
        string2 = stringBuilder.toString();
        string2 = date_ptrn1.matcher(string2).replaceAll("");
        if ((string2 = date_ptrn2.matcher(string2).replaceAll("")).indexOf(59) > 0 && string2.indexOf(59) < string2.length() - 1) {
            string2 = string2.substring(0, string2.indexOf(59));
        }
        return date_ptrn3.matcher(string2).matches();
    }

    public static boolean isInternalDateFormat(int n) {
        switch (n) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 45: 
            case 46: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    public static boolean isCellDateFormatted(Cell cell) {
        if (cell == null) {
            return false;
        }
        boolean bl = false;
        double d = cell.getNumericCellValue();
        if (DateUtil.isValidExcelDate(d)) {
            CellStyle cellStyle = cell.getCellStyle();
            if (cellStyle == null) {
                return false;
            }
            short s = cellStyle.getDataFormat();
            String string = cellStyle.getDataFormatString();
            bl = DateUtil.isADateFormat(s, string);
        }
        return bl;
    }

    public static boolean isValidExcelDate(double d) {
        return d > -4.9E-324;
    }
}

