/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.Symbol;
import org.geotools.util.Utilities;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.ColorReplacement;
import org.opengis.style.GraphicalSymbol;
import org.opengis.util.Cloneable;

public class ExternalGraphicImpl
implements ExternalGraphic,
Symbol,
Cloneable {
    private Icon inlineContent;
    private OnLineResource online;
    private URL location = null;
    private String format = null;
    private String uri = null;
    private Map<String, Object> customProps = null;
    private final Set<ColorReplacement> colorReplacements;

    public ExternalGraphicImpl() {
        this(null, null, null);
    }

    public ExternalGraphicImpl(Icon icon, Collection<ColorReplacement> replaces, OnLineResource source) {
        this.inlineContent = icon;
        this.colorReplacements = replaces == null ? new TreeSet<ColorReplacement>() : new TreeSet<ColorReplacement>(replaces);
        this.online = source;
    }

    @Override
    @Deprecated
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public URL getLocation() throws MalformedURLException {
        if (this.uri == null) {
            return null;
        }
        if (this.location == null) {
            this.location = new URL(this.uri);
        }
        return this.location;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public void setLocation(URL location) {
        if (location == null) {
            throw new IllegalArgumentException("ExternalGraphic location URL cannot be null");
        }
        this.uri = location.toString();
        this.location = location;
    }

    @Override
    public Object accept(org.opengis.style.StyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.format != null) {
            result = 1000003 * result + this.format.hashCode();
        }
        if (this.uri != null) {
            result = 1000003 * result + this.uri.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof ExternalGraphicImpl) {
            ExternalGraphicImpl other = (ExternalGraphicImpl)oth;
            return Utilities.equals(this.uri, other.uri) && Utilities.equals(this.format, other.format);
        }
        return false;
    }

    @Override
    public Map<String, Object> getCustomProperties() {
        return this.customProps;
    }

    @Override
    public void setCustomProperties(Map<String, Object> list) {
        this.customProps = list;
    }

    @Override
    public OnLineResource getOnlineResource() {
        if (this.online == null) {
            OnLineResourceImpl impl = new OnLineResourceImpl();
            try {
                impl.setLinkage(new URI(this.uri));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            this.online = impl;
        }
        return this.online;
    }

    public void setOnlineResource(OnLineResource online) {
        this.online = online;
    }

    @Override
    public Icon getInlineContent() {
        return this.inlineContent;
    }

    public void setInlineContent(Icon inlineContent) {
        this.inlineContent = inlineContent;
    }

    @Override
    public Collection<ColorReplacement> getColorReplacements() {
        return Collections.unmodifiableCollection(this.colorReplacements);
    }

    public Set<ColorReplacement> colorReplacements() {
        return this.colorReplacements;
    }

    static GraphicalSymbol cast(GraphicalSymbol item) {
        if (item == null) {
            return null;
        }
        if (item instanceof ExternalGraphicImpl) {
            return (ExternalGraphicImpl)item;
        }
        if (item instanceof org.opengis.style.ExternalGraphic) {
            org.opengis.style.ExternalGraphic graphic = (org.opengis.style.ExternalGraphic)item;
            ExternalGraphicImpl copy = new ExternalGraphicImpl();
            copy.colorReplacements().addAll(graphic.getColorReplacements());
            copy.setFormat(graphic.getFormat());
            copy.setInlineContent(graphic.getInlineContent());
            copy.setOnlineResource(graphic.getOnlineResource());
            return copy;
        }
        return null;
    }
}

