/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;

class GrowableOrdinateArray {
    private double[] data;
    private int curr;

    public GrowableOrdinateArray(int size) {
        this.data = new double[size];
    }

    GrowableOrdinateArray() {
    }

    public void add(double d) {
        this.ensureLength(this.curr + 1);
        this.data[this.curr++] = d;
    }

    public void add(double d1, double d2) {
        this.ensureLength(this.curr + 2);
        this.data[this.curr++] = d1;
        this.data[this.curr++] = d2;
    }

    public void addAll(double ... d) {
        this.ensureLength(this.curr + d.length);
        System.arraycopy(d, 0, this.data, this.curr, d.length);
        this.curr += d.length;
    }

    public void addAll(CoordinateSequence cs) {
        int coordinatesCount = cs.size();
        this.ensureLength(this.curr + coordinatesCount * 2);
        for (int i = 0; i < coordinatesCount; ++i) {
            this.data[this.curr + i * 2] = cs.getOrdinate(i, 0);
            this.data[this.curr + i * 2 + 1] = cs.getOrdinate(i, 1);
        }
        this.curr += coordinatesCount * 2;
    }

    public double[] getData() {
        if (this.data == null) {
            return new double[0];
        }
        if (this.data.length == this.curr) {
            return this.data;
        }
        double[] result = new double[this.curr];
        System.arraycopy(this.data, 0, result, 0, this.curr);
        return result;
    }

    public CoordinateSequence toCoordinateSequence(GeometryFactory gf) {
        double[] data = this.getData();
        CoordinateSequence cs = gf.getCoordinateSequenceFactory().create(data.length / 2, 2);
        for (int i = 0; i < cs.size(); ++i) {
            cs.setOrdinate(i, 0, data[i * 2]);
            cs.setOrdinate(i, 1, data[i * 2 + 1]);
        }
        return cs;
    }

    public int size() {
        return this.curr;
    }

    public void setSize(int newSize) {
        if (newSize < 0) {
            throw new IllegalArgumentException("The size must zero or positive, it was " + newSize + " instead");
        }
        this.ensureLength(newSize);
        this.curr = newSize;
    }

    void ensureLength(int length) {
        if (this.data == null) {
            this.data = new double[length];
        } else {
            int currLength = this.data.length;
            if (length > currLength) {
                int newLength = currLength * 3 / 2 + 1;
                if (newLength < length) {
                    newLength = length;
                }
                double[] newData = new double[newLength];
                System.arraycopy(this.data, 0, newData, 0, currLength);
                this.data = newData;
            }
        }
    }

    public void reverseOrdinates(int start, int end) {
        int limit = (start + end) / 2;
        for (int i = start; i < limit; i += 2) {
            double tmp = this.data[i];
            int simmetric = end - (i - start) - 1;
            this.data[i] = this.data[simmetric];
            this.data[simmetric] = tmp;
            tmp = this.data[i + 1];
            simmetric = end - (i - start);
            this.data[i + 1] = this.data[simmetric];
            this.data[simmetric] = tmp;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GrowableDataArray(" + this.curr + ")[");
        for (int i = 0; i < this.curr; ++i) {
            sb.append(this.data[i]);
            if (i >= this.curr - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

