/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.expression.ExpressionAbstract;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;

public class FunctionImpl
extends ExpressionAbstract
implements Function {
    String name;
    List<Expression> params = Collections.emptyList();
    Literal fallbackValue;
    protected FunctionName functionName;
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    static Pattern PARAM = Pattern.compile("(\\w+)(?::([\\.\\w]*)(?::(\\d*),(\\d*))?+)?+");

    @Override
    public String getName() {
        if (this.name == null && this.functionName != null) {
            return this.functionName.getName();
        }
        return this.name;
    }

    @Override
    public synchronized FunctionName getFunctionName() {
        if (this.functionName == null) {
            this.functionName = new FunctionNameImpl(this.name, this.getParameters().size());
        }
        return this.functionName;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Expression> getParameters() {
        return new ArrayList<Expression>(this.params);
    }

    @Override
    public Object evaluate(Object object) {
        if (this.fallbackValue != null) {
            return this.fallbackValue.evaluate(object);
        }
        throw new UnsupportedOperationException("Function " + this.name + " not implemented");
    }

    public void setParameters(List<Expression> params) {
        this.params = params == null ? Collections.EMPTY_LIST : new ArrayList<Expression>(params);
    }

    public void setFallbackValue(Literal fallbackValue) {
        this.fallbackValue = fallbackValue;
    }

    @Override
    public Literal getFallbackValue() {
        return this.fallbackValue;
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    private void validateArguments() throws IllegalArgumentException {
        List<org.opengis.parameter.Parameter<?>> args = this.getFunctionName().getArguments();
        for (int i = 0; i < args.size(); ++i) {
            org.opengis.parameter.Parameter<?> arg = args.get(i);
            if (arg.getMaxOccurs() == 0) {
                throw new IllegalArgumentException(String.format("Argument %s has zero max", new Object[0]));
            }
            if (arg.getMinOccurs() == 1 && arg.getMaxOccurs() == 1 || i == args.size() - 1) continue;
            throw new IllegalArgumentException(String.format("Argument %s(%d,%d) invalid. Variable arguments must be the last argument of function.", arg.getName(), arg.getMinOccurs(), arg.getMaxOccurs()));
        }
    }

    protected LinkedHashMap<String, Object> dispatchArguments(Object obj) {
        LinkedHashMap<String, Object> prepped = new LinkedHashMap<String, Object>();
        List<org.opengis.parameter.Parameter<?>> args = this.getFunctionName().getArguments();
        List<Expression> expr = this.getParameters();
        if (expr.size() < args.size()) {
            org.opengis.parameter.Parameter<?> last = args.get(args.size() - 1);
            if (args.get(0).getMinOccurs() != 0) {
                throw new IllegalArgumentException(String.format("No arguments specified for arg %s, minOccurs = %d", last.getName().toString(), last.getMinOccurs()));
            }
        }
        for (int i = 0; i < expr.size(); ++i) {
            List<?> l;
            org.opengis.parameter.Parameter<?> arg = args.get(Math.min(i, args.size() - 1));
            String argName = arg.getName().toString();
            Object o = expr.get(i).evaluate(obj, arg.getType());
            if (o == null && expr.get(i).evaluate(obj) != null) {
                throw new IllegalArgumentException(String.format("Failure converting value for argument %s. %s could not be converted to %s", arg.getName(), obj.toString(), arg.getType().getName()));
            }
            if (prepped.containsKey(argName)) {
                if (arg.getMaxOccurs() == 1) {
                    throw new IllegalArgumentException(String.format("Multiple values specified for argument %s  but maxOccurs = 1", argName));
                }
                l = (List)prepped.get(argName);
                l.add(o);
                continue;
            }
            if (arg.getMaxOccurs() < 0 || arg.getMaxOccurs() > 1) {
                l = new ArrayList();
                l.add(o);
                prepped.put(argName, l);
                continue;
            }
            prepped.put(argName, o);
        }
        return prepped;
    }

    protected static FunctionName functionName(String name, String ret, String ... args) {
        ArrayList list = new ArrayList();
        for (String arg : args) {
            list.add(FunctionImpl.toParameter(arg));
        }
        return ff.functionName(name, list, FunctionImpl.toParameter(ret));
    }

    static org.opengis.parameter.Parameter toParameter(String param) throws IllegalArgumentException {
        Matcher m = PARAM.matcher(param);
        if (!m.matches()) {
            throw new IllegalArgumentException("Illegal parameter syntax: " + param);
        }
        String name = m.group(1);
        Class<Object> type = null;
        int min = 1;
        int max = 1;
        String grp = m.group(2);
        if ("".equals(grp)) {
            grp = null;
        }
        if (grp != null) {
            try {
                type = Class.forName(grp);
            }
            catch (ClassNotFoundException e) {
                try {
                    type = Class.forName("java.lang." + grp);
                }
                catch (ClassNotFoundException e1) {
                    try {
                        type = Class.forName("com.vividsolutions.jts.geom." + grp);
                    }
                    catch (ClassNotFoundException e2) {
                        throw (IllegalArgumentException)new IllegalArgumentException("Unknown type: " + grp).initCause(e);
                    }
                }
            }
        }
        if (type == null && "geom".equals(name)) {
            type = Geometry.class;
        }
        if (type == null) {
            type = Object.class;
        }
        if ((grp = m.group(3)) != null) {
            int n = min = !"".equals(grp) ? Integer.parseInt(grp) : -1;
        }
        if ((grp = m.group(4)) != null) {
            max = !"".equals(grp) ? Integer.parseInt(grp) : -1;
        }
        return new Parameter(name, type, min, max);
    }
}

