/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.PlanarImage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.resources.image.ImageUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.coverage.processing.OperationNotFoundException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public abstract class BaseScaleOperationJAI
extends OperationJAI {
    private static final long serialVersionUID = 1L;

    public BaseScaleOperationJAI(String operation) throws OperationNotFoundException {
        super(operation);
    }

    public BaseScaleOperationJAI(OperationDescriptor operation) {
        super(operation);
    }

    public BaseScaleOperationJAI(OperationDescriptor operation, ParameterDescriptorGroup descriptor) {
        super(operation, descriptor);
    }

    @Override
    protected GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, OperationJAI.Parameters parameters) {
        MathTransform finalTransform;
        ImageLayout layout;
        RenderingHints targetHints;
        int indexOfBorderExtenderParam;
        int indexOfInterpolationParam;
        try {
            indexOfInterpolationParam = parameters.parameters.indexOfParam("interpolation");
        }
        catch (IllegalArgumentException e) {
            indexOfInterpolationParam = -1;
        }
        try {
            indexOfBorderExtenderParam = parameters.parameters.indexOfParam("BorderExtender");
        }
        catch (IllegalArgumentException e) {
            indexOfBorderExtenderParam = -1;
        }
        Interpolation interpolation = (Interpolation)(indexOfInterpolationParam == -1 ? new InterpolationNearest() : parameters.parameters.getObjectParameter("interpolation"));
        BorderExtender borderExtender = indexOfBorderExtenderParam != -1 ? parameters.parameters.getObjectParameter("BorderExtender") : ImageUtilities.DEFAULT_BORDER_EXTENDER;
        GridCoverage2D sourceCoverage = sources[0];
        RenderedImage sourceImage = sourceCoverage.getRenderedImage();
        ViewType strategy = CoverageUtilities.preferredViewForOperation(sourceCoverage, interpolation, false, parameters.hints);
        switch (strategy) {
            case PHOTOGRAPHIC: {
                break;
            }
            case GEOPHYSICS: 
            case PACKED: {
                sourceCoverage = sourceCoverage.view(strategy);
                sourceImage = sourceCoverage.getRenderedImage();
            }
        }
        RenderingHints renderingHints = targetHints = parameters.hints != null ? parameters.hints : ImageUtilities.getRenderingHints(sourceImage);
        if (targetHints == null) {
            targetHints = new RenderingHints(null);
        }
        if (parameters.hints != null) {
            targetHints.add(parameters.hints);
        }
        if ((layout = (ImageLayout)targetHints.get(JAI.KEY_IMAGE_LAYOUT)) != null) {
            layout = (ImageLayout)layout.clone();
        } else {
            layout = new ImageLayout(sourceImage);
            layout.unsetTileLayout();
        }
        if ((layout.getValidMask() & 0xF0) == 0) {
            layout.setTileGridXOffset(layout.getMinX(sourceImage));
            layout.setTileGridYOffset(layout.getMinY(sourceImage));
            int width = layout.getWidth(sourceImage);
            int height = layout.getHeight(sourceImage);
            if (layout.getTileWidth(sourceImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight(sourceImage) > height) {
                layout.setTileHeight(height);
            }
        }
        targetHints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        targetHints.put(JAI.KEY_BORDER_EXTENDER, borderExtender);
        if (strategy != ViewType.PHOTOGRAPHIC) {
            targetHints.add(ImageUtilities.DONT_REPLACE_INDEX_COLOR_MODEL);
        } else {
            targetHints.add(ImageUtilities.REPLACE_INDEX_COLOR_MODEL);
            layout.unsetValid(512);
            layout.unsetValid(256);
        }
        RenderedImage image = this.createRenderedImage(parameters.parameters, targetHints);
        double scaleX = (double)image.getWidth() / (1.0 * (double)sourceImage.getWidth());
        double scaleY = (double)image.getHeight() / (1.0 * (double)sourceImage.getHeight());
        double tX = (double)image.getMinX() - (double)sourceImage.getMinX() * scaleX;
        double tY = (double)image.getMinY() - (double)sourceImage.getMinY() * scaleY;
        AffineTransform scaleTranslate = new AffineTransform(scaleX, 0.0, 0.0, scaleY, tX, tY);
        try {
            scaleTranslate.invert();
            scaleTranslate.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            AffineTransform2D tr = new AffineTransform2D(scaleTranslate);
            finalTransform = ConcatenatedTransform.create(tr, sourceCoverage.getGridGeometry().getGridToCRS2D());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        InternationalString name = this.deriveName(sources, 0, parameters);
        Map<String, ?> properties = this.getProperties(image, parameters.crs, name, finalTransform, sources, parameters);
        GridGeometry2D gg2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage(image).getBounds()), PixelInCell.CELL_CORNER, finalTransform, parameters.crs, null);
        GridCoverage2D result = BaseScaleOperationJAI.getFactory(parameters.hints).create((CharSequence)name, image, gg2D, strategy == ViewType.PHOTOGRAPHIC ? null : (GridSampleDimension[])sourceCoverage.getSampleDimensions().clone(), (GridCoverage[])sources, properties);
        if (strategy == ViewType.GEOPHYSICS) {
            return result.view(ViewType.PACKED);
        }
        if (strategy == ViewType.PACKED) {
            return result.view(ViewType.GEOPHYSICS);
        }
        return result;
    }
}

