/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FilterDOMParser {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter");
    private static final FilterFactory2 FILTER_FACT = CommonFactoryFinder.getFilterFactory2(null);
    private static final int NUM_BETWEEN_CHILDREN = 3;
    private static Map comparisions = new HashMap();
    private static Map spatial = new HashMap();
    private static Map logical = new HashMap();

    private FilterDOMParser() {
    }

    public static Filter parseFilter(Node root) {
        ExpressionDOMParser expressionDOMParser = new ExpressionDOMParser(FILTER_FACT);
        if (root == null || root.getNodeType() != 1) {
            LOGGER.finest("bad node input ");
            return null;
        }
        LOGGER.finer("parsingFilter " + root.getLocalName());
        LOGGER.finest("processing root " + root.getLocalName() + " " + root.getNodeName());
        Node child = root;
        String childName = child.getLocalName();
        if (childName == null) {
            childName = child.getNodeName();
        }
        if (childName.indexOf(58) != -1) {
            childName = childName.substring(childName.indexOf(58) + 1);
        }
        LOGGER.finest("looking up " + childName);
        if (comparisions.containsKey(childName)) {
            LOGGER.finer("a comparision filter " + childName);
            try {
                short type = ((Integer)comparisions.get(childName)).shortValue();
                LOGGER.finer("type is " + type);
                if (type == 22) {
                    HashSet<FeatureId> ids = new HashSet<FeatureId>();
                    Element fidElement = (Element)child;
                    ids.add(FILTER_FACT.featureId(fidElement.getAttribute("fid")));
                    for (Node sibling = fidElement.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                        LOGGER.finer("Parsing another FidFilter");
                        if (sibling.getNodeType() != 1) continue;
                        fidElement = (Element)sibling;
                        String fidElementName = fidElement.getLocalName();
                        if (fidElementName == null) {
                            fidElementName = fidElement.getNodeName();
                        }
                        if (fidElementName.indexOf(58) != -1) {
                            fidElementName = fidElementName.substring(fidElementName.indexOf(58) + 1);
                        }
                        if (!"FeatureId".equals(fidElementName)) continue;
                        ids.add(FILTER_FACT.featureId(fidElement.getAttribute("fid")));
                    }
                    return FILTER_FACT.id(ids);
                }
                if (type == 19) {
                    NodeList kids = child.getChildNodes();
                    if (kids.getLength() < 3) {
                        throw new IllegalFilterException("wrong number of children in Between filter: expected 3 got " + kids.getLength());
                    }
                    Node value = child.getFirstChild();
                    while (value.getNodeType() != 1) {
                        value = value.getNextSibling();
                    }
                    LOGGER.finer("add middle value -> " + value + "<-");
                    Expression middle = expressionDOMParser.expression(value);
                    Expression lower = null;
                    Expression upper = null;
                    for (int i = 0; i < kids.getLength(); ++i) {
                        String kidName;
                        Node kid = kids.item(i);
                        String string = kidName = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (kidName.indexOf(58) != -1) {
                            kidName = kidName.substring(kidName.indexOf(58) + 1);
                        }
                        if (kidName.equalsIgnoreCase("LowerBoundary")) {
                            value = kid.getFirstChild();
                            while (value.getNodeType() != 1) {
                                value = value.getNextSibling();
                            }
                            LOGGER.finer("add left value -> " + value + "<-");
                            lower = expressionDOMParser.expression(value);
                        }
                        if (!kidName.equalsIgnoreCase("UpperBoundary")) continue;
                        value = kid.getFirstChild();
                        while (value.getNodeType() != 1) {
                            value = value.getNextSibling();
                        }
                        LOGGER.finer("add right value -> " + value + "<-");
                        upper = expressionDOMParser.expression(value);
                    }
                    return FILTER_FACT.between(middle, lower, upper);
                }
                if (type == 20) {
                    String wildcard = null;
                    String single = null;
                    String escape = null;
                    String pattern = null;
                    Object value = null;
                    NodeList map = child.getChildNodes();
                    for (int i = 0; i < map.getLength(); ++i) {
                        String res;
                        Node kid = map.item(i);
                        if (kid == null || kid.getNodeType() != 1) continue;
                        String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (res.indexOf(58) != -1) {
                            res = res.substring(res.indexOf(58) + 1);
                        }
                        if (res.equalsIgnoreCase("PropertyName")) {
                            value = expressionDOMParser.expression(kid);
                        }
                        if (!res.equalsIgnoreCase("Literal")) continue;
                        pattern = expressionDOMParser.expression(kid).toString();
                    }
                    NamedNodeMap kids = child.getAttributes();
                    for (int i = 0; i < kids.getLength(); ++i) {
                        String res;
                        Node kid = kids.item(i);
                        String string = res = kid.getLocalName() != null ? kid.getLocalName() : kid.getNodeName();
                        if (res.indexOf(58) != -1) {
                            res = res.substring(res.indexOf(58) + 1);
                        }
                        if (res.equalsIgnoreCase("wildCard")) {
                            wildcard = kid.getNodeValue();
                        }
                        if (res.equalsIgnoreCase("singleChar")) {
                            single = kid.getNodeValue();
                        }
                        if (!res.equalsIgnoreCase("escapeChar") && !res.equalsIgnoreCase("escape")) continue;
                        escape = kid.getNodeValue();
                    }
                    if (wildcard != null && single != null && escape != null && pattern != null) {
                        LOGGER.finer("Building like filter " + value.toString() + "\n" + pattern + " " + wildcard + " " + single + " " + escape);
                        return FILTER_FACT.like((Expression)value, pattern, wildcard, single, escape);
                    }
                    LOGGER.finer("Problem building like filter\n" + pattern + " " + wildcard + " " + single + " " + escape);
                    return null;
                }
                if (type == 21) {
                    return FilterDOMParser.parseNullFilter(child);
                }
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add left value -> " + value + "<-");
                Expression left = expressionDOMParser.expression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add right value -> " + value + "<-");
                Expression right = expressionDOMParser.expression(value);
                switch (type) {
                    case 14: {
                        return FILTER_FACT.equals(left, right);
                    }
                    case 16: {
                        return FILTER_FACT.greater(left, right);
                    }
                    case 18: {
                        return FILTER_FACT.greaterOrEqual(left, right);
                    }
                    case 15: {
                        return FILTER_FACT.less(left, right);
                    }
                    case 17: {
                        return FILTER_FACT.lessOrEqual(left, right);
                    }
                    case 23: {
                        return FILTER_FACT.notEqual(left, right, true);
                    }
                }
                LOGGER.warning("Unable to build filter for " + childName);
                return null;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + ife);
                return null;
            }
        }
        if (spatial.containsKey(childName)) {
            LOGGER.finest("a spatial filter " + childName);
            try {
                Expression right;
                String valueName;
                short type = ((Integer)spatial.get(childName)).shortValue();
                Node value = child.getFirstChild();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add left value -> " + value + "<-");
                Expression left = expressionDOMParser.expression(value);
                value = value.getNextSibling();
                while (value.getNodeType() != 1) {
                    value = value.getNextSibling();
                }
                LOGGER.finest("add right value -> " + value + "<-");
                String string = valueName = value.getLocalName() != null ? value.getLocalName() : value.getNodeName();
                if (valueName.indexOf(58) != -1) {
                    valueName = valueName.substring(valueName.indexOf(58) + 1);
                }
                Node nextNode = value.getNextSibling();
                if (!valueName.equalsIgnoreCase("Literal") && !valueName.equalsIgnoreCase("propertyname")) {
                    Element literal = value.getOwnerDocument().createElement("literal");
                    literal.appendChild(value);
                    LOGGER.finest("Built new literal " + literal);
                    right = expressionDOMParser.expression(literal);
                } else {
                    right = expressionDOMParser.expression(value);
                }
                String units = null;
                String nodeName = null;
                switch (type) {
                    case 5: {
                        return FILTER_FACT.equal(left, right);
                    }
                    case 6: {
                        return FILTER_FACT.disjoint(left, right);
                    }
                    case 7: {
                        return FILTER_FACT.intersects(left, right);
                    }
                    case 8: {
                        return FILTER_FACT.touches(left, right);
                    }
                    case 9: {
                        return FILTER_FACT.crosses(left, right);
                    }
                    case 10: {
                        return FILTER_FACT.within(left, right);
                    }
                    case 11: {
                        return FILTER_FACT.contains(left, right);
                    }
                    case 12: {
                        return FILTER_FACT.overlaps(left, right);
                    }
                    case 24: {
                        for (value = nextNode; value != null && value.getNodeType() != 1; value = value.getNextSibling()) {
                        }
                        if (value == null) {
                            throw new IllegalFilterException("DWithin is missing the Distance element");
                        }
                        nodeName = value.getNodeName();
                        if (nodeName.indexOf(58) > 0) {
                            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
                        }
                        if (!"Distance".equals(nodeName)) {
                            throw new IllegalFilterException("Parsing DWithin, was expecting to find Distance but found " + value.getLocalName());
                        }
                        double distance = Double.parseDouble(value.getTextContent());
                        if (value.getAttributes().getNamedItem("units") != null) {
                            units = value.getAttributes().getNamedItem("units").getTextContent();
                        }
                        return FILTER_FACT.dwithin(left, right, distance, units);
                    }
                    case 13: {
                        for (value = nextNode; value != null && value.getNodeType() != 1; value = value.getNextSibling()) {
                        }
                        if (value == null) {
                            throw new IllegalFilterException("Beyond is missing the Distance element");
                        }
                        nodeName = value.getNodeName();
                        if (nodeName.indexOf(58) > 0) {
                            nodeName = nodeName.substring(nodeName.indexOf(":") + 1);
                        }
                        if (!"Distance".equals(nodeName)) {
                            throw new IllegalFilterException("Parsing Beyond, was expecting to find Distance but found " + value.getLocalName());
                        }
                        double distance = Double.parseDouble(value.getTextContent());
                        if (value.getAttributes().getNamedItem("units") != null) {
                            units = value.getAttributes().getNamedItem("units").getTextContent();
                        }
                        return FILTER_FACT.beyond(left, right, distance, units);
                    }
                    case 4: {
                        Literal literal = (Literal)right;
                        Object obj = literal.getValue();
                        ReferencedEnvelope bbox = null;
                        if (obj instanceof Geometry) {
                            bbox = JTS.toEnvelope((Geometry)obj);
                        } else if (obj instanceof ReferencedEnvelope) {
                            bbox = (ReferencedEnvelope)((Object)obj);
                        } else if (obj instanceof Envelope) {
                            bbox = new ReferencedEnvelope((Envelope)obj, null);
                        }
                        return FILTER_FACT.bbox(left, (BoundingBox)bbox);
                    }
                }
                LOGGER.warning("Unable to build filter: " + childName);
                return null;
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + ife);
                return null;
            }
        }
        if (logical.containsKey(childName)) {
            LOGGER.finest("a logical filter " + childName);
            try {
                ArrayList<Filter> children = new ArrayList<Filter>();
                NodeList map = child.getChildNodes();
                for (int i = 0; i < map.getLength(); ++i) {
                    Node kid = map.item(i);
                    if (kid == null || kid.getNodeType() != 1) continue;
                    LOGGER.finest("adding to logic filter " + kid.getLocalName());
                    children.add(FilterDOMParser.parseFilter(kid));
                }
                if (childName.equals("And")) {
                    return FILTER_FACT.and(children);
                }
                if (childName.equals("Or")) {
                    return FILTER_FACT.or(children);
                }
                if (childName.equals("Not")) {
                    if (children.size() != 1) {
                        throw new IllegalFilterException("Filter negation can be applied to one and only one child filter");
                    }
                    return FILTER_FACT.not((Filter)children.get(0));
                }
                throw new RuntimeException("Logical filter, but not And, Or, Not? This should not happen");
            }
            catch (IllegalFilterException ife) {
                LOGGER.warning("Unable to build filter: " + ife);
                return null;
            }
        }
        LOGGER.warning("unknown filter " + root);
        return null;
    }

    private static PropertyIsNull parseNullFilter(Node nullNode) throws IllegalFilterException {
        ExpressionDOMParser expressionDOMParser = new ExpressionDOMParser(FILTER_FACT);
        LOGGER.finest("parsing null node: " + nullNode);
        Node value = nullNode.getFirstChild();
        while (value.getNodeType() != 1) {
            value = value.getNextSibling();
        }
        LOGGER.finest("add null value -> " + value + "<-");
        Expression expr = expressionDOMParser.expression(value);
        return FILTER_FACT.isNull(expr);
    }

    static {
        comparisions.put("PropertyIsEqualTo", new Integer(14));
        comparisions.put("PropertyIsNotEqualTo", new Integer(23));
        comparisions.put("PropertyIsGreaterThan", new Integer(16));
        comparisions.put("PropertyIsGreaterThanOrEqualTo", new Integer(18));
        comparisions.put("PropertyIsLessThan", new Integer(15));
        comparisions.put("PropertyIsLessThanOrEqualTo", new Integer(17));
        comparisions.put("PropertyIsLike", new Integer(20));
        comparisions.put("PropertyIsNull", new Integer(21));
        comparisions.put("PropertyIsBetween", new Integer(19));
        comparisions.put("FeatureId", new Integer(22));
        spatial.put("Equals", new Integer(5));
        spatial.put("Disjoint", new Integer(6));
        spatial.put("Intersects", new Integer(7));
        spatial.put("Touches", new Integer(8));
        spatial.put("Crosses", new Integer(9));
        spatial.put("Within", new Integer(10));
        spatial.put("Contains", new Integer(11));
        spatial.put("Overlaps", new Integer(12));
        spatial.put("BBOX", new Integer(4));
        spatial.put("Beyond", new Integer(13));
        spatial.put("DWithin", new Integer(24));
        logical.put("And", new Integer(2));
        logical.put("Or", new Integer(1));
        logical.put("Not", new Integer(3));
    }
}

