/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.sort;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKBWriter;
import java.awt.RenderingHints;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.DelegateSimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureReader;
import org.geotools.data.sort.CompositeComparator;
import org.geotools.data.sort.FeatureBlockReader;
import org.geotools.data.sort.FidComparator;
import org.geotools.data.sort.MergeSortReader;
import org.geotools.data.sort.PropertyComparator;
import org.geotools.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

class MergeSortDumper {
    MergeSortDumper() {
    }

    static final boolean canSort(SimpleFeatureType schema, SortBy[] sortBy) {
        if (sortBy == SortBy.UNSORTED) {
            return true;
        }
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            Class binding = ad.getType().getBinding();
            if (Serializable.class.isAssignableFrom(binding)) continue;
            return false;
        }
        for (SortBy sb : sortBy) {
            if (sb == SortBy.NATURAL_ORDER || sb == SortBy.REVERSE_ORDER) continue;
            AttributeDescriptor ad = schema.getDescriptor(sb.getPropertyName().getPropertyName());
            Class binding = ad.getType().getBinding();
            if (ad != null && Comparable.class.isAssignableFrom(binding) && !Geometry.class.isAssignableFrom(binding)) continue;
            return false;
        }
        return true;
    }

    static SimpleFeatureReader getDelegateReader(SimpleFeatureReader reader, Query query) throws IOException {
        int maxFeatures = MergeSortDumper.getMaxFeatures(query);
        return MergeSortDumper.getDelegateReader(reader, query.getSortBy(), maxFeatures);
    }

    static int getMaxFeatures(Query query) {
        Hints hints = null;
        if (query != null) {
            hints = query.getHints();
        }
        int maxFeatures = 1000;
        if (hints != null && hints.get((Object)Hints.MAX_MEMORY_SORT) != null) {
            maxFeatures = (Integer)hints.get((Object)Hints.MAX_MEMORY_SORT);
        } else if (Hints.getSystemDefault((RenderingHints.Key)Hints.MAX_MEMORY_SORT) != null) {
            maxFeatures = (Integer)Hints.getSystemDefault((RenderingHints.Key)Hints.MAX_MEMORY_SORT);
        }
        return maxFeatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SimpleFeatureReader getDelegateReader(SimpleFeatureReader reader, SortBy[] sortBy, int maxFeatures) throws IOException {
        Comparator<SimpleFeature> comparator;
        if (maxFeatures < 0) {
            maxFeatures = MergeSortDumper.getMaxFeatures(Query.ALL);
        }
        if ((comparator = MergeSortDumper.getComparator(sortBy)) == null) {
            return reader;
        }
        SimpleFeatureType schema = (SimpleFeatureType)reader.getFeatureType();
        if (!MergeSortDumper.canSort(schema, sortBy)) {
            throw new IllegalArgumentException("The specified reader cannot be sorted, either the sorting properties are not comparable or the attributes are not serializable");
        }
        int count = 0;
        File file = null;
        RandomAccessFile raf = null;
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        ArrayList<FeatureBlockReader> readers = new ArrayList<FeatureBlockReader>();
        boolean cleanFile = true;
        try {
            while (reader.hasNext()) {
                SimpleFeature f = (SimpleFeature)reader.next();
                features.add(f);
                if (++count <= maxFeatures) continue;
                Collections.sort(features, comparator);
                if (raf == null) {
                    file = File.createTempFile("sorted", ".features");
                    file.delete();
                    raf = new RandomAccessFile(file, "rw");
                }
                FeatureBlockReader fbr = MergeSortDumper.storeToFile(raf, features, schema);
                readers.add(fbr);
                count = 0;
                features.clear();
            }
            if (raf == null) {
                Collections.sort(features, comparator);
                SimpleFeatureIterator fi = new ListFeatureCollection(schema, features).features();
                DelegateSimpleFeatureReader delegateSimpleFeatureReader = new DelegateSimpleFeatureReader(schema, fi);
                return delegateSimpleFeatureReader;
            }
            cleanFile = false;
            MergeSortReader mergeSortReader = new MergeSortReader(schema, raf, file, readers, comparator);
            return mergeSortReader;
        }
        finally {
            if (cleanFile && raf != null) {
                raf.close();
                file.delete();
            }
            reader.close();
        }
    }

    static FeatureBlockReader storeToFile(RandomAccessFile raf, List<SimpleFeature> features, SimpleFeatureType schema) throws IOException {
        long start = raf.getFilePointer();
        List attributes = schema.getAttributeDescriptors();
        for (SimpleFeature sf : features) {
            raf.writeUTF(sf.getID());
            for (AttributeDescriptor ad : attributes) {
                Object value = sf.getAttribute(ad.getLocalName());
                MergeSortDumper.writeAttribute(raf, ad, value);
            }
        }
        return new FeatureBlockReader(raf, start, features.size(), schema);
    }

    static void writeAttribute(RandomAccessFile raf, AttributeDescriptor ad, Object value) throws IOException {
        if (value == null) {
            raf.writeBoolean(true);
        } else {
            raf.writeBoolean(false);
            Class binding = ad.getType().getBinding();
            if (binding == Boolean.class) {
                raf.writeBoolean((Boolean)value);
            } else if (binding == Byte.class || binding == Byte.TYPE) {
                raf.writeByte(((Byte)value).byteValue());
            } else if (binding == Short.class || binding == Short.TYPE) {
                raf.writeShort(((Short)value).shortValue());
            } else if (binding == Integer.class || binding == Integer.TYPE) {
                raf.writeInt((Integer)value);
            } else if (binding == Long.class || binding == Long.TYPE) {
                raf.writeLong((Long)value);
            } else if (binding == Float.class || binding == Float.TYPE) {
                raf.writeFloat(((Float)value).floatValue());
            } else if (binding == Double.class || binding == Double.TYPE) {
                raf.writeDouble((Double)value);
            } else if (binding == String.class) {
                raf.writeUTF((String)value);
            } else if (binding == Date.class || binding == Time.class || binding == Timestamp.class || binding == java.util.Date.class) {
                raf.writeLong(((java.util.Date)value).getTime());
            } else if (Geometry.class.isAssignableFrom(binding)) {
                WKBWriter writer = new WKBWriter();
                byte[] buffer = writer.write((Geometry)value);
                int length = buffer.length;
                raf.writeInt(length);
                raf.write(buffer);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(value);
                oos.flush();
                byte[] bytes = bos.toByteArray();
                raf.writeInt(bytes.length);
                raf.write(bytes);
            }
        }
    }

    static Comparator<SimpleFeature> getComparator(SortBy[] sortBy) {
        if (sortBy == SortBy.UNSORTED || sortBy == null) {
            return null;
        }
        ArrayList<Comparator<SimpleFeature>> comparators = new ArrayList<Comparator<SimpleFeature>>();
        for (SortBy sb : sortBy) {
            if (sb == SortBy.NATURAL_ORDER) {
                comparators.add(new FidComparator(true));
                continue;
            }
            if (sb == SortBy.REVERSE_ORDER) {
                comparators.add(new FidComparator(false));
                continue;
            }
            String name = sb.getPropertyName().getPropertyName();
            boolean ascending = sb.getSortOrder() == SortOrder.ASCENDING;
            comparators.add(new PropertyComparator(name, ascending));
        }
        if (comparators.size() == 1) {
            return (Comparator)comparators.get(0);
        }
        return new CompositeComparator(comparators);
    }
}

