/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.MultiCurve;

public class CurvedGeometryFactory
extends GeometryFactory {
    private static final long serialVersionUID = -298811277709598383L;
    GeometryFactory delegate;
    double tolerance;

    public CurvedGeometryFactory(double tolerance) {
        this(new GeometryFactory(), tolerance);
    }

    public CurvedGeometryFactory(GeometryFactory delegate, double tolerance) {
        this.tolerance = tolerance;
        this.delegate = delegate;
    }

    public LineString createCurvedGeometry(int dimension, double ... controlPoints) {
        if (dimension != 2) {
            throw new IllegalArgumentException("Invalid dimension value, right now only 2 dimensional curves are supported");
        }
        if (controlPoints[0] == controlPoints[controlPoints.length - 2] && controlPoints[1] == controlPoints[controlPoints.length - 1]) {
            return new CircularRing(controlPoints, (GeometryFactory)this, this.tolerance);
        }
        return new CircularString(controlPoints, (GeometryFactory)this, this.tolerance);
    }

    public LineString createCurvedGeometry(CoordinateSequence cs) {
        int lastCoordinate = cs.size() - 1;
        if (cs.getOrdinate(0, 0) == cs.getOrdinate(lastCoordinate, 0) && cs.getOrdinate(0, 1) == cs.getOrdinate(lastCoordinate, 1)) {
            return new CircularRing(cs, (GeometryFactory)this, this.tolerance);
        }
        return new CircularString(cs, (GeometryFactory)this, this.tolerance);
    }

    public LineString createCurvedGeometry(LineString ... components) {
        if (components == null) {
            return this.createLineString(new Coordinate[0]);
        }
        return this.createCurvedGeometry(Arrays.asList(components));
    }

    public LineString createCurvedGeometry(List<LineString> components) {
        if (components.isEmpty()) {
            return this.createLineString(new Coordinate[0]);
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        LineString first = components.get(0);
        LineString last = components.get(components.size() - 1);
        if (first.getStartPoint().equals((Geometry)last.getEndPoint())) {
            return new CompoundRing(components, this, this.tolerance);
        }
        return new CompoundCurve(components, this, this.tolerance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        long temp = Double.doubleToLongBits(this.tolerance);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CurvedGeometryFactory other = (CurvedGeometryFactory)((Object)obj);
        if (this.delegate == null ? other.delegate != null : !this.delegate.equals(other.delegate)) {
            return false;
        }
        return Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(other.tolerance);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public String toString() {
        return "CurvedGeometryFactory [delegate=" + this.delegate + ", tolerance=" + this.tolerance + "]";
    }

    public Geometry toGeometry(Envelope envelope) {
        return this.delegate.toGeometry(envelope);
    }

    public PrecisionModel getPrecisionModel() {
        return this.delegate.getPrecisionModel();
    }

    public Point createPoint(Coordinate coordinate) {
        return this.delegate.createPoint(coordinate);
    }

    public Point createPoint(CoordinateSequence coordinates) {
        return this.delegate.createPoint(coordinates);
    }

    public MultiLineString createMultiLineString(LineString[] lineStrings) {
        boolean curved = false;
        for (LineString ls : lineStrings) {
            if (!(ls instanceof CurvedGeometry)) continue;
            curved = true;
            break;
        }
        if (curved) {
            return new MultiCurve(Arrays.asList(lineStrings), this, this.tolerance);
        }
        return this.delegate.createMultiLineString(lineStrings);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        return this.delegate.createGeometryCollection(geometries);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygons) {
        return this.delegate.createMultiPolygon(polygons);
    }

    public LinearRing createLinearRing(Coordinate[] coordinates) {
        return this.delegate.createLinearRing(coordinates);
    }

    public LinearRing createLinearRing(CoordinateSequence coordinates) {
        return this.delegate.createLinearRing(coordinates);
    }

    public MultiPoint createMultiPoint(Point[] point) {
        return this.delegate.createMultiPoint(point);
    }

    public MultiPoint createMultiPoint(Coordinate[] coordinates) {
        return this.delegate.createMultiPoint(coordinates);
    }

    public MultiPoint createMultiPoint(CoordinateSequence coordinates) {
        return this.delegate.createMultiPoint(coordinates);
    }

    public Polygon createPolygon(LinearRing shell, LinearRing[] holes) {
        return this.delegate.createPolygon(shell, holes);
    }

    public Polygon createPolygon(CoordinateSequence coordinates) {
        return this.delegate.createPolygon(coordinates);
    }

    public Polygon createPolygon(Coordinate[] coordinates) {
        return this.delegate.createPolygon(coordinates);
    }

    public Polygon createPolygon(LinearRing shell) {
        return this.delegate.createPolygon(shell);
    }

    public Geometry buildGeometry(Collection geomList) {
        return this.delegate.buildGeometry(geomList);
    }

    public LineString createLineString(Coordinate[] coordinates) {
        return this.delegate.createLineString(coordinates);
    }

    public LineString createLineString(CoordinateSequence coordinates) {
        return this.delegate.createLineString(coordinates);
    }

    public Geometry createGeometry(Geometry g) {
        return this.delegate.createGeometry(g);
    }

    public int getSRID() {
        return this.delegate.getSRID();
    }

    public CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.delegate.getCoordinateSequenceFactory();
    }
}

